unit About;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: EditGroup.pas, released 12 May 2002.

The Original Code is: About.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 07/25/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.


Purpose:
This form is used to display a standard "About" dialog box with a few extra wrinkles.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, ExtCtrls, Forms, StdCtrls,
  ShellAPI, Graphics, Controls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, ExtCtrls, Forms, Graphics, StdCtrls,
  ShellAPI,
{$ENDIF}
{$IFDEF LINUX}
  Libc,
  QButtons, QControls, QExtCtrls, QForms, QGraphics, QStdCtrls,
  QDialogs,
{$ENDIF}
  Fileinfo, Misc;

type
  TAboutBox = class(TForm)
    Panel1: TPanel;
    ResourcesLabel: TLabel;
    OSLabel: TLabel;
    URLLabel: TLabel;
    CommentsLabel: TLabel;
    CompanyLabel: TLabel;
    EmailLabel: TLabel;
    MailImage: TImage;
    OSBuildLabel: TLabel;
    OKBitBtn: TBitBtn;
    ProductLabel: TLabel;
    VersionLabel: TLabel;
    CopyrightLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure URLLabelClick(Sender: TObject);
    procedure ProgramIconClick(Sender: TObject);
    procedure EmailLabelClick(Sender: TObject);
  private
    ProgramIcon: TImage;
  public
    procedure DoGeometry;
    procedure DoHintsFromResource;
  end;

var
  AboutBox: TAboutBox;
  {This is the "About" dialog box that TAboutDlg displays
   when its Execute function is called.}
  {}
  {As well as the properties mentioned elsewhere, it also shows the
   free resources and operating system.}


implementation

{$R *.dfm}

{Load the Delphi or Kylix monikers:}
{$IFDEF WIN32}
  {$IFDEF DELPHI}
    {$R Delphi24.res}
  {$ENDIF}
  {$IFDEF BCB}
    {$R Builder24.res}
  {$ENDIF}
{$ENDIF}
{$IFDEF LINUX}
  {$R Kylix24.res}
{$ENDIF}

{------------------------------------------------------------------------------
    Procedure: TAboutBox.FormCreate
  Description: standard FormCreate event handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets various Properties by querying the OS
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.FormCreate(Sender: TObject);
var
{$IFDEF WINDOWS} {Delphi 1}
  OS_Version: Longint;
  DOS, WIN: Integer;
  DOS_Minor, DOS_Major, WIN_Minor, WIN_Major: Integer;
{$ENDIF}
{$IFDEF WIN32}
  Memory_Info: TMEMORYSTATUS;
  Version_Info: TOSVERSIONINFO;
  Info: TFileVersionInfo;
{$ENDIF}
{$IFDEF LINUX}
  MySysInfo: TSysInfo;
  MachineInfo: TUTSName;
  {ResStrings: TStringList;
  ResourceStream: TResourceStream;}
{$ENDIF}
begin
  ProgramIcon := TImage.Create(Self);
  ProgramIcon.Parent := Panel1;
  ProgramIcon.Left := 8;
  ProgramIcon.Top := 8;
{$IFDEF COMPILER2_UP}
  ProgramIcon.Picture.Bitmap.LoadFromResourceID(hInstance, 100);
{$ENDIF}
  ProgramIcon.AutoSize := TRUE;

  DoHintsFromResource;

  CommentsLabel.Width := Panel1.Width - CommentsLabel.Left;
{$IFDEF WINDOWS} {Delphi 1}
  ResourcesLabel.Caption :=
    'Free Resources: ' + IntToStr(GetFreeSpace(0) div (1024 * 1024)) + ' M - ' +
    IntToStr(GetFreeSystemResources(0)) + '/' +
    IntToStr(GetFreeSystemResources(1)) + '/' +
    IntToStr(GetFreeSystemResources(2)) + ' %';

  OS_Version := GetVersion;
  DOS := OS_Version div 65536;
  WIN := OS_Version - 65536 * DOS;
  DOS_Major := DOS div 256;
  DOS_Minor := DOS - 256 * DOS_Major;
  WIN_Minor := WIN div 256;
  WIN_Major := WIN - 256 * WIN_Minor;

  OSLabel.Caption :=
    'DOS Version: ' + IntToStr(DOS_Major) + '.' + IntToStr(DOS_Minor) +
    ' / Windows Version: ' + IntToStr(WIN_Major) + '.' + IntToStr(WIN_Minor);
{$ENDIF}
{$IFDEF WIN32}
  Memory_Info.dwLength := 32;
  GlobalMemoryStatus(Memory_Info);

  {MemoryLabel.Caption := 'Used Memory: ' +
   IntToStr(Memory_Info.dwMemoryLoad) + ' %'; - always zero}
  ResourcesLabel.Caption := 'Total Free Memory ' +
    FloatToStrF(Memory_Info.dwAvailPhys / 1048576.0, ffFixed, 7, 3) + ' / ' +
    FloatToStrF(Memory_Info.dwTotalPhys / 1048576.0, ffFixed, 7, 3) + ' M';

  Version_Info.dwOSVersionInfoSize := 148;
  GetVersionEx(Version_Info);
  with Version_Info do
  begin
    Case Version_Info.dwPlatformId of
      VER_PLATFORM_WIN32_WINDOWS:
        begin
          dwBuildNumber := dwBuildNumber and 65535;
          case dwMajorVersion of
            3: OSLabel.Caption := Format(
              'Windows 95 (%d.%d), build %d, ' + String(szCSDVersion),
              [dwMajorVersion, dwMinorVersion, dwBuildNumber]);
            4:
              begin
                case dwMinorVersion of
                  0:
                    begin
                      OSLabel.Caption := Format(
                        'Windows 95' + String(szCSDVersion) + '(%d.%d)',
                        [dwMajorVersion, dwMinorVersion]);
                      OSBuildLabel.Caption :=
                        Format('build %d' + String(szCSDVersion),
                        [dwBuildNumber]);
                    end;
                  10:
                    begin
                      OSLabel.Caption := 'Windows 98';
                      if (dwBuildNumber = 2222) then
                        OSLabel.Caption := OSLabel.Caption + 'SE';
                      OSLabel.Caption := OSLabel.Caption +
                        Format(' (%d.%d)',
                        [dwMajorVersion, dwMinorVersion]);
                      OSBuildLabel.Caption :=
                        Format('build %d' + String(szCSDVersion),
                        [dwBuildNumber]);
                    end;
                else
                  begin
                    OSLabel.Caption := Format(
                      'Windows ME (%d.%d)',
                      [dwMajorVersion, dwMinorVersion]);
                    OSBuildLabel.Caption :=
                      Format('build %d' + String(szCSDVersion),
                      [dwBuildNumber]);
                  end;
                end; {case}
              end; {4}
          end; {case}
        end; {WIN32}
      VER_PLATFORM_WIN32_NT:
        begin
          if ((dwMajorVersion = 5) and (dwMinorVersion = 0)) then
            OSLabel.Caption := 'Windows 2000 (5.0)'
          else if ((dwMajorVersion = 5) and (dwMinorVersion = 1)) then
            OSLabel.Caption := 'Windows XP (5.1)'
           else
             OSLabel.Caption :=
               Format('Windows NT %d.%d', [dwMajorVersion, dwMinorVersion]);
          OSBuildLabel.Caption :=
            Format('build %d %s', [dwBuildNumber, szCSDVersion]);
        end
        else
          OSLabel.Caption := 'Damned if I know !';
    end;
  end;
{get version information:}
  Info := TFileVersionInfo.Create(self);
  Info.ExecutableFile := Application.ExeName;
  ProductLabel.Caption := Info.ProductName;
  CompanyLabel.Caption := 'By ' + Info.CompanyName;
  VersionLabel.Caption := 'Version ' + Info.FileVersion;
  CopyrightLabel.Caption := Info.LegalCopyright;
  CommentsLabel.Caption := Info.Comments;
  Info.Free;
{$ENDIF}


{$IFDEF LINUX}
  {ResourceStream := TResourceStream.Create(hInstance, 'fileversion', 'RT_VERSION');
  ResStrings := TStringList.Create;
  //ResourceStream.Read(Pointer(ResString)^, ResourceStream.Size);
  ResStrings.LoadFromStream(ResourceStream);
  ShowMessage(ResStrings.Text);
  //ResStrings.SaveToFile('/home/matb/ResStrings.txt');
  //CompanyLabel.Caption := 'by ' + ResString;
  ResourceStream.Free;
  ResStrings.Free;}

  // Investigate /proc/self/stat[m]

  Libc.sysinfo(MySysInfo);
  ResourcesLabel.Caption :=
    Format('Free Total Memory: %d/%d M, %d cpus',
      [MySysInfo.freeram div 1048576,
       MySysInfo.totalram div 1048576,
       get_nprocs]);
  Libc.uname(MachineInfo);
  OSLabel.Caption := MachineInfo.sysname + ' ' +
    MachineInfo.release + ' on ' +
    MachineInfo.machine;
  OSBuildLabel.Caption := MachineInfo.version;
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TAboutBox.DoHintsFromResource
  Description: standard loading of hints from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display hints in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.DoHintsFromResource;
begin
  URLLabel.Hint := 'Clicking on this web address will send your browser there !';
  EmailLabel.Hint := 'Clicking on this email address will prepare an email to us.';
  ProgramIcon.Hint := 'Click on me to jump to the Borland website.';
end;

{------------------------------------------------------------------------------
    Procedure: TAboutBox.DoGeometry
  Description: standard FormShow event handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position on screen
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.DoGeometry;
begin
  URLLabel.Top := ProgramIcon.Top +
    CommentsLabel.Top + CommentsLabel.Height;
  MailImage.Top := URLLabel.Top + URLLabel.Height;
  EmailLabel.Top := ProgramIcon.Top + MailImage.Top;
  ResourcesLabel.Top := ProgramIcon.Top +
    MailImage.Top + MailImage.Height;
  OSLabel.Top := ProgramIcon.Top +
    ResourcesLabel.Top + ResourcesLabel.Height;
  OSBuildLabel.Top := ProgramIcon.Top +
    OSLabel.Top + OSLabel.Height;
  Panel1.Height := ProgramIcon.Top +
    OSBuildLabel.Top + OSBuildLabel.Height;
  OKBitBtn.Top :=
    2*Panel1.Top + Panel1.Height;

{$IFDEF MSWINDOWS}
  Self.BorderStyle := bsDialog;
{$ENDIF}
{$IFDEF LINUX}
  Self.BorderStyle := fbsDialog;
{$ENDIF}

  Left := Screen.Width - Self.Width div 2;
  Top := Screen.Height - Self.Height div 2;
  ClientHeight := OKBitBtn.Top + 3 * OKBitBtn.Height div 2;
  ClientWidth := Panel1.Left + Panel1.Width + Panel1.Left;
  OKBitBtn.Left := (Self.ClientWidth - OKBitBtn.Width) div 2;
end;

{------------------------------------------------------------------------------
    Procedure: TAboutBox.FormShow
  Description: standard FormShow event handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position on screen
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.FormShow(Sender: TObject);
begin
  Left := (Screen.Width - Width) div 2;
  Top := (Screen.Height - Height) div 2;
end;

{------------------------------------------------------------------------------
    Procedure: TAboutBox.URLLabelClick
  Description: standard Click handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Fires up the web browser and goes to the specified URL
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.URLLabelClick(Sender: TObject);
begin
  ShowHTML(URLLabel.Caption);
end;

{------------------------------------------------------------------------------
    Procedure: TAboutBox.ProgramIconClick
  Description: standard Click handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Fires up the web browser and goes to Borland Delphi
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.ProgramIconClick(Sender: TObject);
begin
  ShowHTML('http://www.borland.com/delphi/');
end;

{------------------------------------------------------------------------------
    Procedure: TAboutBox.EmailLabelClick
  Description: standard Click handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Fires up the web browser and goes to Borland Delphi
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TAboutBox.EmailLabelClick(Sender: TObject);
begin
  DoMail(EmailLabel.Caption);
end;


end.

