unit Aboutdlg;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla 
Public License Version 1.1 (the "License"); you may not use this file except 
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for 
the specific language governing rights and limitations under the License.

The Original Code is: AboutDlg.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2000
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose:
This file contains a component wrapper for the AboutBox form.
A component wrapper presents a form as a Delphi Component, which can be added
to the component palette.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Controls, Forms,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Controls, Forms,
{$ENDIF}
{$IFDEF LINUX}
  QControls, QForms,
{$ENDIF}
  About;

type
  TAboutDlg = class(TComponent)
  private
    FComments: String;
    FURL: String;
    FEmail: String;
{procedures:}

  public
    constructor Create(AOwner: TComponent); override;
    {This is the normal constructor. It initializes properties.}
    function Execute: Boolean; virtual;
    {This function creates and runs the AboutBox. It is similar to the Execute
     function of the common dialog boxes.}
    {}
    {Its purpose is to display the AboutBox.}

  published
    property Comments: String read FComments write FComments;
    {This is to display a message about the registration state of you product,
     but could really be used for anything.}
    property Email: String read FEmail write FEmail;
    {This is your email address.}
    property URL: String read FURL write FURL;
    {This is the URL of your website. Clicking on it will start your web browser
     and load that URL.}
  end;

var
  AboutBox: TAboutBox;

implementation

{------------------------------------------------------------------------------
    Procedure: TAboutDlg.Create
  Description: standard constructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets default properties
 Known Issues:
 ------------------------------------------------------------------------------}
constructor TAboutDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEmail := 'Mat.Ballard@Chemware.hypermart.net';
  FURL := 'http://chemware.hypermart.net/';
end;

{------------------------------------------------------------------------------
     Function: TAboutDlg.Execute
  Description: Runs the About dialog box
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: see Description
 Return Value: TRUE if user selects "OK"
 Known Issues:
 ------------------------------------------------------------------------------}
function TAboutDlg.Execute: Boolean;
begin
  AboutBox := TAboutBox.Create(Application);
  with AboutBox do
  begin
    if (Length(FComments) > 0) then
      CommentsLabel.Caption := FComments;
    EmailLabel.Caption := FEmail;
    URLLabel.Caption := FURL;
    DoGeometry;
  end;

  try
    Result := (AboutBox.ShowModal = mrOk); {1}
  finally
    AboutBox.Free;
  end;
end;


end.
