unit Checkeditframe;

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla 
Public License Version 1.1 (the "License"); you may not use this file except 
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for 
the specific language governing rights and limitations under the License.

The Original Code is: Checkeditframe.pas, released 12 September 2002.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2002
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.


Purpose:
This file contains a compound component that combines a Checkbox and an Edit box.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  SysUtils, Classes,
{$IFDEF WINDOWS}
  WinTypes, WinProcs, Messages, Graphics, Controls, Forms, Dialogs, StdCtrls,
  QStdCtrls, QControls,
{$ENDIF}
{$IFDEF WIN32}
  Windows, Messages, Graphics, Controls, Forms, Dialogs, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  Types, Qt,
  QGraphics, QControls, QForms, QDialogs, QStdCtrls,
{$ENDIF}
  Misc;

type
  TCheckEdit = class(TFrame)
    CheckBox: TCheckBox;
    Edit: TEdit;
  private
    FRatio: TPercent;
  protected
    procedure SetRatio(Value: TPercent);
    procedure Resize; override;

  public
    constructor Create(AOwner: TComponent); override;
    {destructor Destroy;}
  published
    property Ratio: TPercent read FRatio write SetRatio;
  end;

implementation

{$R *.dfm}

constructor TCheckEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FRatio := 50;
end;

procedure TCheckEdit.SetRatio(Value: TPercent);
begin
  FRatio := Value;
  Resize;
end;

{destructor TCheckEdit.Destroy;
begin
end;}

{function TCheckEdit.GetEditLeft: Integer;
begin
  Result := Edit.Left;
end;

procedure TCheckEdit.SetEditLeft(Value: Integer);
begin
  Edit.Left := Value;
  CheckBox.Width := Edit.Left - CheckBox.Left-1;
  FRatio := Edit.Left / Width;
end;}

procedure TCheckEdit.Resize;
begin
  inherited Resize;
  Edit.Left := Ratio * Width div 100;
  Edit.Width := Width - Edit.Left - 2;
end;


end.
