unit Coloredt;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: ColorEdit.pas, released 1 March 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 02/28/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.


Purpose:
A simple Color editor.

Known Issues:
        - if Borland ever surfaced the SetColor procedure, or exposed an
          OnColor event, things would be much better.
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  StdCtrls, Graphics,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  StdCtrls, Graphics,
{$ENDIF}
{$IFDEF LINUX}
  Types, Qt,
  QStdCtrls, QGraphics,
{$ENDIF}
  Misc;

type
  TColorEdit = class(TEdit)
  private
    { Private declarations }
  protected
    procedure Click; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure SetColour(Value: TColor);
  published
    { Published declarations }
  end;

implementation

constructor TColorEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Self.Text := ColorToString(Self.Color);
  Self.ReadOnly := TRUE;
end;

procedure TColorEdit.SetColour(Value: TColor);
var
  TheColor: Longint;
begin
  Self.Color := Value;
{Dark background colours require a white font, and vice-versa:}  
  TheColor := ColorToRGB(Self.Color);
  TheColor := (TheColor and $00FF0000 shr 16) +
    ((TheColor and $0000FF00) shr 8) +
    (TheColor and $000000FF);
  if (TheColor < 257) then
    Self.Font.Color := clWhite
   else
    Self.Font.Color := clBlack;
  Self.Text := ColorToString(Self.Color);
end;

procedure TColorEdit.Click;
var
  AColor: TColor;
begin
  AColor := Self.Color;
  if (InputColor(AColor)) then
    SetColour(AColor);
  inherited Click;
end;


end.
