unit Filerhack;  

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: FilerHack.pas, released 15 Aug 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/15/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.


Purpose:
The following are extensions to the TReader and TWriter classes that are used
by the property streaming system. Their purpose is to easily stream the properties
of dynamic persistent objects.

Usage:
They are not instantiated, but rather used as typecasts on the original TReader
and TWriter objects, so that protected methods can be accessed. This typecasting
approach was first reported by [that Russian Genius]. It is very naughty,
but it works ! Caution though: there is NO guarantee that this will work for
your problems, or under anything other than Delphi 5.

See TPlot.StoreSeriesProperty and TPlot.LoadSeriesProperty for examples of their use.


    procedure DefineProperties(Filer: TFiler); override;
    procedure LoadAxesProperty(Reader: TReader);
    procedure StoreAxesProperty(Writer: TWriter);
    procedure LoadNotesProperty(Reader: TReader);
    procedure StoreNotesProperty(Writer: TWriter);
    procedure LoadSeriesProperty(Reader: TReader);
    procedure StoreSeriesProperty(Writer: TWriter);
    procedure LoadTextsProperty(Reader: TReader);
    procedure StoreTextsProperty(Writer: TWriter);




Known Issues:
May not work in every situation, or on other versions of Delphi, Kylix or BCB.
-----------------------------------------------------------------------------}

interface

uses
  Classes, Consts, Sysutils, TypInfo;
{$IFDEF WINDOWS}
{$ENDIF}
{$IFDEF WIN32}
{$ENDIF}
{$IFDEF LINUX}
{$ENDIF}

type
{TReaderHack ******************************************************************}
  TReaderHack = class(TReader)
    public
      procedure ReadProperty(AInstance: TPersistent);
{Expose the protected property streaming method. Very naughty indeed !}
      procedure ReadProperties(Instance: TPersistent);
{The complement of TWriterHack.WriteProperties. These two MUST be used in a
 complementary fashion in the ReadProc and WriteProc portions of your code.

 Does not exist in base class that I can see. Note that streamed properties MUST
 be surrounded by a WriteListBegin / WriteListEnd pair. As done by
 TWriterHack.WriteProperties.
  }
  end;

{TWriterHack ********************************************************************}
  TWriterHack = class(TWriter)
    public
      procedure WriteProperties(Instance: TPersistent);
{Writes the properties of Instance to the property stream, surrounded by a
 WriteListBegin / WriteListEnd pair. }
  end;
{End TReaderHack ****************************************************************}


implementation

{Begin TReaderHack and TWriterHack ------------------------------------------------}
{procedure TReaderHack.DefineProperties(Filer: TFiler);
begin
end;}

{------------------------------------------------------------------------------
    Procedure: TReaderHack.ReadProperty
  Description: calls the Ancestor's PROTECTED ReadProperty. What a HACK !
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Property Stream manipulation
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TReaderHack.ReadProperty(AInstance: TPersistent);
begin
  inherited ReadProperty(AInstance);
end;

{------------------------------------------------------------------------------
    Procedure: TReaderHack.ReadProperties
  Description: a new procedure, not found in the base class, for reading all the properties of a TPersistent
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Property Stream manipulation
 Known Issues: Note the wrapping with WriteListBegin / WriteListEnd.
 ------------------------------------------------------------------------------}
procedure TReaderHack.ReadProperties(Instance: TPersistent);
var
  Count: Integer;
begin
  Count := GetTypeData(Instance.ClassInfo)^.PropCount;
  if Count > 0 then
  begin
    ReadListBegin;
    while not EndOfList do ReadProperty(Instance);
    ReadListEnd;
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TWriterHack.WriteProperties
  Description: calls the Ancestor's PROTECTED WriteProperties. What a HACK !
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Property Stream manipulation
 Known Issues: Note the wrapping with WriteListBegin / WriteListEnd.
 ------------------------------------------------------------------------------}
procedure TWriterHack.WriteProperties(Instance: TPersistent);
begin
  WriteListBegin;
  inherited WriteProperties(Instance);
  WriteListEnd;
end;
{End TReaderHack and TWriterHack --------------------------------------------------}



(*
{Property Streaming functions -------------------------------------------------}
{------------------------------------------------------------------------------
     Function: TCustomPlot.LoadAxesProperty
  Description: Loads the Property stream of the Axes
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
       Note 1: The number of Axes has already been defined by the TPlot.NoSeries property
       Note 2: Axes 0 and 1 (X and Y) have already been stored.
 ------------------------------------------------------------------------------}
procedure TCustomPlot.LoadAxesProperty(Reader: TReader);
var
  i: Integer;
begin
  if Reader.ReadBoolean then
  begin
    for i := 2 to FAxisList.Count-1 do
    begin
      Reader.ReadString;
      TReaderHack(Reader).ReadProperties(TAxis(FAxisList.Items[i]));
    end;
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.StoreAxesProperty
  Description: Writes the Property streams of Axes
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TCustomPlot.StoreAxesProperty(Writer: TWriter);
var
  i: Integer;
begin
  Writer.WriteBoolean(FAxisList.Count > 2);
  for i := 2 to FAxisList.Count-1 do
  begin
    Writer.WriteString(Format('Axes%d', [i]));
    TWriterHack(Writer).WriteProperties(TAxis(FAxisList.Items[i]));
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.LoadNotesProperty
  Description: Loads the Property stream of the Notes
       Author: Mat Ballard
 Date created: 08/16/2001
Date modified: 08/16/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
       Note 1: The number of Axes has already been defined by the TPlot.NoSeries property
 ------------------------------------------------------------------------------}
procedure TCustomPlot.LoadNotesProperty(Reader: TReader);
var
  ANote: TNote;
begin
  if Reader.ReadBoolean then
  begin
    Reader.ReadListBegin;
    while not Reader.EndOfList do
    begin
{Read the 'Note17:'}
      Reader.ReadString;
{Create a basic note:}
      ANote := TNote.Create(Self);
      FNoteList.Add(ANote);
{Stream in its properties:}
      TReaderHack(Reader).ReadProperties(ANote);
      ANote.OnCaptionChange := Self.DoStyleChange;
    end;
    Reader.ReadListEnd;
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.StoreNotesProperty
  Description: Writes the Property streams of Notes
       Author: Mat Ballard
 Date created: 08/16/2001
Date modified: 08/16/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TCustomPlot.StoreNotesProperty(Writer: TWriter);
var
  i: Integer;
begin
  Writer.WriteBoolean(FNoteList.Count > 0);
  if (FNoteList.Count > 0) then
  begin
    Writer.WriteListBegin;
    for i := 0 to FNoteList.Count-1 do
    begin
      Writer.WriteString(Format('Note%d', [i]));
      TWriterHack(Writer).WriteProperties(TNote(FNoteList.Items[i]));
    end;
    Writer.WriteListEnd;
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.LoadSeriesProperty
  Description: Loads the Property stream of the Series
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
         Note: The number of Series has already been defined by the TPlot.NoSeries property
 ------------------------------------------------------------------------------}
procedure TCustomPlot.LoadSeriesProperty(Reader: TReader);
var
  i: Integer;
begin
  if Reader.ReadBoolean then
  begin
    for i := 0 to SeriesList.Count-1 do
    begin
      Reader.ReadString;
      TReaderHack(Reader).ReadProperties(TSeries(SeriesList.Items[i]));
    end;
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.StoreSeriesProperty
  Description: Writes the Property streams of Series
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TCustomPlot.StoreSeriesProperty(Writer: TWriter);
var
  i: Integer;
begin
  Writer.WriteBoolean(FSeriesList.Count > 0);
  for i := 0 to SeriesList.Count-1 do
  begin
    Writer.WriteString(Format('Series%d', [i]));
    TWriterHack(Writer).WriteProperties(TSeries(SeriesList.Items[i]));
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.LoadTextsProperty
  Description: Loads the Property stream of the Texts
       Author: Mat Ballard
 Date created: 08/16/2001
Date modified: 08/16/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TCustomPlot.LoadTextsProperty(Reader: TReader);
var
  AText: TText;
begin
  if Reader.ReadBoolean then
  begin
    Reader.ReadListBegin;
    while not Reader.EndOfList do
    begin
{Read the 'Text17:'}
      Reader.ReadString;
{Create a basic Text:}
      AText := TText.Create(Self);
      FTextList.Add(AText);
{Stream in its properties:}
      TReaderHack(Reader).ReadProperties(AText);
      AText.OnCaptionChange := Self.DoStyleChange;
    end;
    Reader.ReadListEnd;
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.StoreTextsProperty
  Description: Writes the Property streams of Texts
       Author: Mat Ballard
 Date created: 08/16/2001
Date modified: 08/16/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TCustomPlot.StoreTextsProperty(Writer: TWriter);
var
  i: Integer;
begin
  Writer.WriteBoolean(FTextList.Count > 0);
  if (FTextList.Count > 0) then
  begin
    Writer.WriteListBegin;
    for i := 0 to FTextList.Count-1 do
    begin
      Writer.WriteString(Format('Text%d', [i]));
      TWriterHack(Writer).WriteProperties(TText(FTextList.Items[i]));
    end;
    Writer.WriteListEnd;
  end;
end;

{------------------------------------------------------------------------------
     Function: TCustomPlot.DefineProperties
  Description: Defines Property streams
       Author: Mat Ballard
 Date created: 08/15/2001
Date modified: 08/15/2001 by Mat Ballard
      Purpose: Allows the streaming of the properties of dynamic sub-components
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TCustomPlot.DefineProperties(Filer: TFiler);
begin
  inherited; { allow base classes to define properties }
  Filer.DefineProperty('Series',
    LoadSeriesProperty,
    StoreSeriesProperty,
    TRUE);
  Filer.DefineProperty('Axes',
    LoadAxesProperty,
    StoreAxesProperty,
    TRUE);
  Filer.DefineProperty('Notes',
    LoadNotesProperty,
    StoreNotesProperty,
    TRUE);
  Filer.DefineProperty('Texts',
    LoadTextsProperty,
    StoreTextsProperty,
    TRUE);
end;

*)
end.
