unit HtmlComboBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,

  Misc;

type
  THtmlComboBox = class(TListBox)
  private
    { Private declarations }
  protected
    procedure DrawItem(Index: Integer; Rect: TRect;
      State: TOwnerDrawState); override;
    procedure MeasureItem(Index: Integer; var Height: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
  end;

implementation

constructor THtmlComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Self.Style := lbOwnerDrawVariable;
end;

procedure THtmlComboBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  Face: String;
  Size: Integer;
  Color: TColor;
  Style: TFontStyles;
  Text: String;
  Flags: Longint;
begin
  Face := Font.Name;
  Size := Font.Size;
  Color := Font.Color;
  Style := Font.Style;
  if (Misc.ExtractHtmlFontInfo(Self.Items[Index], Face, Size, Color, Style, Text)) then
  begin
    Canvas.Font.Name := Face;
    Canvas.Font.Color := Color;
    Canvas.Font.Size := Size;
    Canvas.Font.Style := Style;
  end
   else
    Canvas.Font.Assign(Self.Font);
{now straight from StdCtrls.TListBox.DrawItem:}
  Canvas.FillRect(Rect);
  if Index < Items.Count then
  begin
    Flags := DrawTextBiDiModeFlags(DT_SINGLELINE or DT_VCENTER or DT_NOPREFIX);
    if not UseRightToLeftAlignment then
      Inc(Rect.Left, 2)
    else
      Dec(Rect.Right, 2);
    DrawText(Canvas.Handle, PChar(Text), Length(text), Rect, Flags);
  end;
end;

procedure THtmlComboBox.MeasureItem(Index: Integer; var Height: Integer); 
begin
  Misc.ExtractHtmlFontSize(Self.Items[Index], Height);
  Canvas.Font.Size := Height;
  Height := Canvas.TextHeight('Tp');
  //Inc(Height, 6);
  inherited MeasureItem(Index, Height);
end;


end.
