unit Misc_Reg;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: PlotMisc.pas, released 1 July 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 02/25/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.


Purpose:
Registration unit for the Misc package of components.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes,

{$IFDEF MSWINDOWS}
  Mlabel, {does not translate: no Paint to override}
{$ENDIF}
  Aboutdlg, Checkgrp, Coloredt, Editgrp, Fileinfo, HtmlComboBox, HtmlListBox,
{$IFDEF COMPILER5_UP}
  Checkeditframe, Checkeditgroup,
  DblCheckeditframe, DblCheckeditgroup,
  MSHTMLActionList,
{$ENDIF}
{$IFDEF COMPILER4_UP}
  Titlestringgrid,
{$ENDIF}
  Nedit, Vedit, Shapeex, Slidebar, Splshdlg, Switch, URLabel;

procedure Register;

implementation

{$IFDEF DELPHI1}
  {$R Misc16.dcr}
{$ELSE}
  {$R Misc32.dcr}
{$ENDIF}

{type}

procedure Register;
begin
  RegisterComponents('Chemware', [TAboutDlg]);
  RegisterComponents('Chemware', [TCheckGroup]);
  RegisterComponents('Chemware', [TColorEdit]);
  RegisterComponents('Chemware', [THtmlComboBox]);
  RegisterComponents('Chemware', [THtmlListBox]);
{$IFDEF COMPILER5_UP}
  RegisterComponents('Chemware', [TCheckEdit]);
  RegisterComponents('Chemware', [TCheckEditGroup]);
  RegisterComponents('Chemware', [TDblCheckEdit]);
  RegisterComponents('Chemware', [TDblCheckEditGroup]);
  RegisterComponents('Chemware', [TMSHTMLActionList]);
{$ENDIF}
{$IFDEF COMPILER4_UP}
  RegisterComponents('Chemware', [TTitleStringGrid]);
{$ENDIF}
  RegisterComponents('Chemware', [TEditGroup]);
  RegisterComponents('Samples', [TFileVersionInfo]);
{$IFDEF MSWINDOWS}
  RegisterComponents('Chemware', [TMultiLabel]);
{$ENDIF}
  RegisterComponents('Chemware', [TNEdit]);
  RegisterComponents('Chemware', [TVEdit]);
  RegisterComponents('Chemware', [TShapeEx]);
  RegisterComponents('Chemware', [TSplashDlg]);
  RegisterComponents('Chemware', [TSlideBar]);
  RegisterComponents('Chemware', [TSwitch]);
  RegisterComponents('Chemware', [TURLabel]);
end;


end.
