unit Options3;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Options.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2000
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose:
This form is an improved "Options" form with 3 different Types, or modes.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, ExtCtrls, Forms, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, ExtCtrls, Forms, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  Qt,
  QButtons, QControls, QExtCtrls, QForms, QStdCtrls,
{$ENDIF}
  Misc, Checkgrp, Editgrp;

type
  TOptionsType = (otRadio, otCheck, otEdit);

  TOptions3Form = class(TForm)
    QuestionLabel: TLabel;
    OKBitBtn: TBitBtn;
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FType: TOptionsType;
    FListCaption: String;
  public
    Checks: TCheckGroup;
    Edits: TEditGroup;
    Radios: TRadioGroup;
    TheBox: TCustomGroupBox;
    function ItemIndex: Integer;
    function ItemCount: Integer;
    function SelectedObject: TObject;
    function Checked(Index: Integer): Boolean;
    function Objects(Index: Integer): TObject;

    procedure DoGeometry;
    procedure Add(Value: String);
    procedure AddObject(Value: String; AnObject: TObject);
    procedure SetListCaption(Value: String);
    procedure SetType(Value: TOptionsType);
  end;

var
  Options3Form: TOptions3Form;

implementation

{$R *.dfm}

{------------------------------------------------------------------------------
    Procedure: TOptionsForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position and fills the labels
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TOptions3Form.FormCreate(Sender: TObject);
begin {Form has not yet had properties set}
{$IFDEF MSWINDOWS}
  {Self.PixelsPerInch := 96;}
  Self.BorderStyle := bsDialog;
{$ENDIF}
{$IFDEF LINUX}
  {Self.PixelsPerInch := 75;}
  Self.BorderStyle := fbsDialog;
{$ENDIF}
  Checks := nil;
  Edits := nil;
  SetType(otRadio);
  FListCaption := '';
end;

procedure TOptions3Form.FormShow(Sender: TObject);
begin {Form is ALREADY VISIBLE !}
  DoGeometry;
  TWinControl(TheBox.Controls[0]).SetFocus;
end;

procedure TOptions3Form.Add(Value: String);
begin
  if (Checks <> nil) then
    Checks.Items.Add(Value)
  else if (Edits <> nil) then
    Edits.Items.Add(Value)
  else if (Radios <> nil) then
    Radios.Items.Add(Value);
end;

procedure TOptions3Form.AddObject(Value: String; AnObject: TObject);
begin
  if (Checks <> nil) then
    Checks.Items.AddObject(Value, AnObject)
  else if (Edits <> nil) then
    Edits.Items.AddObject(Value, AnObject)
  else if (Radios <> nil) then
    Radios.Items.AddObject(Value, AnObject);
end;

function TOptions3Form.ItemIndex: Integer;
begin
  if (Checks <> nil) then Result := Checks.ItemIndex
  else if (Edits <> nil) then Result := Edits.ItemIndex
  else if (Radios <> nil) then Result := Radios.ItemIndex
  else Result := -1;
end;

function TOptions3Form.ItemCount: Integer;
begin
  if (Checks <> nil) then Result := Checks.Count
  else if (Edits <> nil) then Result := Edits.Count
  else if (Radios <> nil) then Result := Radios.Items.Count
  else Result := 0;
end;

function TOptions3Form.SelectedObject: TObject;
begin
  if (Checks <> nil) then Result := Checks.Items.Objects[ItemIndex]
  else if (Edits <> nil) then Result := Edits.Items.Objects[ItemIndex]
  else if (Radios <> nil) then Result := Radios.Items.Objects[ItemIndex]
  else Result := nil;
end;

function TOptions3Form.Checked(Index: Integer): Boolean;
begin
  if (0 <= Index) and (Index < Self.ItemCount) then
  begin
    if (Checks <> nil) then Result := Checks.CheckBoxes[Index].Checked
    else if (Radios <> nil) then Result := (Index = Radios.ItemIndex)
    else Result := FALSE;
  end
   else
    Result := FALSE;
end;

function TOptions3Form.Objects(Index: Integer): TObject;
begin
  if (0 <= Index) and (Index < Self.ItemCount) then
  begin
    if (Checks <> nil) then Result := Checks.Items.Objects[Index]
    else if (Edits <> nil) then Result := Edits.Items.Objects[Index]
    else if (Radios <> nil) then Result := Radios.Items.Objects[Index]
    else Result := nil;
  end
   else
    Result := nil;
end;

procedure TOptions3Form.SetListCaption(Value: String);
begin
  FListCaption := Value;
  if (Checks <> nil) then Checks.Caption := Value
  else if (Edits <> nil) then Edits.Caption := Value
  else if (Radios <> nil) then Radios.Caption := Value;
  if (Visible) then DoGeometry;
end;

procedure TOptions3Form.SetType(Value: TOptionsType);
var
  ListStr: String;
begin
  if (Checks <> nil) then
  begin
    ListStr := Checks.Items.Text;
    Checks.Free;
  end else if (Edits <> nil) then
  begin
    ListStr := Edits.Items.Text;
    Edits.Free
  end else if (Radios <> nil) then
  begin
    ListStr := Radios.Items.Text;
    Radios.Free;
  end
   else
    ListStr := '';

  case Value of
    otRadio:
      begin
        Radios := TRadioGroup.Create(Self);
        Radios.Parent := Self;
        Radios.Caption := FListCaption;
        Radios.Hint := 'Please select one of these options';
        Radios.Items.Text := ListStr;
        TheBox := Radios;
      end;
    otCheck:
      begin
        Checks := TCheckGroup.Create(Self);
        Checks.Parent := Self;
        Checks.Caption := FListCaption;
        Checks.Hint := 'Please select one or more of these options';
        Checks.Items.Text := ListStr;
        TheBox := Checks;
      end;
    otEdit:
      begin
        Edits := TEditGroup.Create(Self);
        Edits.Parent := Self;
        Edits.Caption := FListCaption;
        Edits.Hint := 'Please edit one or more of these options';
        Edits.Items.Text := ListStr;
        TheBox := Edits;
      end;
  end;
  
  FType := Value;
  if (Visible) then DoGeometry;
end;

procedure TOptions3Form.DoGeometry;
var
  i,
  TheSize,
  StrLength: Integer;
  StrMax: String;
  Size: Integer;
  Items: TStrings;
begin
  if (Checks <> nil) then Items := Checks.Items
  else if (Edits <> nil) then Items := Edits.Items
  else if (Radios <> nil) then Items := Radios.Items
  else exit;

  StrLength := 0;
  StrMax := '';
  for i := 0 to Items.Count-1 do
  begin
    if (Length(Items.Strings[i]) > StrLength) then
    begin
      StrMax := Items.Strings[i];
      StrLength := Length(StrMax);
    end;
  end;

  if (Checks <> nil) then
  begin
    if (Length(Checks.Caption) > StrLength) then
      StrMax := Checks.Caption;
  end
  else if (Radios <> nil) then
  begin
    if (Length(Radios.Caption) > StrLength) then
      StrMax := Radios.Caption;
  end;

  StrMax := StrMax + 'WWWWW';

  TheSize := CancelBitBtn.Left + CancelBitBtn.Width - HelpBitBtn.Left;
  Size := Canvas.TextWidth(StrMax);
  if (Size < TheSize) then Size := TheSize;

  if (QuestionLabel.Width > Size) then
    Size := QuestionLabel.Width;

  TheBox.Left := 8;
  TheBox.Top := 2 * QuestionLabel.Top + QuestionLabel.Height;
  TheBox.Width := Size;
  TheBox.Height := (Items.Count +1)* OKBitBtn.Height;

  OKBitBtn.Top := TheBox.Top + TheBox.Height + QuestionLabel.Top;
  CancelBitBtn.Top := OKBitBtn.Top;
  HelpBitBtn.Top := OKBitBtn.Top;

  ClientHeight := OKBitBtn.Top + 3 * OKBitBtn.Height div 2;
  ClientWidth := 2 * QuestionLabel.Left + TheBox.Width;

  {HelpBitBtn.Left := Width - QuestionLabel.Left - HelpBitBtn.Width;
  CancelBitBtn.Left := HelpBitBtn.Left - QuestionLabel.Left - CancelBitBtn.Width;
  OKBitBtn.Left := CancelBitBtn.Left - QuestionLabel.Left - CancelBitBtn.Width;}

  Left := 10;
  Top := 10;
end;

end.

