unit Optnsdlg;

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: OptionsDlg.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2000
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose:
This file contains a component wrapper for the Options form.
A component wrapper presents a form as a Delphi Component,
which can be added to the component palette.


Known Issues:
-----------------------------------------------------------------------------}

{$I Misc.inc}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Forms,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Forms,
{$ENDIF}
{$IFDEF LINUX}
  QT,
  QForms,
{$ENDIF}
  Options;

const
  TOPTIONSDLG_VERSION = 300;

type
  TOptionsDlg = class(TComponent)
  private
    FHelpContext: THelpContext;
    FFormTitle: String;
    FOptionCaption: String;
    FOptionList: TStringList;
    FQuestion: String;

  public
    constructor Create(AOwner: TComponent); override;
    {This is the normal constructor. It initializes properties and the list of options.}
    destructor Destroy; override;
    {This is the normal destructor. It frees the list of options.}
    function Execute: Integer;  virtual;
    {This function creates and runs the OptionsBox. It is similar to the Execute
     function of the common dialog boxes, except that it returns an Integer rather
     than a Boolean.}
    {}
    {Its purpose is to display the OptionBox so that the user can pick one option from several.}

  published
    property FormTitle: String read FFormTitle write FOptionCaption;
    {This is the title of the Options Dialog.}
    property HelpContext: THelpContext read FHelpContext write FHelpContext;
    {This is the help context of the application's help file
     that describes what this set of options is about.}
    property OptionCaption: String read FOptionCaption write FOptionCaption;
    {This is the caption of the radiogroup of buttons.}
    property OptionList: TStringList read FOptionList write FOptionList;
    {This is the list of options.}
    property Question: String read FQuestion write FQuestion;
    {This is the question that you want the user to answer by picking one option.}
  end;

var
  OptionsBox: TOptionsForm;
  {This is the dialog box that asks the user to pick one option out of several.}
  {}
  {It automatically resizes itself according to the number and length of options,
   and the question and caption.}
  {}
  {It is displayed when the Execute method is called.}

implementation

{------------------------------------------------------------------------------
    Procedure: TOptionsDlg.Create
  Description: standard constructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: creates the OptionList, sets various Properties, and adds to the OptionsList
 Known Issues:
 ------------------------------------------------------------------------------}
constructor TOptionsDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FFormTitle := 'Options';
  FOptionCaption := 'Pick an option:';
  FOptionList := TStringList.Create;
  if (csDesigning in ComponentState) then
  begin
    FOptionList.Add('Blue');
    FOptionList.Add('Red');
    FOptionList.Add('Yellow');
    FQuestion := 'What is your favourite colour ?';
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TOptionsDlg.Destroy
  Description: standard destructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: frees the OptionList
 Known Issues:
 ------------------------------------------------------------------------------}
destructor TOptionsDlg.Destroy;
begin
  FOptionList.Free;
  inherited Destroy;
end;

{------------------------------------------------------------------------------
     Function: TOptionsDlg.Execute
  Description: Runs the Options dialog box
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: see Description
 Return Value: the Index, 1..N, of the selected option, or -1 if cancelled
 Known Issues:
 ------------------------------------------------------------------------------}
function TOptionsDlg.Execute: Integer;
var
  i: Integer;
begin
  OptionsBox := TOptionsForm.Create(Application);
  with OptionsBox do
  begin
    Caption := FFormTitle;
    HelpContext := FHelpContext;
    HelpBitBtn.HelpContext := FHelpContext;
    OptionsRadioGroup.Caption := FOptionCaption;
    OptionsRadioGroup.Items.Clear;
    for i := 0 to OptionList.Count-1 do
      OptionsRadioGroup.Items.Add(OptionList.Strings[i]);
    QuestionLabel.Caption := FQuestion;
    DoGeometry;
  end;

  try
    Result := OptionsBox.ShowModal;
  finally
    OptionsBox.Free;                    
  end;
end;


end.
