unit Options;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Options.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2000
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose:
This form is used to display a standard "About" dialog box with a few extra wrinkles.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, ExtCtrls, Forms, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, ExtCtrls, Forms, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  Qt,
  QButtons, QControls, QExtCtrls, QForms, QStdCtrls,
{$ENDIF}
  Misc;

type
  TOptionsType = (otRadio, otCheck);

  TOptionsForm = class(TForm)
    OptionsRadioGroup: TRadioGroup;
    QuestionLabel: TLabel;
    OKBitBtn: TBitBtn;
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    procedure OKBitBtnClick(Sender: TObject);
    procedure CancelBitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  public
    procedure DoGeometry;
{$IFNDEF LANG_ENGLISH}
    procedure DoCaptionsFromResource;
{$ENDIF}
    procedure DoHintsFromResource;
  end;

var
  OptionsForm: TOptionsForm;

implementation

{$R *.dfm}

{------------------------------------------------------------------------------
    Procedure: TOptionsForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position and fills the labels
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TOptionsForm.FormCreate(Sender: TObject);
begin {Form has not yet had properties set}
{$IFNDEF LANG_ENGLISH}
  DoCaptionsFromResource;
{$ENDIF}
  DoHintsFromResource;

{$IFDEF MSWINDOWS}
  {Self.PixelsPerInch := 96;}
  Self.BorderStyle := bsDialog;
{$ENDIF}
{$IFDEF LINUX}
  {Self.PixelsPerInch := 75;}
  Self.BorderStyle := fbsDialog;
{$ENDIF}
end;


procedure TOptionsForm.DoGeometry;
var
  i,
  TheSize,
  StrLength: Integer;
  StrMax: String;
  Size: Integer;
begin
  StrLength := 0;
  StrMax := '';
  for i := 0 to OptionsRadioGroup.ControlCount-1 do
  begin
    if (Length(TRadioButton(OptionsRadioGroup.Controls[i]).Caption) > StrLength) then
    begin
      StrMax := TRadioButton(OptionsRadioGroup.Controls[i]).Caption;
      StrLength := Length(StrMax);
    end;
  end;
  if (Length(OptionsRadioGroup.Caption) > StrLength) then
    StrMax := OptionsRadioGroup.Caption;
  StrMax := StrMax + 'WWWWW';

  TheSize := CancelBitBtn.Left + CancelBitBtn.Width - HelpBitBtn.Left;
  Size := Canvas.TextWidth(StrMax);
  if (Size < TheSize) then Size := TheSize;

  if (QuestionLabel.Width > Size) then
    Size := QuestionLabel.Width;
  OptionsRadioGroup.Width := Size;

  OptionsRadioGroup.Top := 2 * QuestionLabel.Top +
                           QuestionLabel.Height;
  OptionsRadioGroup.Height := (OptionsRadioGroup.Items.Count +1)*
                              OKBitBtn.Height;

  OKBitBtn.Top := OptionsRadioGroup.Top +
                  OptionsRadioGroup.Height +
                  QuestionLabel.Top;
  CancelBitBtn.Top := OKBitBtn.Top;
  HelpBitBtn.Top := OKBitBtn.Top;

  ClientHeight := OKBitBtn.Top + 3 * OKBitBtn.Height div 2;
  ClientWidth := 2 * QuestionLabel.Left + OptionsRadioGroup.Width;

  {HelpBitBtn.Left := Width - QuestionLabel.Left - HelpBitBtn.Width;
  CancelBitBtn.Left := HelpBitBtn.Left - QuestionLabel.Left - CancelBitBtn.Width;
  OKBitBtn.Left := CancelBitBtn.Left - QuestionLabel.Left - CancelBitBtn.Width;}

  Left := 10;
  Top := 10;
end;

{------------------------------------------------------------------------------
    Procedure: TOptionsForm.DoCaptionsFromResource
  Description: standard loading of labels from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
{$IFNDEF LANG_ENGLISH}
procedure TOptionsForm.DoCaptionsFromResource;
begin
  Self.Caption := 'Options';
  OptionsRadioGroup.Caption := 'Pick an Option:';
  HelpBitBtn.Caption := '&Help';
  OKBitBtn.Caption := 'OK';
  CancelBitBtn.Caption := '&Cancel';
end;
{$ENDIF}

{------------------------------------------------------------------------------
    Procedure: TOptionsForm.DoHintsFromResource
  Description: standard loading of hints from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display hints in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TOptionsForm.DoHintsFromResource;
begin
  OptionsRadioGroup.Hint := 'Please select one of these options';
end;


procedure TOptionsForm.FormShow(Sender: TObject);
begin {Form is ALREADY VISIBLE !}
  DoGeometry;
  OptionsRadioGroup.ItemIndex := 0;
  TRadioButton(OptionsRadioGroup.Controls[0]).SetFocus;
end;

procedure TOptionsForm.OKBitBtnClick(Sender: TObject);
begin
{note: if ModalResult is 0, then the form DOES NOT CLOSE,
 so selection is 1..n:}
  ModalResult := OptionsRadioGroup.ItemIndex + 1;
end;

procedure TOptionsForm.CancelBitBtnClick(Sender: TObject);
begin
  ModalResult := -1;
end;

end.

