unit Radioeditframe;

interface

uses 
  SysUtils, Classes,
{$IFDEF LINUX}
  Types, Qt,
  QGraphics, QControls, QForms, QDialogs, QStdCtrls, StdCtrls, Controls;
{$ENDIF}
{$IFDEF WINDOWS}
  WinTypes, WinProcs, Messages, Graphics, Controls, Forms, Dialogs, StdCtrls;
{$ENDIF}
{$IFDEF WIN32}
  Windows, Messages, Graphics, Controls, Forms, Dialogs, StdCtrls;
{$ENDIF}

type
  TRadioEdit = class(TFrame)
    Edit: TEdit;
    RadioButton: TRadioButton;
  private
  protected
{TRadioButton access methods:}
    function GetAction: TBasicAction;
    procedure SetAction(Value: TBasicAction);
    function GetAllowGrayed: Boolean;
    procedure SetAllowGrayed(Value: Boolean);
    function GetChecked: Boolean;
    procedure SetChecked(Value: Boolean);
    function GetState: TRadioButtonState;
    procedure SetState(Value: TRadioButtonState);
    function GetCheckFont: TFont;
    procedure SetCheckFont(Value: TFont);
    function GetEditLeft: Integer;
    procedure SetEditLeft(Value: Integer);
    function GetCaption: String;
    procedure SetCaption(Value: String);
{TEdit access methods:}
    function GetFont: TFont;
    procedure SetFont(Value: TFont);
    function GetText: String;
    procedure SetText(Value: String);
  public
    { Public declarations }
  published
{TRadioButton properties:}
    property Action: TBasicAction read GetAction write SetAction;
    property AllowGrayed: Boolean read GetAllowGrayed write SetAllowGrayed;
    property Checked: Boolean read GetChecked write SetChecked;
    property State: TRadioButtonState read GetState write SetState;
    property CheckFont: TFont read GetCheckFont write SetCheckFont;
    property EditLeft: Integer read GetEditLeft write SetEditLeft;
    property Caption: String read GetCaption write SetCaption;
{TEdit properties:}
    property Font: TFont read GetFont write SetFont;
    property Text: String read GetText write SetText;
  end;

implementation

{$R *.dfm}

function TRadioEdit.GetAction: TBasicAction;
begin
  Result := Edit.Action;
end;

procedure TRadioEdit.SetAction(Value: TBasicAction);
begin
  Edit.Action := Value;
end;

function TRadioEdit.GetAllowGrayed: Boolean;
begin
  Result := RadioButton.AllowGrayed;
end;

procedure TRadioEdit.SetAllowGrayed(Value: Boolean);
begin
  RadioButton.AllowGrayed := Value;
end;

function TRadioEdit.GetChecked: Boolean;
begin
  Result := RadioButton.Checked;
end;

procedure TRadioEdit.SetChecked(Value: Boolean);
begin
  RadioButton.Checked := Value;
end;

function TRadioEdit.GetState: TRadioButtonState;
begin
  Result := RadioButton.State;
end;

procedure TRadioEdit.SetState(Value: TRadioButtonState);
begin
  RadioButton.State := Value;
end;

function TRadioEdit.GetCheckFont: TFont;
begin
  Result := RadioButton.Font;
end;

procedure TRadioEdit.SetCheckFont(Value: TFont);
begin
  RadioButton.Font.Assign(Value);
end;

function TRadioEdit.GetEditLeft: Integer;
begin
  Result := Edit.Left;
end;

procedure TRadioEdit.SetEditLeft(Value: Integer);
begin
  Edit.Left := Value;
end;

function TRadioEdit.GetCaption: String;
begin
  Result := RadioButton.Caption;
end;

procedure TRadioEdit.SetCaption(Value: String);
begin
  RadioButton.Caption := Value;
end;

function TRadioEdit.GetFont: TFont;
begin
  Result := Edit.Font;
end;

procedure TRadioEdit.SetFont(Value: TFont);
begin
  Edit.Font.Assign(Value);
end;

function TRadioEdit.GetText: String;
begin
  Result := Edit.Text;
end;

procedure TRadioEdit.SetText(Value: String);
begin
  Edit.Text := Value;
end;

end.
