unit Splshdlg;

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: SplashDlg.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2000
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose:
This file contains a component wrapper for the SplashBox form.
A component wrapper presents a form as a Delphi Component,
which can be added to the component palette.


Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Forms,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Forms,
{$ENDIF}
{$IFDEF LINUX}
  QT,
  QForms,
{$ENDIF}
  Splash;

type
  TSplashDlg = class(TComponent)
  private
    FCaption: String;
    FComments: String;
    FHelpContext: Integer;
    FInterval: Integer;
{    FLogo: TPicture;}
    FPrice: String;
    FRegistered: Boolean;
    FURL: String;
{procedures:}

  public
    constructor Create(AOwner: TComponent); override;
    {This is the normal constructor. It initializes properties.}
    function Execute: Boolean; virtual;
    {This function creates and runs the SplashBox. It is similar to the Execute
     function of the common dialog boxes.}
    {}
    {Its purpose is to display the SplashBox.}

  published
    property Caption: String read FCaption write FCaption;
    {This is the caption of the Splash form.}
    property Comments: String read FComments write FComments;
    {General comments from the file resources, or your input.}
    property HelpContext: Integer read FHelpContext write FHelpContext;
    {This is the appropriate help context for the help file license.}
    property Interval: Integer read FInterval write FInterval;
    {How long to show the splash screen: 0 => indefinite.}
{    property Logo: TPicture read FLogo write FLogo;}
    {This is your product's logo as a picture.}
    property Price: String read FPrice write FPrice;
    {This is the price of your product.}
    property Registered: Boolean read FRegistered write FRegistered;
    {Do we have to demand money ?}
    property URL: String read FURL write FURL;
    {This is the URL of your website. Clicking on it will start your web browser
     and load that URL.}
  end;

var
  SplashBox: TSplashBox;

implementation

{------------------------------------------------------------------------------
    Procedure: TSplashDlg.Create
  Description: standard constructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets various Properties
 Known Issues:
 ------------------------------------------------------------------------------}
constructor TSplashDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCaption := 'Wait a minute ...';
  FComments := 'Register for only A$35';
  FInterval := 5000;
  FRegistered := FALSE;
  FURL := 'http://chemware.hypermart.net/';
end;

{------------------------------------------------------------------------------
     Function: TSplashDlg.Execute
  Description: runs the Splash dialog box
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: see Description
 Return Value: TRUE or FALSE
 Known Issues:
 ------------------------------------------------------------------------------}
function TSplashDlg.Execute: Boolean;
begin
  SplashBox := TSplashBox.Create(Application);        
  with SplashBox do
  begin
    Caption := FCaption;
    if (Length(FComments) > 0) then
      CommentsLabel.Caption:= FComments;
    HelpContext := FHelpContext;
    PriceLabel.Caption := FPrice;
    URLLabel.Caption := FURL;
    Timer1.Interval := FInterval;
{    LogoImage.Picture.Assign(FLogo);}
    if (FRegistered) then
    begin
      Timer1.Enabled := TRUE;
      LeftImage.Visible := FALSE;
      RightImage.Visible := FALSE;
      CommentsLabel.Visible := FALSE;
      Panel1.Height := CommentsLabel.Top;
    end;
  end;

  try
    Result := (SplashBox.ShowModal = 1{mrOk});
  finally
{    SplashBox.LogoImage.Picture.Assign(nil);}
    SplashBox.Free;
  end;
end;


end.
