unit URLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,

  Misc;

type
  TURLabel = class(TLabel)
  private
    FURL: String;
  protected
    procedure Click; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property URL: String read FURL write FURL;
  end;


implementation

constructor TURLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  
  Self.Font.Color := clBlue;
  Self.Font.Style := [fsUnderline];
end;

procedure TURLabel.Click;
begin
  Misc.ShowHTML(FURL);
  inherited Click;
end;

end.
