unit T_FTG2_5_Form1;

(* *****************************************************************************

 Pgm. 10/03/00 by John Herbster for Delphi-5 testing of U_FTG2, a unit for
     performing the Glassman FFT.

***************************************************************************** *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, U_FTG2, ComCtrls;

type
  TForm1 = class(TForm)
    MKTransForm_b: TButton;
    NbrElem_e: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    Label2: TLabel;
    NbrCyc_e: TEdit;
    UpDown1: TUpDown;
    procedure MKTransForm_bClick(Sender: TObject);
  private
    { Private declarations }
  public
    NC: integer;
    Cinp,Cout,CScr,CInv: array of tComplex;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const CFmt='(%7.2f,%7.2f)';

procedure TForm1.MKTransForm_bClick(Sender: TObject);
var j: integer; s: string; a,f: double;
begin
  NC := StrToInt(NbrElem_e.Text);
  SetLength(Cinp,NC);
  SetLength(Cout,NC);
  SetLength(CScr,NC);
  SetLength(CInv,NC);
  f := StrToInt(NbrCyc_e.Text);
  For j := 0 to NC-1 do with Cinp[j] do
    begin a := 2*pi*f*j/nc; r := cos(a); i := sin(a) end;
  CFTG(Cinp,Cout,CScr,+NC);
  CFTG(Cout,CInv,CScr,-NC);
  Memo1.Lines.Add(Format('NC=%d',[NC]));
  s := 'Cinp: ';
  For j := 0 to NC-1 do with Cinp[j] do begin
    if j>0 then s := s+', ';
    s := s + Format(CFmt,[r,i]);
    end;
  Memo1.Lines.Add(s);
  s := 'Cout: ';
  For j := 0 to NC-1 do with Cout[j] do begin
    if j>0 then s := s+', ';
    s := s + Format(CFmt,[r,i]);
    end;
  Memo1.Lines.Add(s);
  s := 'Cinv: ';
  For j := 0 to NC-1 do with Cinv[j] do begin
    if j>0 then s := s+', ';
    s := s + Format(CFmt,[r,i]);
    end;
  Memo1.Lines.Add(s);
  Memo1.Lines.Add('');
end;

end.
