unit TestUnit1;

interface

uses
(*$IFDEF LINUX*)
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  Parser10, QStdCtrls;
(*$ELSE *)
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Parser10, QStdCtrls, QControls;
(*$ENDIF LINUX*)


type
  TForm2 = class(TForm)
    Parser1: TParser;
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

(*$IFDEF LINUX*)
{$R *.dfm}
(*$ELSE *)
{$R *.DFM}
(*$ENDIF LINUX*)

procedure TForm2.Button1Click(Sender: TObject);
begin
  // Setting the expression
  Parser1.Expression := Edit1.Text;
  // Evaluating the expression
  Edit2.Text := FloatToStr(Parser1.Value);
end;

procedure TestOneParam(AnOp: POperation);
begin
  with AnOp^ do
    dest^ := arg1^*3;
end;

procedure TestTwoParam(AnOp: POperation);
begin
  with AnOp^ do
    dest^ := arg1^ + arg2^*2;
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
  // Adding functions
  Parser1.AddFunctionOneParam('OneParam', TestOneParam);
  Parser1.AddFunctionTwoParam('TwoParam', TestTwoParam);
end;

procedure TForm2.Button4Click(Sender: TObject);
begin
  // Removing functions
  Parser1.ClearFunction('OneParam');
  Parser1.ClearFunction('TwoParam');
end;

procedure TForm2.Button3Click(Sender: TObject);
var
  MyVar2: PParserFloat;
begin
  // Setting variables - slowly
  Parser1.Variable['MyVar1'] := 3.14;
  MyVar2 := Parser1.SetVariable('MyVar2', 0);
  // Setting variables - fast
  MyVar2^ := 50;
  // Setting built-in variables, fast
  Parser1.A := 60;
  // Getting variables - slowly
  ShowMessage('Value of MyVar1 = ' + FloatToStr(Parser1.Variable['MyVar1']));
  // Getting variables - fast
  ShowMessage('Value of MyVar2 = ' + FloatToStr(MyVar2^));
  // Getting built-in variables, fast
  ShowMessage('Value of A = ' + FloatToStr(Parser1.A));
end;

end.
