unit Main; // Simple Demo for PngLib
{
  Change Made By : Dominique Louis ( Dominique@SavageSoftware.com.au )
  Change Made On : 8 JUN 2000
  Change Description :
    Changed OpenDialog to OpenPictureDialog
    Now shows name of currently displayed image in Caption
    Added code to show Loading file progress in the status bar.
  --------------------------------------------------------------------------
  This is a demo program by Uberto Barbini (uberto@usa.net)
  // 20 Dec 1999.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, ExtDlgs, PngDef, ComCtrls, ToolWin, ActnList, ImgList;

type
  TFormMain = class(TForm)
    Image: TImage;
    MainMenu: TMainMenu;
    miOpenPng: TMenuItem;
    miSaveBmp: TMenuItem;
    SaveDialog: TSaveDialog;
    miOpenBmp: TMenuItem;
    miSavePng: TMenuItem;
    N1: TMenuItem;
    Exit: TMenuItem;
    N2: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Info: TMenuItem;
    miShowinfo: TMenuItem;
    N3: TMenuItem;
    miMergewithPNG: TMenuItem;
    OpenPictureDialog: TOpenPictureDialog;
    StatusBar: TStatusBar;
    Options1: TMenuItem;
    OpenWithPreview1: TMenuItem;
    OpenWithoutPreview1: TMenuItem;
    N4: TMenuItem;
    Savewithpreview1: TMenuItem;
    Savewithoutpreview1: TMenuItem;
    ToolBar1: TToolBar;
    ActionList: TActionList;
    OpenDialog: TOpenDialog;
    SavePictureDialog: TSavePictureDialog;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    aOpenPNG: TAction;
    aSavePNG: TAction;
    aOpenBMP: TAction;
    aSaveBMP: TAction;
    aMergePNG: TAction;
    aShowInfo: TAction;
    aAbout: TAction;
    ImageList: TImageList;
    aExit: TAction;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    miFile: TMenuItem;
    procedure OpenWithPreview1Click(Sender: TObject);
    procedure OpenWithoutPreview1Click(Sender: TObject);
    procedure Savewithpreview1Click(Sender: TObject);
    procedure Savewithoutpreview1Click(Sender: TObject);
    procedure aOpenPNGExecute(Sender: TObject);
    procedure aAboutExecute(Sender: TObject);
    procedure aExitExecute(Sender: TObject);
    procedure aShowInfoExecute(Sender: TObject);
    procedure aMergePNGExecute(Sender: TObject);
    procedure aSavePNGExecute(Sender: TObject);
    procedure aOpenBMPExecute(Sender: TObject);
    procedure aSaveBMPExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FOpenWithPreview : Boolean;
    FSaveWithPreview : Boolean;
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}
uses
  PngImage, Info;

procedure ReadCallback( png_ptr: png_structp; row_number: png_uint_32; pass: int ); stdcall;
begin
  if( png_ptr = nil ) or ( row_number > PNG_MAX_UINT ) then
    exit;
  FormMain.StatusBar.SimpleText := FormMain.StatusBar.SimpleText + ' . ';
end;


procedure TFormMain.OpenWithPreview1Click(Sender: TObject);
begin
  FOpenWithPreview := True;
end;

procedure TFormMain.OpenWithoutPreview1Click(Sender: TObject);
begin
  FOpenWithPreview := False;
end;

procedure TFormMain.Savewithpreview1Click(Sender: TObject);
begin
  FSaveWithPreview := True;
end;

procedure TFormMain.Savewithoutpreview1Click(Sender: TObject);
begin
  FSaveWithPreview := False;
end;

procedure TFormMain.aOpenPNGExecute(Sender: TObject);
const
  Filter = 'PNG Files|*.png';
  DefaultExt = 'png';
var
  PImage : TPngGraphic; //DL Added 08/06/2000
  Selected : Boolean;   //DL Added 13/06/2000
  FileName : string;    //DL Added 13/06/2000
begin
  if FOpenWithPreview then                      //DL Added 13/06/2000
  begin
    OpenPictureDialog.Filter := Filter;
    OpenPictureDialog.DefaultExt := DefaultExt;
    OpenPictureDialog.FileName := '';
    Selected := OpenPictureDialog.Execute;
    FileName := OpenPictureDialog.FileName;
  end
  else
  begin
    OpenDialog.Filter := Filter;
    OpenDialog.DefaultExt := DefaultExt;
    OpenDialog.FileName := '';
    Selected := OpenDialog.Execute;
    FileName := OpenDialog.FileName;
  end;

  if Selected then
  begin
    try
      StatusBar.SimpleText := 'Loading...';   //DL Added 08/06/2000
      PImage := TPngGraphic.Create;           //DL Added 08/06/2000
      try                                     //DL Added 08/06/2000
        PImage.Image.SetReadProgressCallback( @ReadCallBack ); //DL Added 08/06/2000
        PImage.LoadFromFile( Filename ); //DL Added 08/06/2000
        Image.Picture.Assign( PImage );    //DL Added 08/06/2000
        //Image.Picture.LoadFromFile(OpenDialog1.Filename); //DL changed 08/06/2000
        Caption := 'PngImage Test App - ' + ExtractFileName( Filename ); //DL Added 08/06/2000
        StatusBar.SimpleText := 'Ready';  //DL Added 08/06/2000
      finally                              //DL Added 08/06/2000
        PImage.Free;                       //DL Added 08/06/2000
      end;                                 //DL Added 08/06/2000
    except
      ShowMessage('Sorry, I don''t understand that kind of PNG');
    end;
  end;

end;

procedure TFormMain.aAboutExecute(Sender: TObject);
begin
  ShowMessage( 'Delphi PNG Interface, Originally created by Edmund Hand.' + #13#10
  + 'Updated by Uberto Barbini ( uberto@usa.net ),' + #13#10
  + 'Dominique Louis ( Dominique@SavageSoftware.com.au )' + #13#10
  + 'and David J Taylor ( david-taylor@blueyonder.co.uk )' );
end;

procedure TFormMain.aExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.aShowInfoExecute(Sender: TObject);
var
  im : TPNGImage;
begin
  if ( Image.Picture.Graphic is TPngGraphic ) then
  begin
    im := TPngGraphic( Image.Picture.Graphic ).Image;
    if assigned (im ) then
    begin
      with FrInfo do
      begin
        lbTime.Caption := DateTimeToStr( im.LastModified );
        Memo.Clear;
        Memo.Lines := im.TextChk;
        edTitle.Text := im.Title;
        edAuthor.Text := im.Author;
        edDescr.Text := im.Description;
        if ShowModal = mrOk then
        begin
          im.Title := edTitle.Text;
          im.Author := edAuthor.Text;
          im.Description := edDescr.Text;
        end;
      end;
    end;
  end
  else
    ShowMessage( 'No PNG present !' );
end;

procedure TFormMain.aMergePNGExecute(Sender: TObject);
const
  Filter = 'PNG Files|*.png';
  DefaultExt = 'png';
var
  Selected : Boolean;
  FileName : string;
  bmp: TBitmap;
begin
  if FOpenWithPreview then                      //DL Added 13/06/2000
  begin
    OpenPictureDialog.Filter := Filter;
    OpenPictureDialog.DefaultExt := DefaultExt;
    OpenPictureDialog.FileName := '';
    Selected := OpenPictureDialog.Execute;
    FileName := OpenPictureDialog.FileName;
  end
  else
  begin
    OpenDialog.Filter := Filter;
    OpenDialog.DefaultExt := DefaultExt;
    OpenDialog.FileName := '';
    Selected := OpenDialog.Execute;
    FileName := OpenDialog.FileName;
  end;

  if Selected then
  begin
    Bmp := TBitmap.Create;
    try
      if (Image.Picture.Graphic is TPngGraphic) then   // Convert to BMP format
        TPngGraphic(Image.Picture.Graphic).Image.CopyToBmp( Bmp )
      else if (Image.Picture.Graphic is TBitmap ) then
        Bmp.Assign( Image.Picture.Bitmap );

      Image.Picture.LoadFromFile( FileName );
      if (Image.Picture.Graphic is TPngGraphic) then   // Convert to BMP format
      begin
        TPngGraphic(Image.Picture.Graphic).Image.CopyToBmp( Bmp );
        TPngGraphic(Image.Picture.Graphic).Image.CopyFromBmp( Bmp );
      end;
    finally
      Bmp.Free;
    end;
  end;
end;

procedure TFormMain.aSavePNGExecute(Sender: TObject);
const
  Filter = 'PNG Files|*.png';
  DefaultExt = 'png';
var
  Saved : Boolean;
  FileName : string;
begin
  if FSaveWithPreview then                      //DL Added 13/06/2000
  begin
    SavePictureDialog.Filter := Filter;
    SavePictureDialog.DefaultExt := DefaultExt;
    SavePictureDialog.FileName := '';
    Saved := SavePictureDialog.Execute;
    FileName := SavePictureDialog.FileName;
  end
  else
  begin
    SaveDialog.Filter := Filter;
    SaveDialog.DefaultExt := DefaultExt;
    SaveDialog.FileName := '';
    Saved := SaveDialog.Execute;
    FileName := SaveDialog.FileName;
  end;

  if Saved then
    Image.Picture.SaveToFile( Filename );
end;

procedure TFormMain.aOpenBMPExecute(Sender: TObject);
const
  Filter = 'BMP Files|*.bmp';
  DefaultExt = 'bmp';
var
  Selected : Boolean;
  FileName : string;
  bm: TBitmap;
  apng : TPngGraphic;
begin
  if FOpenWithPreview then                      //DL Added 13/06/2000
  begin
    OpenPictureDialog.Filter := Filter;
    OpenPictureDialog.DefaultExt := DefaultExt;
    OpenPictureDialog.FileName := '';
    Selected := OpenPictureDialog.Execute;
    FileName := OpenPictureDialog.FileName;
  end
  else
  begin
    OpenDialog.Filter := Filter;
    OpenDialog.DefaultExt := DefaultExt;
    OpenDialog.FileName := '';
    Selected := OpenDialog.Execute;
    FileName := OpenDialog.FileName;
  end;

  if Selected then
  begin
    if not (Image.Picture.Graphic is TPngGraphic)  then
    begin
      // Convert to PNG format
      apng := TPngGraphic.Create;
      try
        Image.Picture.Graphic := apng;
      finally
        apng.Free;
      end;
    end;

    bm := TBitmap.Create;
    try
      bm.LoadFromFile( FileName );
      TPngGraphic(Image.Picture.Graphic).Image.CopyFromBmp(bm);
      Image.Invalidate;
    finally
      bm.Free;
    end;
  end;
end;

procedure TFormMain.aSaveBMPExecute(Sender: TObject);
const
  Filter = 'BMP Files|*.bmp';
  DefaultExt = 'bmp';
var
  Saved : Boolean;
  FileName : string;
  bm: TBitmap;
begin
  if FSaveWithPreview then                      //DL Added 13/06/2000
  begin
    SavePictureDialog.Filter := Filter;
    SavePictureDialog.DefaultExt := DefaultExt;
    SavePictureDialog.FileName := '';
    Saved := SavePictureDialog.Execute;
    FileName := SavePictureDialog.FileName;
  end
  else
  begin
    SaveDialog.Filter := Filter;
    SaveDialog.DefaultExt := DefaultExt;
    SaveDialog.FileName := '';
    Saved := SaveDialog.Execute;
    FileName := SaveDialog.FileName;
  end;

  if Saved and (Image.Picture.Graphic is TPngGraphic) then
  begin
    bm := TBitmap.Create;
    try
      TPngGraphic(Image.Picture.Graphic).Image.CopyToBmp(bm);
      bm.SaveToFile(FileName);
    finally
      bm.Free;
    end;
  end;
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  FOpenWithPreview := True;
  FSaveWithPreview := True;
end;

end.
