//---------------------------------------------------------------------------
#include <vcl.h>

#include <math.h>

#pragma hdrstop

#include "Normal1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Plot"
#pragma link "PlotMenu"
#pragma link "NEdit"
#pragma link "Nedit"
#pragma link "Plotimagelist"
#pragma link "Plotmenu"
#pragma link "Plottoolbar"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  Height = 500;
  Width = 750;

  MyPlot = new TPlot(this);
  MyPlot->Parent = this;
  MyPlot->Align = alClient;
  MyPlot->PlotType = ptXY;
  MyPlot->NoSeries = 2;
  MyPlot->MakeDummyData(20);

  MyPlotImageList = new TPlotImageList(this);
#ifdef COMPILER4_UP
  MyPlot->Images = MyPlotImageList;
#endif
  MyPlotMenu = new TPlotMenu(this);
#ifdef COMPILER4_UP
  MyPlotMenu->Images = MyPlotImageList;
#endif
  MyPlotMenu->Plot = MyPlot;
  //MyPlotMenu->SetUpOnClicks;

  MyPlotToolBar = new TPlotToolBar(this);
  MyPlotToolBar->Parent = this;
  MyPlotToolBar->Images = MyPlotImageList;
  MyPlotToolBar->Plot = MyPlot;   

  StringGrid1->Cells[0][0] = "Test:";
  StringGrid1->Cells[0][1] = "Score:";
  StringGrid1->ColWidths[0] = 60;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ExitMenuItemClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::GoBitBtnClick(TObject *Sender)
{
  Single X, Y;
  Single Mean;
  Single StdDev;
  Single Min;
  Single Max;
  Single StepSize;
  Single TheScore;
  Integer i;
  PSeries pMySeries;

  MyPlot->Series->ClearSeries();
  MyPlot->AddSeries(-1);

  Mean = MeanNEdit->AsReal;
  StdDev = StdDevNEdit->AsReal;
  Min = MinNEdit->AsReal;
  Max = MaxNEdit->AsReal;
  StepSize = StepSizeNEdit->AsReal;

//Set the axes:
  MyPlot->XAxis->Max = Max;
  MyPlot->XAxis->Min = Min;
  MyPlot->YAxis->Min = 0;
  MyPlot->XAxis->Intercept = 0;

  X = Min;
  do
  {
    Y = (X-Mean)/(2*StdDev);
    Y = Y * Y;
    Y = exp(-Y) / sqrt(2 * PI * StdDev);
//Don't fire any events, and don't adjust axes:
    MyPlot->Series->Items[0]->AddPoint(X, Y, FALSE, FALSE);
    X = X + StepSize;
  } while (X <= Max);

  MyPlot->YAxis->Min = MyPlot->Series->Items[0]->YMin;
  MyPlot->YAxis->Max = MyPlot->Series->Items[0]->YMax;

  for (i = 1; i < StringGrid1->ColCount; i++)
  {
    if (StringGrid1->Cells[i][0].Length() > 0)
    {
      if (StringGrid1->Cells[i][1].Length() > 0)
      {
        try
        {
          TheScore = StrToFloat(StringGrid1->Cells[i][1]);
          pMySeries = MyPlot->AddSeries(-1);
          //pMySeries = (PSeries) MyPlot->SeriesList->Items[TheSeries];
          pMySeries->Name = StringGrid1->Cells[i][0];
          pMySeries->AddPoint(TheScore, MyPlot->YAxis->Min, TRUE, TRUE);
          pMySeries->AddPoint(TheScore, MyPlot->YAxis->Max, TRUE, TRUE);
          pMySeries->Visible = TRUE;
          pMySeries->Symbol = (TSymbol) fmod(i, 1+syDownTriangle);
        }
        __finally 
        {}
      }
    }
  }

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::PlotTypeBitBtnClick(TObject *Sender)
{
  Integer ThePlotType;

  ThePlotType = MyPlot->PlotType;
  ThePlotType++;
  if (ThePlotType > pt3DColumn) ThePlotType = 0;

  MyPlot->Series->ClearSeries();

  //Initialise properties that can change:
  MyPlot->YAxis->LimitsVisible = FALSE;
  MyPlot->Contour->Interval = 1;
  MyPlot->Contour->Detail = cdLow;
  MyPlot->Contour->WireFrame = FALSE;
  //MyPlot->YAxis->TickDirection = orLeft;
  //MyPlot->YAxis->Title->Orientation = orLeft;
  MyPlot->YAxis->Min = 0;

  MyPlot->PlotType = (TPlotType) ThePlotType;

  MyPlot->Title->Caption = "TPlot - " + MyPlot->GetPlotTypeAsString();

  switch (MyPlot->PlotType)
  {
    case ptXY:
      {
        MyPlot->MakeDummyData(100);
        MyPlot->Border->Left = 70;
        MyPlot->Border->BottomGap = 80;
        FormActivate(this);
        break;
      };
/*    case ptError:
      {
        MyPlot->MakeDummyData(20);
        MyPlot->Series[0]->Symbol = syCircle;
        MyPlot->SetInstructionText("This is boring !");
        break;
      };
    case ptMultiple:
      {
        MyPlot->NoSeries = 4;
        MyPlot->Multiplicity = 4;
        MyPlot->MakeDummyData(20);
        MyPlot->Series[0]->Pen->Width = 0;
        MyPlot->Series[1]->Pen->Width = 0;
        MyPlot->Series[2]->Pen->Width = 0;
        MyPlot->Series[3]->Pen->Width = 0;
        MyPlot->Series[0]->Name = "High";
        MyPlot->Series[1]->Name = "Low";
        MyPlot->Series[2]->Name = "Open";
        MyPlot->Series[3]->Name = "Close";
        MyPlot->Series[0]->Symbol = syLeftDash;
        MyPlot->Series[1]->Symbol = syRightDash;
        MyPlot->MultiJoin = "2,3";
        MyPlot->SetInstructionText("Please wait while I add some Limits ...");
        Wait(2000, FALSE);
        MyPlot->YAxis->LimitLower = 2;
        MyPlot->YAxis->LimitUpper = 9;
        MyPlot->YAxis->LimitsVisible = TRUE;
        MyPlot->Series[3]->ShadeLimits = TRUE;
        MyPlot->SetInstructionText("Done !");
        break;
      };
    case ptBubble:
      {
        MyPlot->MakeDummyData(20);
        MyPlot->SetInstructionText("This is boring !");
        break;
      }; */
    case ptColumn:
    case ptStack:
    case ptNormStack:
      {
        MyPlot->Grids->GridType = gtNone;
        MyPlot->MakeDummyData(10);
        MyPlot->SetInstructionText("This is boring !");
        break;
      };
    case ptPie:
      {
        MyPlot->MakeDummyData(10);
        TheXStringData = new TStringList;
        TheXStringData->Add("Alpha");
        TheXStringData->Add("Bravo");
        TheXStringData->Add("Charlie");
        TheXStringData->Add("Delta");
        TheXStringData->Add("Echo");
        TheXStringData->Add("Foxtrot");
        TheXStringData->Add("Golf");
        TheXStringData->Add("Hotel");
        TheXStringData->Add("India");
        TheXStringData->Add("Juliet");
        TheXStringData->Add("Kilo");
        MyPlot->Series->Items[0]->XStringData = TheXStringData;
        MyPlot->Series->Items[1]->XStringData = TheXStringData;
        delete TheXStringData;
        MyPlot->SetInstructionText("This is very boring !");
        break;
      };
    case ptPolar:
      {
        MyPlot->XAxis->Min = -10;
        MyPlot->XAxis->Max = 10;
        MyPlot->YAxis->Min = -10;
        MyPlot->YAxis->Max = 10;
        MyPlot->MakeDummyData(20);
        MyPlot->XAxis->Intercept = 0;
        MyPlot->YAxis->Intercept = 0;
        MyPlot->SetInstructionText("This is extremely boring !");
        break;
      };
    case ptLineContour:
    case ptContour:
    case pt3DContour:
    case pt3DWire:
    case pt3DColumn:
      {
        if (MyPlot->PlotType > ptContour)
        {
          MyPlot->Border->Left = 120;
          MyPlot->Border->BottomGap = 130;
        };
        MyPlot->XAxis->Min = 0;
        MyPlot->XAxis->Max = 10;
        MyPlot->YAxis->Min = 0;
        MyPlot->YAxis->Max = 10;
        MyPlot->NoSeries = 10;
        MyPlot->MakeDummyData(20);
      };
  };

  switch (MyPlot->PlotType)
  {
    case ptLineContour:
      {
        MyPlot->SetInstructionText("Please wait while I increase the ContourDetail ...");
        Wait(2000, FALSE);
        MyPlot->Contour->Detail = cdMedium;
        MyPlot->Contour->Interval = MyPlot->Contour->Interval / 2;
        Wait(2000, FALSE);
        MyPlot->Contour->Detail = cdHigh;
        MyPlot->SetInstructionText("Done !");
        break;
      };
    case ptContour:
      {
        MyPlot->SetInstructionText("Please wait while I increase the ContourDetail ...");
        Wait(2000, FALSE);
        MyPlot->Contour->Detail = cdMedium;
        Wait(2000, FALSE);
        MyPlot->Contour->Detail = cdHigh;
        MyPlot->SetInstructionText("Done !");
        break;
      };
    case pt3DContour:
      {
        MyPlot->SetInstructionText("Please wait while I increase the ContourDetail ...");
        Wait(2000, FALSE);
        MyPlot->Contour->Detail = cdMedium;
        Wait(2000, FALSE);
        MyPlot->Contour->Detail = cdHigh;
        Wait(2000, FALSE);
        MyPlot->SetInstructionText("... add a wireframe ...");
        Wait(2000, FALSE);
        MyPlot->Contour->WireFrame = TRUE;
        MyPlot->SetInstructionText("... add some walls and grids ...");
        Wait(2000, FALSE);
        MyPlot->Grids->GridType = gtBoth;
        MyPlot->SetInstructionText("... move the axes to render them more visible ...");
        Wait(2000, FALSE);
        MyPlot->XAxis->Intercept = MyPlot->YAxis->Max;
        Wait(2000, FALSE);
        MyPlot->YAxis->Intercept = MyPlot->XAxis->Max;
        MyPlot->SetInstructionText("... re-arrange the Y Axis Title and Labels");
        Wait(2000, FALSE);
        //MyPlot->YAxis->TickDirection = orRight;
        //MyPlot->YAxis->Title->Orientation = orRight;
        MyPlot->SetInstructionText("... move the Z Axis ...");
        Wait(2000, FALSE);
        MyPlot->ZAxis->ZInterceptY = MyPlot->YAxis->Max;
        MyPlot->SetInstructionText("Done !");
        MyPlot->Refresh();
        break;
      };
    case pt3DWire:
    case pt3DColumn:
      {
        MyPlot->SetInstructionText("Please wait while I move the axes to render them more visible ...");
        Wait(2000, FALSE);
        MyPlot->XAxis->Intercept = MyPlot->YAxis->Max;
        MyPlot->YAxis->Intercept = MyPlot->XAxis->Max;
        //MyPlot->YAxis->TickDirection = orRight;
        //MyPlot->YAxis->Title->Orientation = orRight;
        MyPlot->SetInstructionText("Done !");
      };
  };
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::BitBtn3Click(TObject *Sender)
{
  MyPlot->MakeDummyData(100);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TraceBitBtnClick(TObject *Sender)
{
  MyPlot->Trace();    
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ClearAllBitBtnClick(TObject *Sender)
{
  Integer i;

  MyPlot->Series->ClearSeries();
  for (i = 1; i < StringGrid1->ColCount; i++)
  {
    StringGrid1->Cells[i][0] = "";
    StringGrid1->Cells[i][1] = "";
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::GoCrazyBitBtnClick(TObject *Sender)
{
  if (NULL != MyPlot->OnAfterPaint)
  {
    GoCrazyBitBtn->Caption = "Go Crazy";
    TraceBitBtn->Enabled = TRUE;
    MyPlot->OnAfterPaint = NULL;
  }
  else
  {
    Revolutions = 0;
    StartTime = Now();
    StartWidth = Width;
    StartHeight = Height;
    Angle = 0;
    AngleInc = 4 * PI / 180;
    GoCrazyBitBtn->Caption = "Enough !";
    TraceBitBtn->Enabled = FALSE;
    MyPlot->OnAfterPaint = Plot1AfterPaint;
    MyPlot->Invalidate();
  };
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CrazyTimerTimer(TObject *Sender)
{
  float fpm;

  if (MyPlot->PlotType >= pt3DContour)
  {
    MyPlot->ZAngle = MyPlot->ZAngle + 1;
  }
  else
  {
    Width = StartWidth + RADIUS * sin(Angle);
    Height = StartHeight + RADIUS * cos(Angle);
    Angle = Angle + AngleInc;
  };
  Revolutions++;
  ElapsedTime = Now() - StartTime;
  fpm = Revolutions / ((24 * 3600)*ElapsedTime);

  TVarRec v[] = { Revolutions, fpm };
  StatusBar1->SimpleText = Format(
    "%d frames, %8.2f frames per second",
    v, ARRAYSIZE(v) - 1);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::MyPlotFileOpen(TObject *Sender, AnsiString TheFile)
{
  AnsiString TheTitle;

  TheTitle = ExtractFileName(Application->ExeName);
  //TheTitle = Copy(TheTitle, 1, Length(TheTitle)-4);
  TheTitle.SetLength(TheTitle.Length()-4);
  TheTitle = TheTitle + " - " + ExtractFileName(TheFile);
  Application->Title = TheTitle;
  MainForm->Caption = TheTitle;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormActivate(TObject *Sender)
{
  if (ptXY == MyPlot->PlotType)
  {
    MyPlot->SetInstructionText("Please wait while I add some symbols ...");
    Wait(2000, TRUE);
    MyPlot->Series->Items[0]->Symbol = sySquare;
    Wait(2000, TRUE);
    MyPlot->Series->Items[1]->Symbol = syCircle;
    MyPlot->SetInstructionText("Done !");
  };
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Plot1AfterPaint(TObject *Sender,
      TCanvas *ACanvas)
{
  Application->ProcessMessages();
  CrazyTimerTimer(Sender);
}
//---------------------------------------------------------------------------

