unit Builder1;

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Install.dpr, released 12 December 2002.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 12/15/2002
Current Version: 1.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
To provide an easy to use build-then-install app for TPlot (and other complex components),
that works over all versions of Delphi. Then (hopefully) BC++ Builder and Kylix.


Known Issues:
This is highly experimental - caveat emptor !

History:
 1.00 15 Dec 2002:

Usage:
Parameters for Misc, TPlot:
  Root=C:\Users\matb\Delphi\Components Misc\%s%d\Misc300_Run.dpk Misc\%s%d\Misc300_Design.dpk TPlot\%s%d\Plot300_Run.dpk TPlot\%s%d\Plot300_Design.dpk TPlot\%s%d\DBPlot300_Run.dpk TPlot\%s%d\DBPlot300_Design.dpk
-----------------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Spin, Buttons, Grids, IniFiles, Registry,

  About, Aboutdlg, Misc, ExtCtrls, ActnList;

type
  TBuildForm = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    DelphiGroupBox: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    BCBGroupBox: TGroupBox;
    CheckBox21: TCheckBox;
    CheckBox22: TCheckBox;
    CheckBox23: TCheckBox;
    CheckBox24: TCheckBox;
    CheckBox25: TCheckBox;
    CheckBox26: TCheckBox;
    CheckBox27: TCheckBox;
    CheckBox28: TCheckBox;
    CheckBox29: TCheckBox;
    CheckBox30: TCheckBox;
    PackagesListBox: TListBox;
    Label1: TLabel;
    SpinButton1: TSpinButton;
    AddBitBtn: TBitBtn;
    RemoveBitBtn: TBitBtn;
    ClearAllBitBtn: TBitBtn;
    GroupBox1: TGroupBox;
    DelphiLabel: TLabel;
    BCBLabel: TLabel;
    DelphiSubDirEdit: TEdit;
    BCBSubDirEdit: TEdit;
    Label2: TLabel;
    RootLabel: TLabel;
    BuildBitBtn: TBitBtn;
    DosMemo: TMemo;
    LogMemo: TMemo;
    Splitter1: TSplitter;
    ActionList1: TActionList;
    BuildAction: TAction;
    AboutBitBtn: TBitBtn;
    CloseBitBtn: TBitBtn;
    AppsCheckBox: TCheckBox;
    StopBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AddBitBtnClick(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure RemoveBitBtnClick(Sender: TObject);
    procedure ClearAllBitBtnClick(Sender: TObject);
    procedure BuildActionExecute(Sender: TObject);
    procedure BuildActionUpdate(Sender: TObject);
    procedure AboutBitBtnClick(Sender: TObject);
    procedure CloseBitBtnClick(Sender: TObject);
    procedure StopBitBtnClick(Sender: TObject);
  private
    procedure AddPackage(APackage, RootDir: String);
    procedure SetRoot(Str: String);
{The following are from Samuel Herzog's uDelphiPackage - with minor changes}
    procedure AddPackageToRegistry(_RootKey:HKey;_Key,_PackageName,_PackageDescription:string); // delete a package entry from the registery    function GetField(_ch:char;var _s:string):string;
    function CanInstallPackage(_PackageName:string; var Description: string):boolean;
    function CompileProject(_Compiler,_CompilerSwitches,_ProjectName,_WorkPath:string;Var Output:String):boolean; // compile the package    function GetField(_ch:char;var _s:string):string;
    function GetField(_ch:char;var _s:string):string;
    procedure InstallPackage(Package, BplDir: String; _DelphiVersion:Integer);
    procedure ReadPackageListfromBPGFile(Filename: string; APackageList: TStringList);
    procedure ShutDownDelphi(_DelphiVersion:Integer;_Blocking : Boolean);
    function WinExecAndWait32V2(FileName,CommandLine,WorkPath: string; Visibility: Integer;Var Output:String): LongWord;
  public
    DoAbort: Boolean;
    SharedFilesDir: String;
    DelphiCheckBoxes: array [0..9] of TCheckBox;
    BCBCheckBoxes: array [0..9] of TCheckBox;
    Delphis: TStringList;
    BCBs: TStringList;
    //PackageList: TStringList;
  end;

var
  BuildForm: TBuildForm;

const
  cDelphiKey = 'SOFTWARE\Borland\Delphi\%d.0';
  cBCBKey = 'SOFTWARE\Borland\C++Builder\%d.0';

resourcestring
  sInstructions = 'Usage: Builder RootLabel.CaptionDir Package1[%s][%d].bpl [Package2.bpl ...]' + #13#10 +
    '       %s = D for Delphi, K for Kylix, BCB for BC++ Builder' + #13#10 +
    '       %d = Delphi, Kylix, BCB Version' + #13#10 +
    'The Package paths are relative to the RootLabel.CaptionDir' + #13#10 +
    'Example:' + #13#10 +
    'Builder C:\Users\matb\Delphi\Components Misc\%s%d\Misc300_Run.dpk';


implementation

{$R *.dfm}

procedure TBuildForm.FormCreate(Sender: TObject);
var
  i, iStart: Integer;
  Path: String;
  lpPath: array[0..4096] of char;
begin
  StopBitBtn.Left := BuildBitBtn.Left;
  StopBitBtn.Visible := FALSE;

  PackagesListBox.Anchors := [akLeft, akTop, akRight];
  SpinButton1.Anchors := [akTop, akRight];
  AboutBitBtn.Anchors := [akTop, akRight];
  BuildBitBtn.Anchors := [akTop, akRight];
  StopBitBtn.Anchors := [akTop, akRight];
  AddBitBtn.Anchors := [akTop, akRight];
  RemoveBitBtn.Anchors := [akTop, akRight];
  ClearAllBitBtn.Anchors := [akTop, akRight];
  CloseBitBtn.Anchors := [akTop, akRight];

  Left := 2;
  Width := Screen.Width - 4;
  LogMemo.Align := alClient;

  //PackageList := TStringList.Create;
  Delphis := TStringList.Create;
  BCBs := TStringList.Create;

{If $(DELPHI)\Projects\Bpl is on the PATH, then the linker can get confused about
 package dependencies: eg: it tries to graft the D6 Misc.dcp onto the D5 Plot.bpl -
 with very bad results. We therefore remove these directories from the PATH for
 this app and its children.}
  GetEnvironmentVariable('PATH', lpPath, 4096);
  Path := lpPath;
  iStart := -1;
  i := Pos('\Projects\Bpl', Path);
  while (i > 0) do
  begin
    iStart := Misc.BackPos(';', Path, i);
    if (iStart = -1) then iStart := 0;
    Inc(iStart);
    i := Misc.ForwardPos(';', Path, i+12);
    if (i = -1) then i := Length(Path);
    System.Delete(Path, iStart, i - iStart +1);
    i := Pos('\Projects\Bpl', Path);
  end;
  if (iStart > 0) then
  begin
    SetEnvironmentVariable('PATH', PChar(Path));
  end;

{Set up our checkbox arrays:}
  DelphiCheckBoxes[0] := CheckBox1;
  DelphiCheckBoxes[1] := CheckBox2;
  DelphiCheckBoxes[2] := CheckBox3;
  DelphiCheckBoxes[3] := CheckBox4;
  DelphiCheckBoxes[4] := CheckBox5;
  DelphiCheckBoxes[5] := CheckBox6;
  DelphiCheckBoxes[6] := CheckBox7;
  DelphiCheckBoxes[7] := CheckBox8;
  DelphiCheckBoxes[8] := CheckBox9;
  DelphiCheckBoxes[9] := CheckBox10;

  BCBCheckBoxes[0] := CheckBox21;
  BCBCheckBoxes[1] := CheckBox22;
  BCBCheckBoxes[2] := CheckBox23;
  BCBCheckBoxes[3] := CheckBox24;
  BCBCheckBoxes[4] := CheckBox25;
  BCBCheckBoxes[5] := CheckBox26;
  BCBCheckBoxes[6] := CheckBox27;
  BCBCheckBoxes[7] := CheckBox28;
  BCBCheckBoxes[8] := CheckBox29;
  BCBCheckBoxes[9] := CheckBox30;

{$IFDEF WIN32}
  DelphiGroupBox.Hint := 'What Delphi versions should I build ?';
  BCBGroupBox.Hint := 'What BC++ versions should I build ?';
  DelphiSubDirEdit.Hint := 'The prefix for Delphi subdirectories';
  BCBSubDirEdit.Hint := 'The prefix for BC++ Builder subdirectories';
{$ENDIF}
{$IFDEF LINUX}
  DelphiGroupBox.Caption := 'Kylix Version';
  DelphiGroupBox.Hint := 'What Kylix versions should I build ?';
  BCCGroupBox.Caption := 'Kylix BC++ Version';
  BCCGroupBox.Hint := 'What Kylix BC++ versions should I build ?';
  DelphiSubDirEdit.Hint := 'The prefix for Kylix subdirectories';
  BCBSubDirEdit.Hint := 'The prefix for Kylix C++ Builder subdirectories';
  BCBLabel.Caption := 'Kylix BC++';
  BCBEdit.Text := 'KCB';
  DelphiLabel.Caption := 'Kylix';
  DelphiEdit.Text := 'K';
{$ENDIF}
  BCBGroupBox.Hint := 'BC++ is not supported yet !';
  PackagesListBox.Hint := 'These are the packages (and applications) to build' + #13#10 +
    'The apps will only be built if "Build Applications as well ?" is checked';

{Set the root firectory of the Build:}
  SetRoot(ExtractFilePath(Application.ExeName));
{Examine the command line:}
  for i := 1 to ParamCount do
    AddPackage(Paramstr(i), RootLabel.Caption);
  Path := '';
  for i := 0 to ParamCount do
    Path := Path + Paramstr(i) + ' ';
  StatusBar1.SimpleText := Path;
end;

procedure TBuildForm.FormDestroy(Sender: TObject);
begin
  //PackageList.Free;
  Delphis.Free;
  BCBs.Free;
end;

procedure TBuildForm.FormShow(Sender: TObject);
var
  i: Integer;
  BorStr: String;
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_LOCAL_MACHINE;
  try
    for i := 0 to 9 do
    begin
      BorStr := Format(cDelphiKey, [i+1]);
{open registry key in no create mode:}
      if (Reg.OpenKey(BorStr, FALSE)) then
      begin
{get the home directory:}
        BorStr := Reg.ReadString('RootDir');
        if (BorStr[Length(BorStr)] = Misc.DIR_SEPERATOR) then
          SetLength(BorStr, Length(BorStr)-1);
        if (length(BorStr) > 0) then
        begin
          Delphis.Add(BorStr);
          {CreateDir(BorStr + 'Projects\Bpl');
          CreateDir(BorStr + 'Projects\dcu');}
          DelphiCheckBoxes[i].Enabled := TRUE;
          DelphiCheckBoxes[i].Checked := TRUE;
        end
        else
        begin
          Delphis.Add('');
          DelphiCheckBoxes[i].Enabled := FALSE;
        end;
        Reg.CloseKey;
      end
      else
      begin
        Delphis.Add('');
        DelphiCheckBoxes[i].Enabled := FALSE;
      end;
    end;

    for i := 0 to 9 do
    begin
      BorStr := Format(cBCBKey, [i+1]);
{open registry key in no create mode:}
      if (Reg.OpenKey(BorStr, FALSE)) then
      begin
{get the home directory:}
        BorStr := Reg.ReadString('RootDir');
        if (BorStr[Length(BorStr)] <> '\') then
          BorStr := BorStr + '\';
        if (length(BorStr) > 0) then
        begin
          BCBs.Add(BorStr);
          {CreateDir(BorStr + 'Projects\Bpl');
          CreateDir(BorStr + 'Projects\dcu');}
          BCBCheckBoxes[i].Enabled := TRUE;
          BCBCheckBoxes[i].Checked := TRUE;
        end
        else
        begin
          BCBs.Add('');
          BCBCheckBoxes[i].Enabled := FALSE;
        end;
        Reg.CloseKey;
      end
      else
      begin
        BCBs.Add('');
        BCBCheckBoxes[i].Enabled := FALSE;
      end;
    end;

    if (Reg.OpenKey('SOFTWARE\Borland\Borland Shared', FALSE)) then
    begin
{get the home page:}
      SharedFilesDir := Reg.ReadString('SharedFilesDir');
      Reg.CloseKey;
    end;
  finally
    Reg.Free;
  end;
end;

procedure TBuildForm.SetRoot(Str: String);
begin
  if (Str[Length(Str)] = Misc.DIR_SEPERATOR) then
    SetLength(Str, Length(Str)-1);
  if (Pos(Misc.DIR_SEPERATOR, Str) = 1) then // leading \
    Str := Copy(GetCurrentDir, 1, 2) + Str;
  if (Pos(':', Str) = 0) then
  begin
    Str := RootLabel.Caption + Str;
  end;
  RootLabel.Caption := Str;
end;

procedure TBuildForm.AddPackage(APackage, RootDir: String);
var
  i, iStart: Integer;
  Ext: String;
  SList: TStringList;

  procedure GetFullPath(var AFile: String);
  begin
    if (Pos('..', AFile) = 1) then // leading ..\
      AFile := Misc.CreatePathFromRelativePath(RootDir, AFile);
    if (Pos(Misc.DIR_SEPERATOR, AFile) = 1) then // leading \
      AFile := Copy(GetCurrentDir, 1, 2) + AFile;
    if (Pos(':', AFile) = 0) then
      AFile := RootDir + Misc.DIR_SEPERATOR + AFile;
  end;

begin
  if (Length(APackage) > 0) then
  begin
    iStart := Pos('root=', Lowercase(APackage));
    if (iStart > 0) then
    begin // is the root of the set of packages:
      SetRoot(Copy(APackage, 6, 999));
      RootDir := RootLabel.Caption;
    end
    else
    begin // is a package or a project group:
      GetFullPath(APackage);
      Ext := ExtractFileExt(APackage);
      if (Ext = '.bpg') then
      begin
        RootDir := ExtractFilePath(APackage);
        SetLength(RootDir, Length(RootDir)-1); // remove trailing "/\"
        SList := TStringList.Create;
        ReadPackageListfromBPGFile(APackage, SList);
        for i := 0 to SList.Count-1 do
          AddPackage(SList.Strings[i], RootDir);
        SList.Free;
      end
      else if (Ext = '.dpk') then
      begin
        if (PackagesListBox.Items.IndexOf(APackage) < 0) then
          PackagesListBox.Items.Add(APackage);
      end
      else if (Ext = '.dpr') then
      begin
        if (PackagesListBox.Items.IndexOf(APackage) < 0) then
          PackagesListBox.Items.Add(APackage);
      end;
    end;
  end;
end;

procedure TBuildForm.AddBitBtnClick(Sender: TObject);
var
  i: Integer;
  OpenDialog: TOpenDialog;

begin
  OpenDialog := TOpenDialog.Create(Self);
  OpenDialog.InitialDir := RootLabel.Caption;
  OpenDialog.DefaultExt := 'dpk';
  OpenDialog.Filter := 'Packages or Projects|*.dpk;*.bpg';
  OpenDialog.FilterIndex := 1;
  OpenDialog.Options := [ofHideReadOnly,ofAllowMultiSelect,ofEnableSizing];
  if (OpenDialog.Execute) then
  begin
    for i := 0 to OpenDialog.Files.Count-1 do
      AddPackage(OpenDialog.Files.Strings[i], RootLabel.Caption);
  end;
  OpenDialog.Free;
end;

procedure TBuildForm.SpinButton1DownClick(Sender: TObject);
begin
  if (PackagesListBox.ItemIndex < PackagesListBox.Items.Count-1) then
    PackagesListBox.Items.Exchange(PackagesListBox.ItemIndex, PackagesListBox.ItemIndex+1);
end;

procedure TBuildForm.SpinButton1UpClick(Sender: TObject);
begin
  if (PackagesListBox.ItemIndex > 0) then
    PackagesListBox.Items.Exchange(PackagesListBox.ItemIndex, PackagesListBox.ItemIndex-1);
end;

procedure TBuildForm.RemoveBitBtnClick(Sender: TObject);
begin
  PackagesListBox.Items.Delete(PackagesListBox.ItemIndex);
end;

procedure TBuildForm.ClearAllBitBtnClick(Sender: TObject);
begin
  PackagesListBox.Items.Clear;
end;

procedure TBuildForm.BuildActionExecute(Sender: TObject);
var
  i, j, DirPos, HighestDelphi, nPos: Integer;
  BplDir, Cmd, dofFile, Ext, Package, ResultsString, WorkPath: String;
  BCBSubDir, DelphiSubDir: String;

  procedure CreateTargetDirectories(dofFile: String);
  var
    Ini: TIniFile;

    procedure MakeDir(Ident: String);
    var
      TargetDir: String;
    begin
      TargetDir := Ini.ReadString('Directories', Ident, '');
      if (Length(TargetDir) > 0) then
      begin
        if (Pos('$(DELPHI)', TargetDir) > 0) then
          TargetDir := StringReplace(TargetDir, '$(DELPHI)', Delphis.Strings[i], [rfReplaceAll]);
        CreateDir(TargetDir);
      end;
    end; {MakeDir}

  begin {CreateTargetDirectories}
    BplDir := '';
    Ini := TIniFile.Create(dofFile);
    MakeDir('OutputDir');
    MakeDir('UnitOutputDir');
    MakeDir('PackageDLLOutputDir');
    BplDir := Ini.ReadString('Directories', 'PackageDLLOutputDir', '');
    MakeDir('PackageDCPOutputDir');
    Ini.Free;
  end; {CreateTargetDirectories}

  procedure BuildIt;
  begin
    StatusBar1.SimpleText := Format('Building %s for Delphi %d', [ExtractFileName(Package), i+1]);
    dofFile := ChangeFileExt(Package, '.dof');
    CreateTargetDirectories(dofFile);
    WorkPath := ExtractFilePath(Package);
    if (WorkPath[Length(WorkPath)] = Misc.DIR_SEPERATOR) then
      SetLength(WorkPath, Length(WorkPath)-1);
    SetCurrentDir(WorkPath);
    LogMemo.Lines.Add('  >' + Cmd + ' -B ' + Package);
    CompileProject(Cmd, '-B', Package, WorkPath, ResultsString);
    DosMemo.Lines.Clear;
    DosMemo.Lines.Text := ResultsString;
    if (Length(ResultsString) > 0) then
    begin
      if (pos('seconds,',DosMemo.Lines[DosMemo.Lines.Count-1])>0) or
         (pos('Sekunden',DosMemo.Lines[DosMemo.Lines.Count-1])>0) then
      begin
        LogMemo.Lines.Add('  ***Build Successful***');
        LogMemo.Lines.Add(Format('  Now trying to install %s in %s into the registry for Delphi %d',
          [Package, BplDir, i+1]));
        //InstallPackage(Package, BplDir, i+1);
      end
      else
      begin
        LogMemo.Lines.Add('  ---Build UN-Successful---:');
        LogMemo.Lines.Add(DosMemo.Lines[DosMemo.Lines.Count-1]);
      end;
    end
     else
      LogMemo.Lines.Add('###ERROR### No output recieved back from Compiler !');
    Application.ProcessMessages;
  end; {BuildIt}

begin
  DoAbort := FALSE;
  BuildBitBtn.Visible := FALSE;
  StopBitBtn.Visible := TRUE;
{Close all Delphis:}
  StatusBar1.SimpleText := 'Closing all Delphis ...';
  Application.ProcessMessages;

  for i := 1 to 9 do
  begin
    //ShutDownDelphi(i, TRUE);
  end;

{Check all projects for the presence of DelphiN or similar phrases:}
  DelphiSubDir := Misc.DIR_SEPERATOR + DelphiSubDirEdit.Text;
  BCBSubDir := Misc.DIR_SEPERATOR + BCBSubDirEdit.Text;
  for i:= 0 to PackagesListBox.Items.Count-1 do
  begin
    Package := PackagesListBox.Items.Strings[i];
    DirPos := Pos(DelphiSubDir, Package);
    {if (DirPos = 0) then
      DirPos := Pos(BCBSubDir, PackagesListBox.Items.Strings[i]);}
    while (DirPos > 0) do
    begin
      nPos := DirPos + Length(DelphiSubDir);
      if(Package[nPos] in ['1', '2', '3', '4', '5', '6', '7', '8', '9']) then
      begin
        if(Package[nPos+1] = Misc.DIR_SEPERATOR) then
        begin
          System.Delete(Package, DirPos+1, nPos-DirPos);
          System.Insert('%s%d', Package, DirPos+1);
          PackagesListBox.Items.Strings[i] := Package;
          break;
        end;
      end;
      DirPos := Misc.ForwardPos(DelphiSubDir, PackagesListBox.Items.Strings[i], nPos);
    end;
  end;

{What is the highest Delphi version ?}
  HighestDelphi := 0;
  for i := 0 to Delphis.Count-1 do
  begin
    if (DelphiCheckBoxes[i].Checked) then
      HighestDelphi := i;
  end;

{We build the Delphi packages; we do not know how to build the C++ Builder
 packages yet.}
  ResultsString := '';
  for i := 0 to Delphis.Count-1 do
  begin
    if (DoAbort) then break;
    if (DelphiCheckBoxes[i].Checked) then
    begin
      Cmd := Delphis.Strings[i] + '\Bin\dcc32.exe';
      if (Length(Cmd) > 0) then
      begin
        LogMemo.Lines.Add(Format(#13#10 + 'Building Packages for Delphi %d', [i+1]));
        for j := 0 to PackagesListBox.Items.Count-1 do
        begin
          if (DoAbort) then break;
          Package := PackagesListBox.Items[j];
          if (Pos('%s%d', Package) > 0) then
            Package := Format(Package, ['D', i+1]);
          Ext := Lowercase(ExtractFileExt(Package));
          if (Ext = '.dpk') then
          begin
            BuildIt;
          end
          else if (Ext = '.dpr') then
          begin
            if (HighestDelphi = i) then
              if (AppsCheckBox.Checked) then
                BuildIt;
          end;
        end;
      end; {Cmd > 0}
    end;
  end;
  BuildBitBtn.Visible := TRUE;
  StopBitBtn.Visible := FALSE;
  ShowMessage('Finished !');
end;

procedure TBuildForm.StopBitBtnClick(Sender: TObject);
begin
  DoAbort := TRUE;
end;

procedure TBuildForm.BuildActionUpdate(Sender: TObject);
begin
  BuildAction.Enabled := (PackagesListBox.Items.Count > 0);
end;

//*****************************************************
// Method:  GetField
// Programmer: S.Herzog
// Description: get a field from a string <_s> seperated by chars <_ch>.
// Last changes: 23.04.02
//*****************************************************
function TBuildForm.GetField(_ch:char;var _s:string):string;
var
_pos:integer;
begin
  Result:='';
  _pos:=Pos(_ch,_s);
  if _pos=0 then begin
    Result:=_s;
    _s:='';
    exit;
  end;
  Result:=Copy(_s,1,_pos-1);
  Delete(_s,1,_pos);
end;

{-----------------------------------------------------------------------------
  Procedure: ReadPackageListfromBPGFile
  Author:    herzogs2
  Date:      22-Aug-2002
  Arguments: _filename:string;var _lbx:TListbox
  Result:    None
  Description:
-----------------------------------------------------------------------------}
procedure TBuildForm.ReadPackageListfromBPGFile(Filename:string; APackageList: TStringList); // read the package names from the delphi project group file <.bpg>
var
  _BPGFile:TStrings;
  i:integer;
  _line:string;
  _Projects:String;
  _Project:String;
  _idx:Integer;

  function RemoveSlash(_Project:String):String;
  var
  _pos:Integer;
  begin
    Result:=_Project;
    _pos:=Pos('\',_Project);
    if _pos>0 then begin
      System.Delete(_Project,_pos,1);
      Result:=trim(_project);
    end;
  end;

begin
  if not fileExists(Filename) then begin
    //LogMemo.Lines.Add(format('ReadPackageListfromBPGFile: Could not find the file <%s>.',[Filename]));
    exit;
  end;
  _BPGFile:=TStringList.Create;
  _BPGFile.LoadFromFile(Filename);
  _idx:=0;
  _Projects:='';
  for i:=0 to _BPGFile.Count-1 do begin
    _line:=trim(_BPGFile.Strings[i]);
    if Pos('PROJECTS',_line)=1 then _Projects:=_line
    else begin
      if _Projects<>'' then begin
        if pos('#--------------',_line)=1 then begin
          _idx:=i;
          break;
        end
        else _Projects:=_Projects+_line;
      end;
    end;
  end;
  System.Delete(_Projects,1,10);
  _Projects:=trim(_Projects);
  _Project:=GetField(' ',_Projects);
  _Project:=RemoveSlash(_Project);
  while _Project<>'' do begin
    for i:=_idx to _BPGFile.Count-1 do begin
      _line:=trim(_BPGFile.Strings[i]);
      if Pos(_Project,_line)=1 then begin
        System.Delete(_line,1,Pos(':',_line));
        APackageList.Add(Trim(_line));
        break;
      end;
    end;
    _Project:=GetField(' ',_Projects);
    _Project:=RemoveSlash(_Project);
  end;
  _BPGFile.free;
end;

{-----------------------------------------------------------------------------
  Procedure: ShutDownDelphi
  Author:    m.birbaumer
  Date:      30-Aug-2002
  Arguments: Blocking : Boolean
  Result:    None
  Description:
-----------------------------------------------------------------------------}
procedure TBuildForm.ShutDownDelphi(_DelphiVersion:Integer;_Blocking : Boolean);
var
  _hWnd : THandle;
begin
  _hWnd := FindWindow('TApplication', PChar('Delphi '+inttostr(_DelphiVersion)));

  if _hWnd <> 0 then begin
    if _Blocking then SendMessage(_hWnd, WM_CLOSE, 0, 0)
                 else PostMessage(_hWnd, WM_CLOSE, 0, 0);
  end;
end;

{-----------------------------------------------------------------------------
  Procedure: CanInstallPackage
  Author:    herzogs2
  Date:      22-Aug-2002
  Arguments: _PackageName:string
  Result:    boolean
  Description: runtime only packages can not be installed in the delphi IDE.
-----------------------------------------------------------------------------}
function TBuildForm.CanInstallPackage(_PackageName:string; var Description: String):boolean; // checks if it is a designtime package or not
var
  i, iPos: Integer;
  _DPKFile:TStrings;
begin
  Result := FALSE;
  Description := '';
  if not fileExists(_PackageName) then begin
    LogMemo.Lines.Add(format('IsDesignPackage: Could not find the file <%s>.',[_PackageName]));
    exit;
  end;
  _DPKFile:=TStringList.Create;
  _DPKFile.LoadFromFile(_PackageName);
  for i := 0 to _DPKFile.Count-1 do
  begin
    iPos := Pos('$DESCRIPTION', _DPKFile.Strings[i]);
    if Pos('$DESIGNONLY', _DPKFile.Strings[i]) > 0 then
    begin
      Result:=TRUE;
      if (Length(Description) > 0) then
        break;
    end
// {$DESCRIPTION 'Chemware Scientific Plotting Component (Run time)'}
    else if (iPos > 0) then
    begin
      Description := _DPKFile.Strings[i];
      Description := Copy(Description, iPos + 14, 9999);
      SetLength(Description, Length(Description)-2);
      if (Result) then
        break;
    end;
  end;
  _DPKFile.free;
end;

{-----------------------------------------------------------------------------
  Procedure: InstallPackage
  Author:    herzogs2
  Date:      30-Aug-2002
  Arguments: _PackageName,_PackageDirectory:String;_DelphiVersion:Integer
  Result:    None
  Description: install the delphi package <_PackageName> which is located in the
               directory <_PackageDirectory> for delphi version <_DelphiVersion>.
               The parameter <_PackageDirectory> points to the location of the <.bpl> file.
-----------------------------------------------------------------------------}
procedure TBuildForm.InstallPackage(Package, BplDir:String; _DelphiVersion:Integer);
var
  Description, _PackageKey:String;
begin
  if (Lowercase(ExtractFileExt(Package)) <> '.dpk') then exit;

  _PackageKey := Format(cDelphiKey + '\Known Packages', [_DelphiVersion]);

  if (Length(BplDir) > 0) then
  begin
    BplDir := BplDir + Misc.DIR_SEPERATOR + ExtractFileRoot(Package) + '.bpl';
  end
  else
  begin
    BplDir := ChangeFileExt(Package,'.bpl');
  end;

  if CanInstallPackage(Package, Description) then begin
    AddPackageToRegistry(HKEY_CURRENT_USER, _PackageKey, BplDir, Description);
    if (_DelphiVersion >= 6) then
      AddPackageToRegistry(HKEY_LOCAL_MACHINE, _PackageKey, BplDir, Description);
  end
  else LogMemo.Lines.Add(Format('InstallPackage: The package <%s> is a runtime only package. It will not be installed into the IDE.',[Package]));
end;

{-----------------------------------------------------------------------------
  Procedure: AddPackageToRegistry
  Author:    herzogs2
  Date:      30-Aug-2002
  Arguments: _RootKey:HKey;_Key,_PackageName,_PackageDescription:string
  Result:    None
  Description:
               19.11.2002 - added error message in case the user has no administrator rights
-----------------------------------------------------------------------------}
procedure TBuildForm.AddPackageToRegistry(_RootKey:HKey;_Key,_PackageName,_PackageDescription:string); // delete a package entry from the registery
var
  _Reg: TRegistry;
begin
  _Reg := TRegistry.Create;
  try
    _Reg.RootKey := _RootKey;
    if not _Reg.ValueExists(_PackageName) then begin
      _Reg.OpenKey(_Key,false);
      try
        _Reg.WriteString(_PackageName,_PackageDescription);
        LogMemo.Lines.Add(format('AddPackageToRegistry: Successfully installed the  Packages <%s>.',[_PackageName]));
      except
        LogMemo.Lines.Add(format('Problem in AddPackageToRegistry: Could not add the package <%s> to the registry.You need to have Admin rights for this computer.',[_PackageName]));
      end;
      _Reg.CloseKey;
    end else LogMemo.Lines.Add(format('AddPackageToRegistry: The Packages <%s> is already registered.',[_PackageName]));
  finally
    _Reg.Free;
  end;
end;

{-----------------------------------------------------------------------------
  Procedure: CompileProject
  Author:    herzogs2
  Date:      29-Aug-2002
  Arguments:
  _Compiler   --> full name and path to bcc32.exe
  _CompilerSwitches, --> compiler switches like -W -H -B for example
  _ProjectName --> the name of the project to be compiled (can be .dpr or .dpk )
  _TargetPath,  --> output target path - removed by MJB because unused
  Var Output:String   --> output text of the compiler.
  Result:    boolean
  Description:
-----------------------------------------------------------------------------}
function TBuildForm.CompileProject(_Compiler,_CompilerSwitches,_ProjectName,_WorkPath:string;Var Output:String):boolean; // compile the package
var
_commandLine:string;
begin
  Result:=false;
  if fileexists(_Compiler) then begin
    if FileExists(_ProjectName) then begin
      LogMemo.Lines.Add('');
      LogMemo.Lines.Add('*************************************************************************************');
      LogMemo.Lines.Add(format('Compile Project <%s>.',[_ProjectName]));
      _commandLine:=Trim(_CompilerSwitches+' '+_ProjectName);
      WinExecAndWait32V2(_compiler,
                         _commandLine,
                         _WorkPath,
                         SW_HIDE,
                         Output);

      if (pos('seconds,',Output)>0) or
         (pos('Sekunden',Output)>0) then begin
        LogMemo.Lines.Add(format('CompileProject: Successfully build Project file <%s>.',[_ProjectName]));
        Result:=True;
      end;
    end else LogMemo.Lines.Add(format('CompileProject: Problem, could not find the Project file <%s>.',[_ProjectName]));
  end else LogMemo.Lines.Add(format('CompileProject: Problem, could not find the Delphi Compiler file <%s>.',[_Compiler]));
end;

{-----------------------------------------------------------------------------
  Procedure: WinExecAndWait32V2
  Author:    P.Below
             Added Output parameter by S.Herzog
  Date:      22-Aug-2002
  Arguments: FileName: string; Visibility: Integer
  Result:    DWORD
  Description:
-----------------------------------------------------------------------------}
function TBuildForm.WinExecAndWait32V2(FileName,CommandLine,WorkPath: string; Visibility: Integer;Var Output:String): LongWord;
  procedure WaitFor(processHandle: THandle);
  var
    Msg: TMsg;
    ret: DWORD;
  begin
    repeat
      ret := MsgWaitForMultipleObjects(1, { 1 handle to wait on }
        processHandle, { the handle }
        False, { wake on any event }
        INFINITE, { wait without timeout }
        QS_PAINT or { wake on paint messages }
        QS_SENDMESSAGE { or messages from other threads }
        );
      if ret = WAIT_FAILED then Exit; { can do little here }
      if ret = (WAIT_OBJECT_0 + 1) then
      begin
          { Woke on a message, process paint messages only. Calling
            PeekMessage gets messages send from other threads processed. }
        while PeekMessage(Msg, 0, WM_PAINT, WM_PAINT, PM_REMOVE) do
          DispatchMessage(Msg);
      end;
    until ret = WAIT_OBJECT_0;
  end; { Waitfor }
var { V1 by Pat Ritchey, V2 by P.Below }
  StartupInfo: TStartupInfo;
  ProcessInfo: TProcessInformation;
  SA: TSecurityAttributes;
  StdOutPipeRead,
  StdOutPipeWrite: THandle;
  Buffer: array[0..255] of Char;
  BytesRead: Cardinal;
  _Line: String;
  _tmp:String;
begin { WinExecAndWait32V2 }
//  Trace(Filename);
  _Line:='';
   with SA do
   begin
     nLength := SizeOf(SA);
     bInheritHandle := True;
     lpSecurityDescriptor := nil;
   end;
   CreatePipe(StdOutPipeRead,  // read handle
              StdOutPipeWrite, // write handle
              @SA,             // security attributes
              65535                // number of bytes reserved for pipe - 0 default
              );

//  StrPCopy(zAppName, FileName);
  FillChar(StartupInfo, SizeOf(StartupInfo), #0);
  StartupInfo.cb          := SizeOf(StartupInfo);
  StartupInfo.dwFlags     := STARTF_USESHOWWINDOW  or  STARTF_USESTDHANDLES;
  StartupInfo.wShowWindow := Visibility;
  StartupInfo.hStdInput  := GetStdHandle(STD_INPUT_HANDLE); // don't redirect std input
  StartupInfo.hStdOutput := StdOutPipeWrite;
  StartupInfo.hStdError  := StdOutPipeWrite;

  if not CreateProcess(
    //zAppName, { pointer to command line string }
    PChar(FileName),    //appplication to be executed
    PChar(CommandLine), // command line.
    nil,
    nil, { pointer to thread security attributes }
    true, { handle inheritance flag }
    CREATE_NEW_CONSOLE or { creation flags }
    NORMAL_PRIORITY_CLASS,
    nil, { pointer to new environment block }
    PChar(WorkPath), { pointer to current directory name }
    StartupInfo, { pointer to STARTUPINFO }
    ProcessInfo) { pointer to PROCESS_INF } then
    Result := DWORD(-1) { failed, GetLastError has error code }
  else
  begin
    Waitfor(ProcessInfo.hProcess);
    GetExitCodeProcess(ProcessInfo.hProcess, Result);
    CloseHandle(ProcessInfo.hProcess);
    CloseHandle(ProcessInfo.hThread);
    CloseHandle(StdOutPipeWrite);
  end; { Else }
  ReadFile(StdOutPipeRead, Buffer, 255, BytesRead, nil);
  while BytesRead>0 do begin
    Buffer[BytesRead] := #0;
    // combine the buffer with the rest of the last run
    _tmp:=string(trim(Buffer));
    _Line := _Line + _tmp;
    ReadFile(StdOutPipeRead, Buffer, 255, BytesRead, nil);
  end;
  if length(_line)>0 then Output:=_Line;
  CloseHandle(StdOutPipeRead);
end; { WinExecAndWait32V2 }


procedure TBuildForm.AboutBitBtnClick(Sender: TObject);
var
  Aboutdlg: TAboutdlg;
begin
  Aboutdlg := TAboutdlg.Create(Self);
  Aboutdlg.Comments := 'Acknowledgements to:'  + #13#10 +
    '    Samuel Herzog' + #13#10 +
    '    Peter Below' + #13#10 +
    '    M. Birbaumer' + #13#10 +
    Aboutdlg.Comments;
  Aboutdlg.Execute;
  Aboutdlg.Free;
end;

procedure TBuildForm.CloseBitBtnClick(Sender: TObject);
begin
  Close;
end;

end.

