unit DBDemo1;

{$I Plot.inc}

interface

uses
  SysUtils, Classes, TypInfo,
  Db, DBCtrls, DBTables, 
{$IFDEF WIN32}
  Windows, Messages, Graphics, Controls, Forms, Dialogs,
  ActnList, ImgList, Mask, Menus, Grids, ExtCtrls, StdCtrls,
  Buttons, ToolWin, ComCtrls,
{$ENDIF}
{$IFDEF LINUX}
  Qt, QTypes,
  QGraphics, QControls, QForms, QDialogs,
  QActnList, QImgList, QMask, QMenus, QGrids, QExtCtrls, QStdCtrls,
  QButtons, QComCtrls, QDBCtrls,
{$ENDIF}

  Plot, Plotdefs, Plotmenu, Plotimagelist, Data, Plottoolbar, Nedit,
  DBPlot;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    MinNEdit: TNEdit;
    Label1: TLabel;
    Label2: TLabel;
    MaxNEdit: TNEdit;
    Label3: TLabel;
    StepSizeNEdit: TNEdit;
    Label4: TLabel;
    MeanNEdit: TNEdit;
    Label5: TLabel;
    StdDevNEdit: TNEdit;
    GoBitBtn: TBitBtn;
    GoCrazyBitBtn: TBitBtn;
    CrazyTimer: TTimer;
    ClearAllBitBtn: TBitBtn;
    NoisyBitBtn: TBitBtn;
    TraceBitBtn: TBitBtn;
    TypeBitBtn: TBitBtn;
    StatusBar1: TStatusBar;
    Panel2: TPanel;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    TitleDBEdit: TDBEdit;
    DateDBEdit: TDBEdit;
    ActionList1: TActionList;
    GoAction: TAction;
    NoisyAction: TAction;
    ClearAllAction: TAction;
    TypeAction: TAction;
    procedure ClearAllBitBtnClick(Sender: TObject);
    procedure GoBitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlotMenu1ExitMenuItemClick(Sender: TObject);
    procedure NoisyBitBtnClick(Sender: TObject);
    procedure GoCrazyBitBtnClick(Sender: TObject);
    procedure CrazyTimerTimer(Sender: TObject);
    procedure MyPlotFileOpen(Sender: TObject; TheFile: String);
    procedure TraceBitBtnClick(Sender: TObject);
    procedure TypeBitBtnClick(Sender: TObject);
    procedure DBNavigator1BeforeAction(Sender: TObject;
      Button: TNavigateBtn);
    procedure GoActionUpdate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
{$IFDEF GUI}
    MyPlot: TDBPlot;
    MyPlotMenu: TPlotMenu;
    MyPlotImageList: TPlotImageList;
    MyPlotToolBar: TPlotToolBar;
{$ELSE}
    MyPlot: TConsoleDBPlot;
{$ENDIF}
    Revolutions,
    StartWidth,
    StartHeight: Integer;
    Angle,
    AngleInc: Single;
{$IFDEF WIN32}
    Table1: TTable;
{$ENDIF}
{$IFDEF LINUX}
    ClientDataSet1: TClientDataSet;
{$ENDIF}
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

const
  RADIUS = 50.0;

procedure TMainForm.FormCreate(Sender: TObject);
begin
{$IFDEF GUI}
  MyPlotImageList := TPlotImageList.Create(Self);

{$IFDEF WIN32}
  Table1 := TTable.Create(Self);
  Table1.TableName := 'DemoData.db';
  DataSource1.DataSet := Table1;
{$ENDIF}
{$IFDEF LINUX}
  ClientDataSet1 := TClientDataSet.Create(Self);
  ClientDataSet1.MasterSource := DataSource1;
{TODO 1 -o DB Expert -c Database : need to add working database here}
{$ENDIF}

  MyPlot := TDBPlot.Create(Self);
  MyPlot.Parent := Self;
  MyPlot.Align := alClient;
  MyPlot.Images := MyPlotImageList;
  MyPlot.DataSource := DataSource1;
  MyPlot.DataField := 'Plot';
  MyPlot.PlotType := ptXY;

  MyPlotMenu := TPlotMenu.Create(Self);
  MyPlotMenu.Images := MyPlotImageList;
  MyPlotMenu.Plot := TPlot(MyPlot);
  MyPlotMenu.SetUpOnClicks;

  MyPlotToolBar := TPlotToolBar.Create(Self);
  MyPlotToolBar.Parent := Self;
  MyPlotToolBar.Images := MyPlotImageList;
  MyPlotToolBar.Plot := TPlot(MyPlot);

  Table1.Active := TRUE;
{$ELSE}
  MyPlot := TConsoleDBPlot.Create(Self);
  MyPlot.DataSource := DataSource1;
  MyPlot.DataField := 'Plot';
  MyPlot.PlotType := ptXY;
{$ENDIF}

{$IFDEF WIN32}
  Self.Caption := 'TDBPlot demo for Delphi';
{$ENDIF}
{$IFDEF LINUX}
  Self.Caption := 'TDBPlot demo for Kylix';
{$ENDIF}
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
{$IFDEF WIN32}
  Table1.Free;
{$ENDIF}
{$IFDEF LINUX}
  ClientDataSet1.Free;
{$ENDIF}
end;

procedure TMainForm.ClearAllBitBtnClick(Sender: TObject);
begin
  MyPlot.Clear(FALSE);
end;

procedure TMainForm.GoBitBtnClick(Sender: TObject);
var
  X, Y: Single;
  Mean: Single;
  StdDev: Single;
  Min: Single;
  Max: Single;
  StepSize: Single;
{$IFDEF MSWINDOWS}
  FStartTime:          Int64; {TLargeInteger;}
  FFinishTime:         Int64;
  FFrequency:          Int64;
{$ENDIF}
{$IFDEF LINUX}
  FStartTime:          TDateTime;
  FFinishTime:         TDateTime;
{$ENDIF}
  ElapsedTime: Double;
begin
  MyPlot.NoSeries := 1;
  MyPlot.Series[0].DelData;

  Screen.Cursor := crHourGlass;
{$IFDEF MSWINDOWS}
  QueryPerformanceFrequency(FFrequency); {counts per second}
{get the starting time:}
  QueryPerformanceCounter(FStartTime); { LARGE_INTEGER}
{$ENDIF}
{$IFDEF LINUX}
  FStartTime := Time;
{$ENDIF}

  Mean := MeanNEdit.AsReal;
  StdDev := StdDevNEdit.AsReal;
  Min := MinNEdit.AsReal;
  Max := MaxNEdit.AsReal;
  StepSize := StepSizeNEdit.AsReal;

{Set the axes:}
  MyPlot.XAxis.Max := Max;
  MyPlot.XAxis.Min := Min;
  MyPlot.YAxis.Min := 0;
  MyPlot.XAxis.Intercept := 0;

  X := Min;
  while (X <= Max) do
  begin
    Y := Exp(-Sqr((X-Mean)/(2*StdDev))) /
      Sqrt(2*Pi*StdDev);
{Don't fire any events, and don't adjust axes:}
    MyPlot.Series[0].AddPoint(X, Y, FALSE, FALSE);
    X := X + StepSize;
  end;
  MyPlot.Series[0].Visible := TRUE;

  {MyPlot.YAxis.Min := MyPlot.Series[0].YMin;}
  MyPlot.YAxis.Max := MyPlot.Series[0].YMax;

  {for i := 1 to StringGrid1.ColCount-1 do
  begin
    if (Length(StringGrid1.Cells[i, 0]) > 0) then
    begin
      if (Length(StringGrid1.Cells[i, 1]) > 0) then
      begin
        try
          TheScore := StrToFloat(StringGrid1.Cells[i, 1]);
          TheSeries := MyPlot.Add(-1);
          MyPlot[TheSeries].Name := StringGrid1.Cells[i, 0];
          MyPlot[TheSeries].AddPoint(TheScore, MyPlot.YAxis.Min, TRUE, TRUE);
          MyPlot[TheSeries].AddPoint(TheScore, MyPlot.YAxis.Max, TRUE, TRUE);
          MyPlot[TheSeries].Visible := TRUE;
          MyPlot[TheSeries].Symbol := TSymbol(i mod (1+Ord(sDownTriangle)));
        finally
        end;
      end;
    end;
  end;}
{get the finishing time:}
{$IFDEF MSWINDOWS}
  QueryPerformanceCounter(FFinishTime); { LARGE_INTEGER}
{take difference and convert to ms:}
  ElapsedTime := 1000 * (FFinishTime - FStartTime) / FFrequency;
{$ENDIF}
{$IFDEF LINUX}
  FFinishTime := Time;
  ElapsedTime := 1000 * (FFinishTime - FStartTime);
{$ENDIF}
  StatusBar1.SimpleText := Format('Drawing %d points takes %g ms',
    [MyPlot.Series[0].NoPts, ElapsedTime]);

  Screen.Cursor := crDefault;
  
end;

procedure TMainForm.PlotMenu1ExitMenuItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.NoisyBitBtnClick(Sender: TObject);
begin
  MyPlot.MakeDummyData(100);
end;

procedure TMainForm.GoCrazyBitBtnClick(Sender: TObject);
begin
  if (CrazyTimer.Enabled) then
  begin
    CrazyTimer.Enabled := FALSE;
    GoCrazyBitBtn.Caption := 'Go Crazy';
    TraceBitBtn.Enabled := TRUE;
  end
  else
  begin
    Revolutions := 0;
    StartWidth := Width;
    StartHeight := Height;
    Angle := 0;
    AngleInc := 4 * Pi / 180;
    GoCrazyBitBtn.Caption := 'Enough !';
    CrazyTimer.Enabled := TRUE;
    TraceBitBtn.Enabled := FALSE;
  end;
end;

procedure TMainForm.CrazyTimerTimer(Sender: TObject);
begin
  if (MyPlot.PlotType >= pt3DContour) then
  begin
    MyPlot.ZAngle := MyPlot.ZAngle + 1;
  end
  else
  begin
    Width := StartWidth + Round(RADIUS * Sin(Angle));
    Height := StartHeight + Round(RADIUS * Cos(Angle));
    Angle := Angle + AngleInc;
    Inc(Revolutions);
    StatusBar1.SimpleText := IntToStr(Revolutions);
  end;
end;

procedure TMainForm.MyPlotFileOpen(Sender: TObject; TheFile: String);
var
  TheTitle: String;
begin
  TheTitle := ExtractFileName(Application.ExeName);
  TheTitle := Copy(TheTitle, 1, Length(TheTitle)-4);
  TheTitle := TheTitle + ' - ' + ExtractFileName(TheFile);
  Application.Title := TheTitle;
  MainForm.Caption := TheTitle;
end;

procedure TMainForm.TraceBitBtnClick(Sender: TObject);
begin
  MyPlot.Trace;
end;

procedure TMainForm.TypeBitBtnClick(Sender: TObject);
var
 ThePlotType: Integer;
begin
  ThePlotType := Ord(MyPlot.PlotType);
  ThePlotType := (ThePlotType+1) mod (Ord(High(TPlotType))+1);
  MyPlot.PlotType := TPlotType(ThePlotType);
  MyPlot.Title.Caption := 'TPlot - ' + #10 +
    Copy(TypInfo.GetEnumName(TypeInfo(TPlotType), ThePlotType), 3, 99);
  case MyPlot.PlotType of
    ptXY:
      begin
        MyPlot.Border.Left := 70;
        MyPlot.Border.BottomGap := 80;
      end;
    ptColumn, ptStack, ptNormStack: ;
    ptPie: ;
    ptPolar:
      begin
        MyPlot.XAxis.Min := -10;
        MyPlot.XAxis.Max := 10;
        MyPlot.YAxis.Min := -10;
        MyPlot.YAxis.Max := 10;
        MyPlot.XAxis.Intercept := 0;
        MyPlot.YAxis.Intercept := 0;
      end;
    ptContour, pt3DContour, pt3DWire:
      begin
        if (MyPlot.PlotType > ptContour) then
        begin
          MyPlot.Border.Left := 120;
          MyPlot.Border.BottomGap := 130;
        end;
        MyPlot.XAxis.Min := 0;
        MyPlot.XAxis.Max := 10;
        MyPlot.YAxis.Min := 0;
        MyPlot.YAxis.Max := 10;
      end;
  else ;
  end;
end;

procedure TMainForm.DBNavigator1BeforeAction(Sender: TObject;
  Button: TNavigateBtn);
begin
  if ((Button = nbInsert) or
      (Button = nbEdit)) then
  begin
    DateDBEdit.Text := DateToStr(Now);
    TitleDBEdit.Text := MyPlot.Title.Caption;
  end;
end;

procedure TMainForm.GoActionUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled := not MyPlot.ReadOnly;
end;

end.
