unit Demo1;

{$I Version.inc}

interface

uses
  SysUtils, Classes, TypInfo,
{$IFDEF WIN32}
  Windows, Messages, Graphics, Controls, Forms, Dialogs,
  ActnList, ImgList, Menus, Grids, ExtCtrls, StdCtrls,
  Buttons, ToolWin, ComCtrls,
{$ENDIF}
{$IFDEF LINUX}
  Types,
  Qt, QTypes,
  QGraphics, QControls, QForms, QDialogs,
  QActnList, QImgList, QMenus, QGrids, QExtCtrls, QStdCtrls,
  QButtons, QComCtrls,
{$ENDIF}

  Plot, Plotdefs, Plotactionlist, Plotmenu, Plotpopupmenu, Plotimagelist, Data, Plottoolbar, Nedit, Misc;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    ClearAllBitBtn: TBitBtn;
    TraceBitBtn: TBitBtn;
    TypeBitBtn: TBitBtn;
    StatusBar1: TStatusBar;
    PlotTypeComboBox: TComboBox;
    SeriesTypeComboBox: TComboBox;
    procedure ClearAllBitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlotMenu1ExitMenuItemClick(Sender: TObject);
    procedure MyPlotFileOpen(Sender: TObject; TheFile: String);
    procedure TraceBitBtnClick(Sender: TObject);
    procedure TypeBitBtnClick(Sender: TObject);
    procedure MyPlotBeforeDraw(Sender: TObject; ACanvas: TCanvas);
    procedure PlotTypeComboBoxClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    MyPlot: TPlot;
    MyPlotActionList: TPlotActionList;
    MyPlotMenu: TPlotMenu;
    MyPlotPopupMenu: TPlotPopupMenu;
    MyPlotImageList: TPlotImageList;
    MyPlotToolBar: TPlotToolBar;
    TypeClicked: Boolean;
  public
    procedure DisplayHint(Sender: TObject);
    procedure DoXY;
    procedure SetPlotType(ThePlotType, TheSeriesType: Integer);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}
{$R Penguin.res}

{Kylix seems to have a versioninfo resource already.
 Unfortunately, it is empty.}
{.$ R version.res}

const
  RADIUS = 50.0;
{$IFDEF WIN32}
  MYCAPTION = 'TPlot demo for Delphi';
{$ENDIF}
{$IFDEF LINUX}
  MYCAPTION = 'TPlot demo for Kylix';
{$ENDIF}

procedure TMainForm.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  TypeClicked := FALSE;

  Width := 750;
  Height := 500;

  MyPlot := TPlot.Create(Self);
  MyPlot.Parent := Self;
  MyPlot.Align := alClient;
  MyPlot.PlotType := ptXY;
  MyPlot.NoSeries := 2;
  MyPlot.MakeDummyData(32);
  MyPlot.SaveOptions := [soProperties]; // soAsText

  MyPlotImageList := TPlotImageList.Create(Self);

  MyPlotActionList := TPlotActionList.Create(Self);
  MyPlotActionList.Images := MyPlotImageList;
  MyPlotActionList.Plot := MyPlot;

  MyPlotMenu := TPlotMenu.Create(Self);
  MyPlotMenu.Images := MyPlotImageList;
  MyPlotMenu.PlotActionList := MyPlotActionList;

  MyPlotPopupMenu := TPlotPopupMenu.Create(Self);
  MyPlotPopupMenu.Images := MyPlotImageList;
  MyPlotPopupMenu.PlotActionList := MyPlotActionList;
  MyPlot.PopupMenu := MyPlotPopupMenu;

  MyPlotToolBar := TPlotToolBar.Create(Self);
  MyPlotToolBar.Parent := Self;
  MyPlotToolBar.Images := MyPlotImageList;
  MyPlotToolBar.PlotActionList := MyPlotActionList;

  MyPlot.OnFileOpen := MyPlotFileOpen;
  MyPlot.OnBeforeDraw := MyPlotBeforeDraw;
  MyPlot.Instructions := 'Click on the "Type" button to see different Plot Types.';

  Self.Caption := MYCAPTION;

  for i := 0 to Ord(High(TPlotType)) do
    PlotTypeComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPlotType), i), 3, 99));
  PlotTypeComboBox.ItemIndex := 0;
  for i := 0 to Ord(High(TSeriesType)) do
    SeriesTypeComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TSeriesType), i), 3, 99));
  SeriesTypeComboBox.Items.Add('All four types');
  SeriesTypeComboBox.ItemIndex := 0;

  Application.OnHint := DisplayHint;
end;

procedure TMainForm.DisplayHint(Sender: TObject);
begin
  StatusBar1.SimpleText := GetLongHint(Application.Hint);
end;

procedure TMainForm.ClearAllBitBtnClick(Sender: TObject);
begin
  MyPlot.Clear(FALSE);
end;

procedure TMainForm.PlotMenu1ExitMenuItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.MyPlotFileOpen(Sender: TObject; TheFile: String);
var
  TheTitle: String;
begin
  TheTitle := ExtractFileName(Application.ExeName);
  TheTitle := Copy(TheTitle, 1, Length(TheTitle)-4);
  TheTitle := TheTitle + ' - ' + ExtractFileName(TheFile);
  Application.Title := TheTitle;
  MainForm.Caption := TheTitle;
end;

procedure TMainForm.TraceBitBtnClick(Sender: TObject);
begin
  MyPlot.Trace;
end;

procedure TMainForm.DoXY;
begin
  MyPlot.InstructionS := 'Please wait while I add some symbols ...';
  Wait(1000, TRUE);
  MyPlot.Series[0].Symbol := sySquare;
  Wait(1000, TRUE);
  MyPlot.Series[1].Symbol := syCircle;
  MyPlot.Instructions := 'Done !';
end;

procedure TMainForm.PlotTypeComboBoxClick(Sender: TObject);
begin
  SetPlotType(PlotTypeComboBox.ItemIndex, SeriesTypeComboBox.ItemIndex);
end;

procedure TMainForm.TypeBitBtnClick(Sender: TObject);
begin
  TypeBitBtn.Enabled := FALSE;
  if (not TypeClicked) then
  begin
    DoXY;
    TypeClicked := TRUE;
    TypeBitBtn.Enabled := TRUE;
    exit;
  end;
  if (PlotTypeComboBox.ItemIndex = Ord(pt3DColumn)) then
    SetPlotType(0, 0)
  else if ((PlotTypeComboBox.ItemIndex = 0) and (SeriesTypeComboBox.ItemIndex <= Ord(stMultiple))) then
    SetPlotType(PlotTypeComboBox.ItemIndex, SeriesTypeComboBox.ItemIndex+1)
   else
    SetPlotType(PlotTypeComboBox.ItemIndex+1, 0);
  TypeBitBtn.Enabled := TRUE;  
end;

procedure TMainForm.SetPlotType(ThePlotType, TheSeriesType: Integer);
var
  i, TheHeight, TheTop, TheBottom: Integer;
  TheXStringData: TStringList;

const
  DELAY = 1000;

begin
  PlotTypeComboBox.Enabled := FALSE;
  SeriesTypeComboBox.Enabled := FALSE;
  PlotTypeComboBox.ItemIndex := ThePlotType;
  if (PlotTypeComboBox.ItemIndex = Ord(ptXY)) then
    SeriesTypeComboBox.ItemIndex := TheSeriesType
   else
    SeriesTypeComboBox.ItemIndex := 0;
{Initialise properties that can change:}
  MyPlot.Series.ClearSeries;
  MyPlot.YAxis.LimitsVisible := FALSE;
  MyPlot.Contour.Interval := 1;
  MyPlot.Contour.Detail := cdLow;
  MyPlot.Contour.WireFrame := FALSE;
  MyPlot.YAxis.AutoScale := TRUE;
  MyPlot.YAxis.AutoZero := TRUE;
  MyPlot.Legend.Direction := drHorizontal;
  MyPlot.Grids.WallType := gtNone;
  MyPlot.ColorType := gtNone;
  MyPlot.Color2 := MyPlot.Color;
  MyPlot.ColorPlot := clWindow;

  MyPlot.PlotType := TPlotType(ThePlotType);

  MyPlot.Title.Caption := 'TPlot - ' + #10 +
    MyPlot.GetPlotTypeAsString;
  case MyPlot.PlotType of
    ptXY:
      case TheSeriesType of
        Ord(stNormal):
          begin
            MyPlot.NoSeries := 2;
            MyPlot.MakeDummyData(32);
            DoXY;
          end;
        Ord(stComplex):
          begin
            MyPlot.NoSeries := 1;
            MyPlot.Series[0].SeriesType := stComplex;
            MyPlot.MakeDummyData(128);
            MyPlot.Title.Caption := MyPlot.Title.Caption + ' - Complex';
          end;
        Ord(stBubble):
          begin
            MyPlot.NoSeries := 1;
            MyPlot.Series[0].SeriesType := stBubble;
            MyPlot.MakeDummyData(16);
            MyPlot.Title.Caption := MyPlot.Title.Caption + ' - Bubble';
            MyPlot.Instructions := 'Done !';
          end;
        Ord(stError):
          begin
            MyPlot.NoSeries := 1;
            MyPlot.Series[0].SeriesType := stError;
            MyPlot.MakeDummyData(32);
            MyPlot.Title.Caption := MyPlot.Title.Caption + ' - Error';
            MyPlot.Instructions := 'Please wait while I add some Checks ...';
            Misc.Wait(DELAY, TRUE);
            MyPlot.Series[0].SymbolCheck := TRUE;
            MyPlot.Instructions := 'Done !';
          end;
        Ord(stMultiple):
          begin
            MyPlot.NoSeries := 1;
            MyPlot.Series[0].SeriesType := stMultiple;
            MyPlot.MakeDummyData(32);
            MyPlot.Title.Caption := MyPlot.Title.Caption + ' - Multiple';
            MyPlot.Instructions := 'Please wait while I increase the Multiplicity ...';
            Misc.Wait(DELAY, TRUE);
            MyPlot.Series[0].DelData;
            MyPlot.Series[0].Multiplicity := 2;
            MyPlot.MakeDummyData(32);
            MyPlot.Instructions := ' ... to Multiplicity = 2 ...';
            Misc.Wait(DELAY, TRUE);
            MyPlot.Series[0].DelData;
            MyPlot.Series[0].Multiplicity := 3;
            MyPlot.MakeDummyData(32);
            MyPlot.Instructions := ' ... to Multiplicity = 3 ...';
            Misc.Wait(DELAY, TRUE);
            MyPlot.Series[0].DelData;
            MyPlot.Series[0].Multiplicity := 4;
            MyPlot.MakeDummyData(32);
            MyPlot.Instructions := ' ... to Multiplicity = 4 ... Done !';
          end;
      else
        MyPlot.NoSeries := 4;
        for i := 0 to 3 do
        begin
          MyPlot.Series[i].SeriesType := TSeriesType(i+1);
          MyPlot.Series[i].Name := Copy(GetEnumName(TypeInfo(TSeriesType), i+1), 3, 99);
        end;
        MyPlot.Series[3].Multiplicity := 4;
        MyPlot.MakeDummyData(32);
        MyPlot.Title.Caption := MyPlot.Title.Caption + ' - Four SeriesTypes at Once !';
        MyPlot.Legend.Direction := drVertical;
      end; {case SeriesType}

    ptColumn, ptStack, ptNormStack:
      begin
        MyPlot.Grids.GridType := gtNone;
        MyPlot.MakeDummyData(16);
        MyPlot.Instructions := 'This is boring !';
      end;
    ptPie:
      begin
        MyPlot.MakeDummyData(11);
        TheXStringData := TStringList.Create;
        TheXStringData.Add('Alpha');
        TheXStringData.Add('Bravo');
        TheXStringData.Add('Charlie');
        TheXStringData.Add('Delta');
        TheXStringData.Add('Echo');
        TheXStringData.Add('Foxtrot');
        TheXStringData.Add('Golf');
        TheXStringData.Add('Hotel');
        TheXStringData.Add('India');
        TheXStringData.Add('Juliet');
        TheXStringData.Add('Kilo');
        MyPlot.Series[0].XStringData := TheXStringData;
{Note: to set the XStringData of the second series is a sin: because it's X Data is in the zeroth series.}
        //MyPlot.Series[1].XStringData := TheXStringData;
        TheXStringData.Free;
        MyPlot.Instructions := 'Please wait while I show the 3D sides ...';
        Misc.Wait(DELAY, TRUE);
        TheHeight := Height;
        TheTop := MyPlot.Border.Top;
        TheBottom := MyPlot.Border.Bottom;
        for i := TheHeight downto 2*TheHeight div 3 do
        begin
          Height := Height - 1;
          Application.Processmessages;
        end;
        Misc.Wait(5000, TRUE);
        Height := TheHeight;
{NB: The Border gets scaled when the Height is changed, so we unscale it:}
        {MyPlot.Border.Top := TheTop;
        MyPlot.Border.Bottom := TheBottom;}
        MyPlot.Instructions := 'Done !';
      end;
    ptPolar:
      begin
        MyPlot.XAxis.Min := -10;
        MyPlot.XAxis.Max := 10;
        MyPlot.YAxis.Min := -10;
        MyPlot.YAxis.Max := 10;
        MyPlot.MakeDummyData(32);
        MyPlot.XAxis.Intercept := 0;
        MyPlot.YAxis.Intercept := 0;
        MyPlot.Instructions := 'This is extremely boring !';
      end;
    ptLineContour, ptContour, pt3DContour, pt3DWire, pt3DColumn:
      begin
        MyPlot.XAxis.Min := 0;
        MyPlot.XAxis.Max := 10;
        MyPlot.YAxis.Min := 0;
        MyPlot.YAxis.Max := 10;
        MyPlot.NoSeries := 10;
        MyPlot.MakeDummyData(32);
      end;
  else ;
  end;

  case MyPlot.PlotType of
    ptColumn:
      begin
        MyPlot.Instructions := 'Please wait while I make Series[1] a line ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Series[1].IsLine := TRUE;
        MyPlot.Series[1].Symbol := syCircle;
        MyPlot.Instructions := 'Done !';
      end;
    ptLineContour:
      begin
        MyPlot.Instructions := 'Please wait while I increase the ContourDetail ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.Detail := cdMedium;
        MyPlot.Contour.Interval := MyPlot.Contour.Interval / 2;
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.Detail := cdHigh;
        MyPlot.Instructions := 'Done !';
      end;
    ptContour:
      begin
        MyPlot.Instructions := 'Please wait while I increase the ContourDetail ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.Detail := cdMedium;
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.Detail := cdHigh;
        MyPlot.Instructions := 'Done !';
      end;
    pt3DContour:
      begin
        MyPlot.Instructions := 'Please wait while I increase the ContourDetail ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.Detail := cdMedium;
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.Detail := cdHigh;
        Misc.Wait(DELAY, TRUE);
        MyPlot.Instructions := '... add a wireframe ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Contour.WireFrame := TRUE;
        MyPlot.Instructions := '... add some walls and grids ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Grids.GridType := gtBoth;
        MyPlot.Instructions := '... move the axes to render them more visible ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.XAxis.Intercept := MyPlot.YAxis.Max;
        MyPlot.YAxis.Intercept := MyPlot.XAxis.Max;
        MyPlot.ZAxis.ZInterceptY := MyPlot.YAxis.Max;
        MyPlot.Instructions := 'Done !';
      end;
    pt3DWire, pt3DColumn:
      begin
        MyPlot.Instructions := 'Please wait while I move the axes to render them more visible ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.XAxis.Intercept := MyPlot.YAxis.Max;
        MyPlot.YAxis.Intercept := MyPlot.XAxis.Max;
        MyPlot.ZAxis.ZInterceptY := MyPlot.YAxis.Max;
        MyPlot.Instructions := '... add some grids ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Grids.GridType := gtBoth;
        MyPlot.Grids.WallColor2 := MyPlot.Grids.WallColor;
        MyPlot.Instructions := '... add some walls ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Grids.WallType := gtHorizontal;
        MyPlot.Instructions := '... make them pretty ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.Grids.WallColor2 := clAqua;
        MyPlot.Instructions := '... make the background pretty ...';
        Misc.Wait(DELAY, TRUE);
        MyPlot.ColorType := gtVertical;
        MyPlot.Color2 := clSilver; //212 + (198 shr 8) + (244 shr 16);
        MyPlot.Instructions := 'Done !';
      end;
  end;
  PlotTypeComboBox.Tag := PlotTypeComboBox.ItemIndex;
  SeriesTypeComboBox.Tag := SeriesTypeComboBox.ItemIndex;
  PlotTypeComboBox.Enabled := TRUE;
  SeriesTypeComboBox.Enabled := TRUE;
end;

procedure TMainForm.MyPlotBeforeDraw(Sender: TObject; ACanvas: TCanvas);
var
  ABitmap: TBitmap;
  ARect: TRect;
begin
  if (MyPlot.PlotType = ptLineContour) then
  begin
    ABitmap := TBitmap.Create;
    ABitmap.LoadFromResourceName(hInstance, 'PENGUIN');
    ARect.Left := MyPlot.Border.Left;
    ARect.Top := MyPlot.Border.Top;
    ARect.Right := MyPlot.Border.Right;
    ARect.Bottom := MyPlot.Border.Bottom;
    ACanvas.StretchDraw(ARect, ABitmap);
    ABitmap.Free;
  end;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  MyPlot.ProcessKeyDown(Key, Shift);
end;


end.
