program Install;

{$APPTYPE CONSOLE}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Install.dpr, released 12 December 2002.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 12/15/2002
Current Version: 1.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
To provide an easy to use build-then-install app for TPlot (and other complex components),
that works over all versions of Delphi. Then (hopefully) BC++ Builder and Kylix.


Known Issues:
This is highly experimental - caveat emptor !

History:
 1.00 15 Dec 2002:
-----------------------------------------------------------------------------}


uses
  Classes, Registry, ShellApi, Windows, SysUtils,
  uDelphiPackage;

var
  i, j: Integer;
  Success: Longword;
  BorStr, Cmd, Package, Param, SourceRoot, Target: String;
  Delphis, Parameters: TStringList;
  Reg: TRegistry;

begin
{Parameters for Misc, TPlot:
  C:\Users\matb\Delphi\Components Misc\%s%d\Misc300_Run.dpk Misc\%s%d\Misc300_Design.dpk TPlot\%s%d\Plot300_Run.dpk TPlot\%s%d\Plot300_Design.dpk TPlot\%s%d\DBPlot300_Run.dpk TPlot\%s%d\DBPlot300_Design.dpk  }

  if (ParamCount < 2) then
  begin
    Writeln('Usage: Install SourceRootDir Package1[%s][%d].bpl [Package2.bpl ...]');
    Writeln('       %s = D for Delphi, K for Kylix, BCB for BC++ Builder');
    Writeln('       %d = Delphi, Kylix, BCB Version');
    Writeln('The Package paths are relative to the SourceRootDir');
    Writeln('Example:');
    Writeln('Install C:\Users\matb\Delphi\Components Misc\%s%d\Misc300_Run.dpk');
    Exit;
  end;

  SourceRoot := Paramstr(1);
  if (SourceRoot[Length(SourceRoot)] <> '\') then
    SourceRoot := SourceRoot + '\';

  Delphis := TStringList.Create;
  Parameters := TStringList.Create;
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_LOCAL_MACHINE;

  for i := 2 to ParamCount do
  begin
    BorStr := Paramstr(i);
    if (Length(BorStr) > 0) then
      Parameters.Add(BorStr);
  end;

{Close all Delphis:}
  for i := 1 to 9 do
  begin
    uDelphiPackage.ShutDownDelphi(i, TRUE);
  end;

  try
    for i := 0 to 9 do
    begin
      BorStr := Format('SOFTWARE\Borland\Delphi\%d.0', [i]);
{open registry key in no create mode:}
      if (Reg.OpenKey(BorStr, FALSE)) then
      begin
{get the home directory:}
        BorStr := Reg.ReadString('RootDir');
        if (BorStr[Length(BorStr)] <> '\') then
          BorStr := BorStr + '\';
        if (length(BorStr) > 0) then
        begin
          Delphis.Add(BorStr);
          CreateDir(BorStr + 'Projects\Bpl');
          CreateDir(BorStr + 'Projects\dcu');
        end
         else
          Delphis.Add('');
        Reg.CloseKey;
      end
       else
        Delphis.Add('');
    end;

    if (Reg.OpenKey('SOFTWARE\Borland\Borland Shared', FALSE)) then
    begin
{get the home page:}
      BorStr := Reg.ReadString('SharedFilesDir');
      Reg.CloseKey;
    end;
  finally
    Reg.Free;
  end;

  for i := 0 to Delphis.Count-1 do
  begin
    Cmd := Delphis.Strings[i] + 'Bin\dcc32.exe';
    if (Length(Cmd) > 0) then
    begin
      WriteLn(Format('Building Packages for Delphi %d', [i]);
      for j := 0 to Parameters.Count-1 do
      begin
        Package := SourceRoot + Format(Parameters[j], ['D', i]);
        SetCurrentDir(ExtractFilePath(Package));
        Param := ExtractFileName(Package);
      end;
    end; {Cmd > 0}
  end;

  Writeln('Press Enter to continue ...');
  Read(Param);
  Delphis.Free;
  Parameters.Free;
end.