unit SimpleDemo1;

interface

uses
  Classes, SysUtils,
{$IFDEF WIN32}
  Windows, Messages, Menus, Graphics, Controls, Forms, Dialogs, ComCtrls,
  ExtCtrls, StdCtrls, ActnList, ToolWin, ImgList,
{$ENDIF}
{$IFDEF LINUX}
  Types, QGraphics, QControls, QForms, QDialogs, QComCtrls,
  QExtCtrls, QStdCtrls, QActnList, QImgList, QMenus, QTypes,
{$ENDIF}

  Plot, Plotdefs, Plotimagelist, Plottoolbar, Plotmenu, Plotactionlist,
  Plotpopupmenu;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Plot1: TPlot;
    PlotActionList1: TPlotActionList;
    PlotMenu1: TPlotMenu;
    PlotPopupMenu1: TPlotPopupMenu;
    PlotImageList1: TPlotImageList;
    PlotToolBar1: TPlotToolBar;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private

  public
    procedure DisplayHint(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Width := 750;
  Height := 500;
  Plot1.Align := alClient;
  Plot1.MakeDummyData(32);
  Application.OnHint := DisplayHint;
end;

procedure TForm1.DisplayHint(Sender: TObject);
begin
  StatusBar1.SimpleText := GetLongHint(Application.Hint);
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Plot1.ProcessKeyDown(Key, Shift);           
end;

end.
