program plotcgi;

{$APPTYPE CONSOLE}

{.$ DEFINE DEBUG}

{Apache httpd.conf:
  Listen 8080

  ServerAdmin mat.ballard@csiro.au

  DocumentRoot "C:\Users\matb\Delphi\Components\TPlot\Apps\Demo\data"

  AddDescription "Plot file" .plot
  AddDescription "Plot properties file" .props

  AddType application/x-plot .plot
  Action plothandler .plot
  AddHandler cgi-script .cgi
  AddHandler plothandler .plot

  }

uses
  Classes, SysUtils, Windows,

  DrBobCGI,

  Misc;

type
  TProps = record
    Width, Height: Integer;
    Left, Top, Right, Bottom: Single;
  end;

resourcestring
  sPlotPage1 = '<html><head>' + #13#10 +
    '<title>%s</title></head>' + #13#10 +                 // /data/plot1
    '<body bgcolor="white">' + #13#10 +
    '<form method="post" action="%s">' + #13#10 +         // /data/plot1.plot
    '<h3 align="center">%s</h3>' + #13#10 +               // /data/plot1
    '<div align="center"><img src="/cgi-bin/plotpng.exe%s"></div>' + #13#10;  // /data/plot1.png

  sPlotPage2 = '<table width="100%s"><tbody><tr>' + #13#10 +
    '    <td><input type="submit" name="ZOOMIN" value="Zoom To ..." title="Zoom in closer">' + #13#10 +
    '        Left, Top: ( <input type="text" name="LEFT" value="%g" size="6" maxlength="4" title="Left"> , ' + #13#10 +
    '            <input type="text" name="TOP" value="%g" size="6" maxlength="4" title="Top"> );       ' + #13#10 +
    '        Right, Bottom: ( <input type="text" name="RIGHT" value="%g" size="6" maxlength="4" title="Right"> , ' + #13#10 +
    '            <input type="text" name="BOTTOM" value="%g" size="6" maxlength="4" title="Bottom"> )</td>' + #13#10 +
    '    <td><input type="submit" name="ZOOMOUT" value="Zoom Out" title="Zoom Out"></td></tr></tbody></table>' + #13#10 +
    '<p><table width="100%s"><tbody><tr>' + #13#10 +
    '    <td>Change the image ... </td>' + #13#10 +
    '    <td>Width:&nbsp; <input type="text" name="WIDTH" value="%d" size="6" maxlength="4"><br>' + #13#10 +
    '        Height: <input type="text" name="HEIGHT" value="%d" size="6" maxlength="4"></td>' + #13#10 +
    '    <td><input type="submit" name="CHANGE_VALUES" value="Change Values"></td>' + #13#10 +
    '    <td><input type="submit" name="PROPERTIES" value="More Properties ..." title="Change any property"></td>' + #13#10 +
    '</tr></tbody></table>' + #13#10;

  sPlotPage3 = '</p><p><table width="100%s">' + #13#10 +
    '<tbody><tr>' + #13#10 +
    '    <td>Get the actual data as ... </td>' + #13#10 +
    '    <td><input type="submit" name="TXT" value="Tab text" title="Tab-Separated Variable"></td>' + #13#10 +
    '    <td><input type="submit" name="HTML" value="HTML" title="A Web Page"></td>' + #13#10 +
    '    <td><input type="submit" name="CSV" value="CSV" title="Comma-Separated Variable"></td>' + #13#10 +
    '    <td><input type="submit" name="PLOT" value="Plot" title="Native Plot File"></td>' + #13#10 +
    '</tr>' + #13#10 +
    '</tbody></table>' + #13#10 +
    '</p><p><a href="%s"><i>Back to directory listing</i></a>' + #13#10 +
    '</p></form></body></html>';

var
  i: Integer;
  IsBinary: Boolean;
  j, OldPos: Integer;
  Properties: TStringList;
  BackPath, PropStr: String;
  AStream: TMemoryStream;
  Props: TProps;

  function LookForInText(AStr: String): String;
  begin
    OldPos := j;
    j := Misc.ForwardPos(AStr, PropStr, i);
    if (j > 0) then
    begin
      Result := Copy(PropStr, i, j-i+1);
    end
    else
    begin
      j := OldPos;
      Result := '0';
    end;
  end;

begin
  writeln('content-type: text/html');
  PropStr := ChangeFileExt(DrBobCGI.PathTranslated, '.props');
  if (FileExists(PropStr)) then
  begin
    writeln('status-code: 200');
    writeln;
    AStream := TMemoryStream.Create;
    AStream.LoadFromFile(PropStr);
    Properties := TStringList.Create;
    Properties.LoadFromStream(AStream);
    IsBinary := FALSE;

{inspect first line for binary values:}
    for i := 1 to Length(Properties.Strings[0]) do
    begin
      if (Properties.Strings[0][i] < #30) then
      begin
        IsBinary := TRUE;
        break;
      end;
    end;

    if (IsBinary) then
    begin
      AStream.Seek(0, soFromBeginning);
      Props.Width := GetIntegerProperty('Width', AStream);
      Props.Height := GetIntegerProperty('Height', AStream);
      Props.Left := GetExtendedProperty('XAxis.Min', AStream);
      Props.Right := GetExtendedProperty('XAxis.Max', AStream);
      Props.Bottom := GetExtendedProperty('YAxis.Min', AStream);
      Props.Top := GetExtendedProperty('YAxis.Max', AStream);
    end
    else
    begin
      j := 1;
      PropStr := Properties.Text;
      Props.Width := StrToInt(LookForInText('Width'));
      Props.Height := StrToInt(LookForInText('Height'));
      Props.Left := StrToFloat(LookForInText('XAxis.Min'));
      Props.Right := StrToFloat(LookForInText('XAxis.Max'));
      Props.Bottom := StrToFloat(LookForInText('YAxis.Min'));
      Props.Top := StrToFloat(LookForInText('YAxis.Max'));
    end;

    writeln(Format(sPlotPage1,
        [DrBobCGI.PathInfo,
         DrBobCGI.PathInfo,
         DrBobCGI.PathInfo,
         DrBobCGI.PathInfo]));
    writeln(Format(sPlotPage2,
        ['%', Props.Left, Props.Top, Props.Right, Props.Bottom, '%',
          Props.Width, Props.Height]));
    BackPath := DrBobCGI.PathInfo;
    while (BackPath[Length(BackPath)] <> '/') do
      SetLength(BackPath, Length(BackPath)-1);
    if (Length(BackPath) = 0) then
      BackPath := '/';
    writeln(Format(sPlotPage3, ['%', BackPath]));
    Properties.Free;
    AStream.Free;
  end
  else
  begin
    writeln('status-code: 404');
    writeln;
  end;
end.