unit plotcgi99;

{$DEFINE DEBUG}

interface

uses
  Windows, Messages, SysUtils, Classes, HTTPApp,

  Misc;

type
  TProps = record
    Width, Height: Integer;
    Left, Top, Right, Bottom: Single;
  end;

  TPlotWebModule = class(TWebModule)
    procedure WebModule1HeadWebActionItemAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1GetWebActionItemAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    Props: TProps;
  end;

var
  PlotWebModule: TPlotWebModule;

implementation

{$R *.dfm}

procedure TPlotWebModule.WebModule1HeadWebActionItemAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  if (FileExists(Request.PathTranslated)) then
    Response.StatusCode := 200
   else
    Response.StatusCode := 404;
  Handled := TRUE;
{$IFDEF DEBUG}
  MessageBox(0, 'Got the head request !', 'Head', MB_OK);
{$ENDIF}  
end;

procedure TPlotWebModule.WebModule1GetWebActionItemAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: Integer;
  IsBinary: Boolean;
  j, OldPos: Integer;
  Properties: TStringList;
  PropStr: String;
  AStream: TMemoryStream;

  function LookForInText(AStr, AStr2: String): String;
  begin
    OldPos := j;
    j := Misc.ForwardPos(AStr2, PropStr, i);
    if (j > 0) then
    begin
      Result := Copy(PropStr, i, j-i+1);
    end
    else
    begin
      j := OldPos;
      Result := '0';
    end;
  end;

  resourcestring
    sPlotpage1 = '<html><head>' + #13#10 +
    '<title>%s</title></head>' + #13#10 +                 // /data/plot1
    '<body bgcolor="white">' + #13#10 +
    '<form method="post" action="%s">' + #13#10 +         // /data/plot1.plot
    '<h3 align="center">%s</h3>' + #13#10 +               // /data/plot1
    '<div align="center"><img src="%s"></div>' + #13#10;  // /data/plot1.png

    sPlotpage2 = '<table width="100%s"><tbody><tr>' + #13#10 +
    '    <td><input type="submit" name="ZOOMIN" value="Zoom To ..." title="Zoom in closer">' + #13#10 +
    '        Left, Top: ( <input type="text" name="LEFT" value="%g" size="6" maxlength="4" title="Left"> , ' + #13#10 +
    '            <input type="text" name="TOP" value="%g" size="6" maxlength="4" title="Top"> );       ' + #13#10 +
    '        Right, Bottom: ( <input type="text" name="RIGHT" value="%g" size="6" maxlength="4" title="Right"> , ' + #13#10 +
    '            <input type="text" name="BOTTOM" value="%g" size="6" maxlength="4" title="Bottom"> )</td>' + #13#10 +
    '    <td><input type="submit" name="ZOOMOUT" value="Zoom Out" title="Zoom Out"></td></tr></tbody></table>' + #13#10 +
    '<p><table width="100%s"><tbody><tr>' + #13#10 +
    '    <td>Change the image ... </td>' + #13#10 +
    '    <td>Width:&nbsp; <input type="text" name="WIDTH" value="%d" size="6" maxlength="4"><br>' + #13#10 +
    '        Height: <input type="text" name="HEIGHT" value="%d" size="6" maxlength="4"></td>' + #13#10 +
    '    <td><input type="submit" name="CHANGE_VALUES" value="Change Values"></td>' + #13#10 +
    '    <td><input type="submit" name="PROPERTIES" value="More Properties ..." title="Change any property"></td>' + #13#10 +
    '</tr></tbody></table>' + #13#10;

    sPlotpage3 = '</p><p><table width="100%s">' + #13#10 +
    '<tbody><tr>' + #13#10 +
    '    <td>Get the actual data as ... </td>' + #13#10 +
    '    <td><input type="submit" name="TXT" value="Tab text" title="Tab-Separated Variable"></td>' + #13#10 +
    '    <td><input type="submit" name="HTML" value="HTML" title="A Web Page"></td>' + #13#10 +
    '    <td><input type="submit" name="CSV" value="CSV" title="Comma-Separated Variable"></td>' + #13#10 +
    '    <td><input type="submit" name="PLOT" value="Plot" title="Native Plot File"></td>' + #13#10 +
    '</tr>' + #13#10 +
    '</tbody></table>' + #13#10 +
    '</p><p><a href="%s"><i>Back to directory listing</i></a>' + #13#10 +
    '</p></form></body></html>';

begin
  AStream := TMemoryStream.Create;
  AStream.LoadFromFile(Request.PathTranslated);
  Properties := TStringList.Create;
{$IFDEF DEBUG}
  Properties.Text := Request.Content;
  Properties.SaveToFile('c:\temp\plotcgi.txt');
{$ENDIF}
  Properties.Clear;
  Properties.LoadFromStream(AStream);
  IsBinary := FALSE;

{inspect first line for binary values:}
  for i := 1 to Length(Properties.Strings[0]) do
  begin
    if (Properties.Strings[0][i] < #30) then
    begin
      IsBinary := TRUE;
      break;
    end;
  end;

  if (IsBinary) then
  begin
    AStream.Seek(0, soFromBeginning);
    Props.Width := GetIntegerProperty('Width', AStream);
    Props.Height := GetIntegerProperty('Height', AStream);
    Props.Left := GetExtendedProperty('XAxis.Min', AStream);
    Props.Right := GetExtendedProperty('XAxis.Max', AStream);
    Props.Bottom := GetExtendedProperty('YAxis.Min', AStream);
    Props.Top := GetExtendedProperty('YAxis.Max', AStream);
  end
  else
  begin
    j := 1;
    PropStr := Properties.Text;
    Props.Width := StrToInt(LookForInText('Width', 'Height'));
    Props.Height := StrToInt(LookForInText('Height', 'Border'));
    Props.Left := StrToFloat(LookForInText('XAxis.Min', 'XAxis'));
    Props.Right := StrToFloat(LookForInText('XAxis.Max', 'XAxis'));
    Props.Bottom := StrToFloat(LookForInText('YAxis.Min', 'YAxis'));
    Props.Top := StrToFloat(LookForInText('YAxis.Max', 'YAxis'));
  end;

  Response.Content :=
    Format(sPlotpage1,
      [ExtractFileRoot(Request.PathInfo),
       Request.PathInfo,
       ExtractFileRoot(Request.PathInfo),
       ChangeFileExt(Request.PathTranslated, '.png')]) +
    Format(sPlotpage2,
      ['%', Props.Left, Props.Top, Props.Right, Props.Bottom, '%']) +
    Format(sPlotpage3, ['%', ExtractFilePath(Request.PathInfo)]);

{$IFDEF DEBUG}
  Properties.Text := Response.Content;
  Properties.SaveToFile('c:\temp\plotcgi.htm');
{$ENDIF}
  Properties.Free;
  AStream.Free;
  Handled := TRUE;
end;

procedure TPlotWebModule.WebModuleCreate(Sender: TObject);
begin
  MessageBox(0, 'Webmodule created', 'Start', MB_OK);
end;

end.
