program plotpng;
{$APPTYPE CONSOLE}
uses
  Classes, SysUtils, Windows,
  Dialogs,
  DrBobCGI,

  Misc, Plot;

var
  APlot: TPlot;
  PlotFile, QString: String;
  MemoryStream: TMemoryStream;

  procedure SendStream(AStream: TStream);
  var
    Buffer: array[0..8191] of Byte;
    BytesToSend: Integer;
  begin
    while AStream.Position < AStream.Size do
    begin
      BytesToSend := AStream.Read(Buffer, SizeOf(Buffer));
      //FHTTPRequest.WriteClient(Buffer, BytesToSend);
      FileWrite(TTextRec(Output).Handle, Buffer, BytesToSend)
    end;
  end;

begin
  writeln('content-type: image/png');
  //QString := DrBobCGI.Data;
  //ShowMessage(DrBobCGI.PathTranslated + #13#10 + DrBobCGI.PathInfo);
  if (FileExists(DrBobCGI.PathTranslated)) then
  begin
    writeln('status-code: 200');
    writeln;
    APlot := TPlot.Create(nil);
    try
      MemoryStream := TMemoryStream.Create;
      APlot.LoadFromFile(DrBobCGI.PathTranslated);
    finally
      APlot.Png.SaveToStream(MemoryStream);
      MemoryStream.Seek(0, soFromBeginning);
      try
        SendStream(MemoryStream);
      finally
        ShowMessageFmt('Sent %d bytes', [MemoryStream.Size]);
        MemoryStream.Free;
        APlot.Free;
      end;
    end;
  end
  else
  begin
    writeln('status-code: 404');
    writeln;
  end;
end.
