unit DBPlot_reg;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: DBPlot_reg.pas, released 12 March 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/02/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
Registration unit for the TDBPlot component.


Known Issues:
-----------------------------------------------------------------------------}

{$I Plot.inc}

interface

uses
  Classes,
{Borland removed the source to property editors and other IDE goodies in Kylix and D6 up:}  
{$IFDEF COMPILER6_UP}
  DesignEditors, DesignIntf,
{NB: the property editors need DesignEditors and DesignIntf,
 and to avoid rude messages about "DesignConst" (which does not exist),
 you have to add "designide.dcp" to the requires section of this package.}
{$ELSE}
  DsgnIntf,
{$ENDIF}
  DBPlot, Plot,

{$IFDEF COMPILER35_UP}
  Plottoolbar,
  Plotimagelist,
{$ENDIF}
  Plotmenu;

type
  TDBPlotComponentEditor = class(TComponentEditor)
  public
    function GetVerb(Index: Integer): String; override;
    function GetVerbCount: Integer; override;
    procedure ExecuteVerb(Index: Integer); override;
    procedure Edit; override;
  end;

procedure Register;

implementation

{$IFDEF WINDOWS}
{$R DBPlot16.dcr}
{$ENDIF}
{$IFDEF WIN32}
{$R DBPlot32.dcr}
{$ENDIF}
{$IFDEF LINUX}
{$R DBPlot32.dcr}
{$ENDIF}

type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TAxesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TDataProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TSeriesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

procedure Register;
begin
  RegisterComponents('Data Controls', [{$IFDEF GUI}TDBPlot{$ELSE}TConsoleDBPlot{$ENDIF}]);

{register the "About" property editor}
  RegisterPropertyEditor(TypeInfo(String), {$IFDEF GUI}TDBPlot{$ELSE}TConsoleDBPlot{$ENDIF}, 'About', TAboutProperty);
{register the "Data" property editor}
  RegisterPropertyEditor(TypeInfo(String), {$IFDEF GUI}TDBPlot{$ELSE}TConsoleDBPlot{$ENDIF}, 'DataProperties', TDataProperty);
{register the "Series" property editor}
  RegisterPropertyEditor(TypeInfo(String), {$IFDEF GUI}TDBPlot{$ELSE}TConsoleDBPlot{$ENDIF}, 'SeriesProperties', TSeriesProperty);
{register the "Axes" property editor}
  RegisterPropertyEditor(TypeInfo(String), {$IFDEF GUI}TDBPlot{$ELSE}TConsoleDBPlot{$ENDIF}, 'AxesProperties', TAxesProperty);
{register the component editor for menus:}
  RegisterComponentEditor({$IFDEF GUI}TDBPlot{$ELSE}TConsoleDBPlot{$ENDIF}, TDBPlotComponentEditor);
  {$IFDEF COMPILER35_UP}
  {RegisterPropertyEditor(TypeInfo(String), TPlotToolBar, 'Arrangement', TToolBarProperty);}
  {$ENDIF}
end;

{TDBPlotComponentEditor methods:-------------------------------------------------}
function TDBPlotComponentEditor.GetVerb(Index: Integer): String;
begin
  case Index of
{$IFDEF GUI}
    0: Result := '&About TDBPlot...';
{$ELSE}
    0: Result := '&About TConsoleDBPlot...';
{$ENDIF}    
    1: Result := 'A&xes...';
    2: Result := '&Copy';
    3: Result := '&Data...';
    4: Result := '&Properties...';
    5: Result := '&Series...';
  end;
end;

function TDBPlotComponentEditor.GetVerbCount: Integer;
begin
  Result := 6;
end;

procedure TDBPlotComponentEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: (Component as TCustomPlot).ShowAbout(Self);
    1: (Component as TCustomPlot).ShowAxes;
    2: (Component as TCustomPlot).CopyClick(nil);
    3: (Component as TCustomPlot).ShowData;
    4: (Component as TCustomPlot).ShowProperties;
    5: (Component as TCustomPlot).ShowSeries;
  end;
end;

procedure TDBPlotComponentEditor.Edit;
begin
  (Component as TCustomPlot).ShowProperties;
end;
{end TDBPlotComponentEditor methods:---------------------------------------------}

{About bits and pieces:------------------------------------------------------}
procedure TAboutProperty.Edit;
{call the "About" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowAbout(Self);
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About...)';
end;

{End About bits and pieces:--------------------------------------------------}

{Data bits and pieces:------------------------------------------------------}
procedure TDataProperty.Edit;
{call the "Data" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowData;
end;

function TDataProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TDataProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Data...)';
end;

{End Data bits and pieces:--------------------------------------------------}

{Series bits and pieces:------------------------------------------------------}
procedure TSeriesProperty.Edit;
{call the "Series" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowSeries;
end;

function TSeriesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TSeriesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Series...)';
end;

{End Series bits and pieces:--------------------------------------------------}

{$IFDEF COMPILER35_UP}
{Toolbar bits and pieces:------------------------------------------------------}
{procedure TToolbarProperty.Edit;
begin
  TPlotToolBar(GetComponent(0)).ShowArrangement;
end;

function TToolbarProperty.GetAttributes: TPropertyAttributes;
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TToolbarProperty.GetValue: String;
begin
  GetValue := '(Arrangement...)';
end;}
{End Toolbar bits and pieces:--------------------------------------------------}
{$ENDIF}

{Axes bits and pieces:------------------------------------------------------}
procedure TAxesProperty.Edit;
{call the "Axes" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowAxes;
end;

function TAxesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAxesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Axes...)';
end;
{End Axes bits and pieces:--------------------------------------------------}

end.
