unit Dataedit;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Dataedit.pas, released 15 March 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/13/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
To facilitate user manipluation of Series Data (ie: the numbers !).

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Clipbrd, Controls, ComCtrls, Forms, Graphics, Grids, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Clipbrd, Controls, ComCtrls, Forms, Graphics, Grids, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  Untranslated,
  QButtons, QClipbrd, QControls, QComCtrls, QExtCtrls, QForms, QGrids, QGraphics, QStdCtrls,
{$ENDIF}
  Misc, Nedit, Plotdefs;

type
  TDataEditorForm = class(TForm)
    DataStringGrid: TStringGrid;
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    ZDataLabel: TLabel;
    AddRowBitBtn: TBitBtn;
    DeleteRowBitBtn: TBitBtn;
    ZDataNEdit: TNEdit;
    CopyBitBtn: TBitBtn;
    ApplyBitBtn: TBitBtn;
    SeriesNameLabel: TLabel;
    NANBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure DataStringGridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure AddRowBitBtnClick(Sender: TObject);
    procedure DeleteRowBitBtnClick(Sender: TObject);
    procedure CopyBitBtnClick(Sender: TObject);
    procedure HelpBitBtnClick(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
    procedure NANBitBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    NumericDataChanged: Boolean;
{Has the X or Y numeric data, or the Z data, changed ?}
    StringDataChanged: Boolean;
{Has the X String data been changed ?}
    RowCountChanged: Boolean;
{Has the number of rows (points) changed ?}
    ExternalXSeries: Boolean;
{Is the X Data maintained in a different series ?
 If it is, then it cannot be changed here.}
    DependentXSeries: Boolean;
    TheSeries: TObject;

    procedure DoHintsFromResource;
  end;

var
  DataEditorForm: TDataEditorForm;

implementation

uses
  Data;

{$R *.dfm}

{------------------------------------------------------------------------------
    Procedure: TDataEditorForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position and Grid row titles
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDataEditorForm.FormCreate(Sender: TObject);
begin
  DoHintsFromResource;
  Left := 10;
  Top := 10;

  Misc.SetDialogGeometry(Self, ApplyBitBtn, SeriesNameLabel.Left);
  AddRowBitBtn.Width := 90;
  DeleteRowBitBtn.Width := 90;
  NANBitBtn.Width := 90;
  CopyBitBtn.Width := 90;

{do the geometry of the grid:}
  DataStringGrid.Cells[0,0] := 'Point';
  DataStringGrid.ColWidths[0] := Canvas.TextWidth('Point') + 6;
  DataStringGrid.Cells[1, 0] := 'X Data';
  DataStringGrid.Cells[2, 0] := 'Y Data';
  DataStringGrid.Cells[3, 0] := 'X Text';

  //ClientHeight := OKBitBtn.Top + 3 * OKBitBtn.Height div 2;

  NumericDataChanged := FALSE;
  StringDataChanged := FALSE;
  RowCountChanged := FALSE;
end;

{------------------------------------------------------------------------------
    Procedure: TDataEditorForm.DoHintsFromResource
  Description: standard loading of labels from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display hints in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDataEditorForm.DoHintsFromResource;
begin
  ApplyBitBtn.Hint := 'Apply these properties now !';
  CopyBitBtn.Hint := 'Copy everything to the clipboard';
  AddRowBitBtn.Hint := 'Add a row AFTER the current row';
  DeleteRowBitBtn.Hint := 'Delete the current row';
  ZDataNEdit.Hint := 'only relevant for 3D plots';
  DataStringGrid.Hint := 'Press "F2" to edit, or just overtype, + #10 + and Ctrl-C to copy a single cell.';
end;

procedure TDataEditorForm.FormResize(Sender: TObject);
begin
  OKBitBtn.Top := ClientHeight - 3 * OKBitBtn.Height div 2;
  HelpBitBtn.Top := OKBitBtn.Top;
  CancelBitBtn.Top := OKBitBtn.Top;
  ApplyBitBtn.Top := OKBitBtn.Top;
  DataStringGrid.Width := ApplyBitBtn.Left + ApplyBitBtn.Width - DataStringGrid.Left;
  DataStringGrid.ColWidths[3] := DataStringGrid.Width -
    DataStringGrid.ColWidths[0] -
    DataStringGrid.ColWidths[1] -
    DataStringGrid.ColWidths[2] - 25;
  DataStringGrid.Height := ClientHeight - DataStringGrid.Top - 2*OKBitBtn.Height;
end;

procedure TDataEditorForm.DataStringGridKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (((Key > 31) and (Key < 127)) or (Key = VK_BACK))then
  begin
{ ' ' thru to '~':}
    case DataStringGrid.Col of
      1:
        begin
          if (ExternalXSeries) then
            Key := 0
          else
            NumericDataChanged := TRUE;
        end;
      2: NumericDataChanged := TRUE;
      3: StringDataChanged := TRUE;
    end;
  end;
end;

procedure TDataEditorForm.AddRowBitBtnClick(Sender: TObject);
var
  i: Integer;
begin
  with DataStringGrid do
  begin
    RowCount := RowCount + 1;
    Cells[0, RowCount-1] :=
      IntToStr(RowCount-2);
    for i := RowCount-2 downto Row+1 do
    begin
      Cells[1, i+1] := Cells[1, i];
      Cells[2, i+1] := Cells[2, i];
      Cells[3, i+1] := Cells[3, i];
    end;
    Cells[1, Row+1] := '';
    Cells[2, Row+1] := '';
    Cells[3, Row+1] := '';
    Row := Row + 1;
    SetFocus;
  end;
  RowCountChanged := TRUE;
end;

procedure TDataEditorForm.DeleteRowBitBtnClick(Sender: TObject);
var
  i: Integer;
begin
  with DataStringGrid do
  begin
    for i := Row to RowCount-2 do
    begin
      Cells[0, i] := Cells[0, i+1];
      Cells[1, i] := Cells[1, i+1];
      Cells[2, i] := Cells[2, i+1];
      Cells[3, i] := Cells[3, i+1];
    end;
    RowCount := RowCount - 1;
    SetFocus;
  end;
  RowCountChanged := TRUE;
end;

procedure TDataEditorForm.CopyBitBtnClick(Sender: TObject);
var
  i: Integer;
  TheStringList: TStringList;
begin
  TheStringList := TStringList.Create;
  with DataStringGrid do
  begin
    for i := 0 to RowCount-1 do
    begin
      TheStringList.Add(
        Cells[0, i] + Chr(VK_TAB) +
        Cells[1, i] + Chr(VK_TAB) +
        Cells[2, i] + Chr(VK_TAB) +
        Cells[3, i]);
    end;
    Clipboard.AsText := TheStringList.Text;
  end;  
  TheStringList.Free;
end;

procedure TDataEditorForm.HelpBitBtnClick(Sender: TObject);
{$IFDEF LINUX}
var
  TheHelpFile: String;
{$ENDIF}
begin
{$IFDEF LINUX}
  TheHelpFile := 'hs' + IntToStr(HelpBitBtn.HelpContext) + '.htm';
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPlotDataEditorForm.ApplyBitBtnClick
  Description: Standard ButtonClick event handler
       Author: Mat Ballard
 Date created: 03/28/2001
Date modified: 03/28/2001 by Mat Ballard
      Purpose: Applies the current Data to the Series
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDataEditorForm.ApplyBitBtnClick(Sender: TObject);
begin
{$IFDEF GUI}
  TSeries(TheSeries).ApplyDataChange(Self);
{$ENDIF}
  NumericDataChanged := FALSE;
  StringDataChanged := FALSE;
end;


procedure TDataEditorForm.NANBitBtnClick(Sender: TObject);
begin
  with DataStringGrid do
    Cells[Col, Row] := 'NAN';
  NumericDataChanged := TRUE;  
end;

end.
