unit Displace;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Axis.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 02/25/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To facilitate user setting of the displacement of a series.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, Forms, Graphics, StdCtrls, 
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QT,
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}
  Misc, NEdit, Plotdefs;

type
  TDisplacementForm = class(TForm)
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    SeriesLabel: TLabel;
    XLabel: TLabel;
    YLabel: TLabel;
    DeltaXNEdit: TNEdit;
    DeltaYNEdit: TNEdit;
    ApplyBitBtn: TBitBtn;
    HelpBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
    procedure DeltaXNEditEnter(Sender: TObject);
  private
    { Private declarations }
  public
    TheSeries: TObject;

    procedure DoHintsFromResource;
  end;

var
  DisplacementForm: TDisplacementForm;

implementation

{$R *.dfm}

uses
  Data;

{------------------------------------------------------------------------------
    Procedure: TDisplaceForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDisplacementForm.FormCreate(Sender: TObject);
begin
  DoHintsFromResource;
{set all widths:}
  SetDialogGeometry(Self, OKBitBtn, SeriesLabel.Left);
  {for i := 0 to Self.ComponentCount - 1 do
    TControl(Self.Components[i]).Width := 97;}
  SeriesLabel.AutoSize := TRUE;
end;

{------------------------------------------------------------------------------
    Procedure: TDisplacementForm.DoHintsFromResource
  Description: standard loading of labels from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display hints in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDisplacementForm.DoHintsFromResource;
begin
  ApplyBitBtn.Hint := 'Apply these properties now !';
end;

procedure TDisplacementForm.ApplyBitBtnClick(Sender: TObject);
begin
{$IFDEF GUI}
  TSeries(TheSeries).ApplyDisplacementChange(Self);
{$ENDIF}
end;


procedure TDisplacementForm.DeltaXNEditEnter(Sender: TObject);
begin
  TEdit(Sender).SelLength := 999;
end;

end.
