unit Functons;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Functions.pas, released 12 April 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/04/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To create new series from existing series using mathematical expressions.

Known Issues: This requires FUNCTIONS to be defined in Plot.inc, and for the
  TParser10 to be installed in the TPlot/Parser10 subdirectory.
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}
  Parser10,
  Misc, Plotdefs;

type
  TFunctionsForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    SeriesLabel: TLabel;
    FunctionMemo: TMemo;
    FunctionComboBox: TComboBox;
    InsertBitBtn: TBitBtn;
    FunctionHintLabel: TLabel;
    TestBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure InsertBitBtnClick(Sender: TObject);
    procedure FunctionComboBoxClick(Sender: TObject);
    procedure TestBitBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    SeriesCount: Integer;
{You have to set the SeriesCount for Test-ing to work}
    procedure DoHintsFromResource;
  end;

var
  FunctionsForm: TFunctionsForm;

implementation

{$R *.dfm}

const
  FUNCTION_MAX = 30;
  {Functions: array [0..FUNCTION_MAX] of string =
    ['PI', 'COS', 'SIN', 'SINH', 'COSH',
    'TAN', 'COTAN', 'ARCTAN', 'ARG', 'EXP',
    'LN', 'LOG10', 'LOG2', 'LOGN', 'SQRT',
    'SQR', 'POWER', 'INTPOWER', 'MIN', 'MAX',
    'ABS', 'TRUNC', 'INT', 'CEIL', 'FLOOR',
    'HEAV', 'SIGN', 'ZERO', 'PH', 'RND',
    'RANDOM'];}

  FunctionHints: array [0..FUNCTION_MAX] of string =
     ('3.14159...', 'Cosine of X', 'Sine of X', 'Hyperbloic Sine of X', 'Hyperbloic Cosine of X',
      'Tangent of X', 'Cotangent of X', 'Inverse Tangent of X', 'ARG', 'Exponent: e raised to X',
      'Natural logarithm to the base e', 'Logarithm to base 10', 'Logarithm to base 2', 'Logarithm to base N', 'Square root',
      'Square', 'Power(Y, X): Y raised to the Xth power', 'IntPower(Y, N): Y raised to the integer Nth power', 'Min(A, B): minimium of A and B', 'Max(A, B): maximium of A and B',
      'Absolute value of X', 'the value of X rounded toward zero', 'X rounded toward zero', 'the lowest integer greater than or equal to X', 'the highest integer less than or equal to X',
      'Heaviside function is 1 for x=>0, 0 for x<0', 'Sign is 1 for x>1, 0 for x=0, -1 for x<0', 'Zero is 0 for x=0, 1 for x<>0)', 'Ph ', 'Rnd ',
      'a random number within the range 0 < 1');


{------------------------------------------------------------------------------
    Procedure: TFunctionsForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position and populates the Color combo
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TFunctionsForm.FormCreate(Sender: TObject);
begin
  DoHintsFromResource;
{set combo and edit box widths:}
  SetDialogGeometry(TForm(Self), TControl(OKBitBtn), HelpBitBtn.Left);
  {for i := 0 to Self.ComponentCount - 1 do
    if (Self.Components[i] is TBitBtn) then
      TControl(Self.Components[i]).Width := 97;
  FunctionComboBox.Width := 97;}
  FunctionMemo.Width := OKBitBtn.Left + OKBitBtn.Width - HelpBitBtn.Left;
  FunctionComboBox.ItemIndex := 0;
  FunctionHintLabel.Caption := FunctionHints[0];
end;

{------------------------------------------------------------------------------
    Procedure: TFunctionsForm.DoHintsFromResource
  Description: standard loading of labels from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TFunctionsForm.DoHintsFromResource;
begin
  InsertBitBtn.Hint := 'Insert the chosen function at the cursor, + #10 + or apply it to the selected text';
  FunctionComboBox.Hint := 'The available functions to insert or apply';
  FunctionMemo.Hint := 'Type your expression in here: + #10 + eg:  4 * Series0 + Sqr(Series1) + Exp(Series3)';
  TestBitBtn.Hint := 'You have to test the expression before you can click "OK"';
end;

procedure TFunctionsForm.InsertBitBtnClick(Sender: TObject);
var
  FunctionText: String;
begin
  FunctionText := FunctionComboBox.Text;
  if (FunctionText <> 'PI') then
    FunctionText := FunctionText + '()';
  with FunctionMemo do
  begin
    if (SelLength > 0) then
      SelText := FunctionComboBox.Text + '(' +SelText + ')'
     else
{$IFDEF MSWINDOWS}
      Lines[CaretPos.y] :=
        Copy (Lines[CaretPos.y], 1, CaretPos.x) +
        FunctionText + ' + ' +
        Copy (Lines[CaretPos.y], CaretPos.x+1, 999);
{$ENDIF}
{$IFDEF LINUX}
      Lines[CaretPos.Line] :=
        Copy (Lines[CaretPos.Line], 1, CaretPos.Col) +
        FunctionText + ' + ' +
        Copy (Lines[CaretPos.Line], CaretPos.Col+1, 999);
{$ENDIF}
  end;
end;

procedure TFunctionsForm.FunctionComboBoxClick(Sender: TObject);
begin
  FunctionHintLabel.Caption := FunctionHints[FunctionComboBox.ItemIndex];
end;

{------------------------------------------------------------------------------
    Procedure: TFunctionsForm.TestBitBtnClick
  Description: checks the validity of the user's mathematical expression
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: must be used before "OK" is enabled
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TFunctionsForm.TestBitBtnClick(Sender: TObject);
var
  i: Integer;
  TheParser: TParser;
  TheExpression: String;
  TheData: array [0..99] of PParserFloat;
begin
  TheParser := TParser.Create(nil);
  TheExpression := '';
{read the equation:}
  for i := 0 to FunctionMemo.Lines.Count-1 do
    TheExpression := TheExpression + FunctionMemo.Lines[i];
  TheExpression := Misc.CleanString(TheExpression, ' ');

{try to run the Parser:}
  try
{Set up the variables:}
    for i := 0 to SeriesCount-1 do
    begin
      TheData[i] := TheParser.SetVariable(Format(UpperCase('Series') + '%d', [i]), 0);
      TheData[SeriesCount + i] := TheParser.SetVariable(Format('DSERIES%d', [i]), 0);
      TheData[2*SeriesCount + i] := TheParser.SetVariable(Format('ISERIES%d', [i]), 0);
    end;

{Set up equation:}
    TheParser.Expression := TheExpression;
    OKBitBtn.Enabled := TRUE;
  finally
    TheParser.Free;
  end;
end;

end.
