unit Metafile;

{This is the D1 implementation of TMetafileCanvas for TSciGraph}
{}
{It is based on TMetafileCanvas in the graphics unit of D4 Pro.}

interface

uses
  graphics, SysUtils, WinProcs, WinTypes;

type
  TMetafileCanvas = class(TCanvas)
  private
    FMetafile: TMetafile;
  public
    constructor Create(AMetafile: TMetafile; ReferenceDevice: HDC);
    destructor Destroy; override;
  end;

implementation

constructor TMetafileCanvas.Create(AMetafile: TMetafile; ReferenceDevice: HDC);
var
  RefDC: HDC;
  R: TRect;
  Temp: HDC;
  P: PChar;
begin
  inherited Create;
  FMetafile := AMetafile;
  RefDC := ReferenceDevice;
  if ReferenceDevice = 0 then RefDC := GetDC(0);
  try
 {   if FMetafile.MMWidth = 0 then
      if FMetafile.Width = 0 then
        FMetafile.MMWidth := GetDeviceCaps(RefDC, HORZSIZE)*100
      else
        FMetafile.MMWidth := MulDiv(FMetafile.Width,
          GetDeviceCaps(RefDC, HORZSIZE)*100, GetDeviceCaps(RefDC, HORZRES));
    if FMetafile.MMHeight = 0 then
      if FMetafile.Height = 0 then
        FMetafile.MMHeight := GetDeviceCaps(RefDC, VERTSIZE)*100
      else
        FMetafile.MMHeight := MulDiv(FMetafile.Height,
          GetDeviceCaps(RefDC, VERTSIZE)*100, GetDeviceCaps(RefDC, VERTRES));}
    R.Left := 0;
    R.Top := 0;
    R.Right := FMetafile.Width;
    R.Bottom := FMetafile.Height;
    {if (Length(CreatedBy) > 0) or (Length(Description) > 0) then
      P := PChar(CreatedBy+#0+Description+#0#0)
    else
      P := nil;}
    {Temp := CreateMetafile(RefDC, nil, @R, P);}
    Temp := CreateMetafile(nil);
    if Temp = 0 then raise
      EOutOfMemory.Create('Could not create metafile !');
    Handle := Temp;
    SetMapMode(Handle, MM_TEXT);
    SetWindowExt(Handle, FMetafile.Width, FMetafile.Height);
    SetViewportExt(Handle, FMetafile.Width, FMetafile.Height);
  finally
    if ReferenceDevice = 0 then ReleaseDC(0, RefDC);
  end;
end;

destructor TMetafileCanvas.Destroy;
var
  Temp: HDC;
begin
  Temp := Handle;
  Handle := 0;
  FMetafile.Handle := CloseMetafile(Temp);
  inherited Destroy;
end;


end.
 
