unit Plottoolbar;

{$I Plot.inc}

{$IFDEF COMPILER4_UP}
  {$DEFINE IMAGELIST}
{$ENDIF}
{$IFDEF COMPILER35}
  {$DEFINE IMAGELIST}
{$ENDIF}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Plottoolbar.pas, released 12 May 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/25/2001
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
An additional user interface for TPlot.


Known Issues:

-----------------------------------------------------------------------------}
interface

uses
  Classes, SysUtils, ActnList,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  ComCtrls, Controls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  ComCtrls, Controls, Dialogs,
{$ENDIF}
{$IFDEF LINUX}
  QComCtrls, QControls, QDialogs,
{$ENDIF}

  Plotdefs, Misc;

type
  TPlotToolBar = class(TToolBar)
  private
    FPlotActionList: TActionList;

  protected
    function GetPlotActionList(Target: TObject): TActionList; virtual;
{GetPlot is part of the Notification mechanism for linking components.}
    procedure SetPlotActionList(Value: TActionList);
{This sets the Plot, and so creates the buttons.}
    //procedure Loaded; override;
{Once streaming is completed, we need to set the ToolButton events.}
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
{Notification is part of the Notification mechanism for linking components.}
  public
    constructor Create(AOwner: TComponent); override;
{The standard constructor, in which the ToolButtonOptions are created and other
 properties set.}
    destructor Destroy; override;
{The standard destructor.}
    procedure Resize; override;

    procedure Clear;
    procedure CreateToolButtons;
{This creates all the ToolButtons from the Actions.}
    procedure SetActions;
{This sets the OnClick event for all the buttons.}
  published
    property PlotActionList: TActionList read FPlotActionList write SetPlotActionList;
{This is the PlotActionList to which this ToolBar is connected.}
  end;

implementation

uses
  PlotActionList;

{Constructor and Destructor ---------------------------------------------------}
{------------------------------------------------------------------------------
  Constructor: TPlotToolBar.Create
  Description: standard Constructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the Plot Property
 Known Issues:
 ------------------------------------------------------------------------------}
constructor TPlotToolBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FPlotActionList := nil;
  ShowHint := TRUE;
  AutoSize := TRUE;
end;

{------------------------------------------------------------------------------
   Destructor: TPlotToolbar.Destroy
  Description: standard Destructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: frees the Plot Property
 Known Issues:
 ------------------------------------------------------------------------------}
destructor TPlotToolbar.Destroy;
begin
  if FPlotActionList <> nil then
    FPlotActionList.FreeNotification(Self);
  FPlotActionList := nil;
  inherited Destroy;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.Resize;
  Description: overrides base method
       Author: Mat Ballard
 Date created: 04/20/2001
Date modified: 05/02/2001 by Mat Ballard
      Purpose: make the bloddy toolbuttons appear correctly !
 Known Issues: only took several years to figure this one out !
 ------------------------------------------------------------------------------}
procedure TPlotToolBar.Resize;
var
  AWidth, AHeight: Integer;
begin
  AWidth := Width;
  AHeight := Height;
  Self.WrapButtons(AWidth, AHeight);
  inherited Resize;
end;

{------------------------------------------------------------------------------
     Function: TPlotToolBar.GetPlot;
  Description: Check target object is a Plot
       Author: Mat Ballard
 Date created: 04/20/2001
Date modified: 05/02/2001 by Mat Ballard
      Purpose: design-time user interface
 Known Issues:
 ------------------------------------------------------------------------------}
function TPlotToolBar.GetPlotActionList(Target: TObject): TActionList;
begin
  Result := Target as TActionList;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.SetPlot;
  Description: sets the Plot
       Author: Mat Ballard
 Date created: 04/20/2001
Date modified: 05/02/2001 by Mat Ballard
      Purpose: design-time user interface
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotToolBar.SetPlotActionList(Value: TActionList);
begin
  if Value <> FPlotActionList then
  begin
    if (Value = nil) then
    begin
      FPlotActionList := Value;
{$IFDEF GUI}
      TPlotActionList(FPlotActionList).SetPlotToolBar(TPlotToolBar(nil));
{$ENDIF}
    end
    else
    begin
      FPlotActionList := Value;
      Value.FreeNotification(Self);
      if Assigned(FPlotActionList.Images) then
        Self.Images := FPlotActionList.Images;
{$IFDEF GUI}
      TPlotActionList(FPlotActionList).SetPlotToolBar(TPlotToolBar(Self));
{$ENDIF}
      if not (csLoading in ComponentState) then
      begin
        if (Self.ButtonCount < 30) then
          CreateToolButtons;
        SetActions;
      end;
    end;
  end;
end;

{ Note deletion of attached Plot component }
procedure TPlotToolBar.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = PlotActionList) then
    FPlotActionList := nil;
end;

(*{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.Loaded
  Description: sets tool button click events
       Author: Mat Ballard
 Date created: 08/08/2002
Date modified: 08/08/2002 by Mat Ballard
      Purpose: ToolButtons are either created by CreateToolButtons or the streaming system
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotToolBar.Loaded;
begin
  inherited Loaded;
  if (Self.ButtonCount < 50) then
    CreateToolButtons;
  SetActions;
end;*)

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.SetActions
  Description: sets tool button click events
       Author: Mat Ballard
 Date created: 08/08/2002
Date modified: 08/08/2002 by Mat Ballard
      Purpose: ToolButtons are either created by CreateToolButtons or the streaming system
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotToolBar.SetActions;
var
  i, Index: Word;
begin
{$IFDEF GUI}
  if (Assigned(FPlotActionList)) then
  begin
    Index := 0;
{Note: we do not make buttons for the Help and About:}
    for i := 0 to FPlotActionList.ActionCount-3 do
    begin
      if (FPlotActionList.Actions[i].Tag >= 0) then
      begin
        Self.Buttons[Index].Action := FPlotActionList.Actions[i];
        Self.Buttons[Index].OnClick := FPlotActionList.Actions[i].OnExecute;
        Self.Buttons[Index].Visible := TAction(FPlotActionList.Actions[i]).Visible;
        //Self.Buttons[Index].Style := tbsButton;
        Inc(Index);
      end
      else if ((i > 0) and (FPlotActionList.Actions[i].Tag = MENU_START)) then
      begin // and end of submenu divider
        Self.Buttons[Index].Action := FPlotActionList.Actions[i];
        Self.Buttons[Index].Visible := TAction(FPlotActionList.Actions[i]).Visible;
        Self.Buttons[Index].Style := tbsButton; // tbsDivider and tbsSeparator all pile up at the top left
        Self.Buttons[Index].Width := 8;
        Inc(Index);
      end;
    end;
  end;
{$ENDIF}
end;

procedure TPlotToolBar.Clear;
var
  i: Integer;
  TempToolButton: TToolButton;
begin
  for i := Self.ButtonCount-1 downto 0 do
  begin
    TempToolButton := Self.Buttons[i];
    if (TempToolButton.Tag < 0) or (CAPTION_BASE <= TempToolButton.Tag) then
    begin
      TempToolButton.Parent := nil;
      TempToolButton.Free;
    end;
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.CreateToolButtons
  Description: creates tool buttons
       Author: Mat Ballard
 Date created: 11/18/2000
Date modified: 07/25/2001 by Mat Ballard
      Purpose: modularize user-interface code
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotToolBar.CreateToolButtons;
var
  i: Integer;
  TempToolButton: TToolButton;
begin
{$IFDEF GUI}
  if ((Self.ButtonCount < 20) and (Assigned(FPlotActionList))) then
  begin // no actions created yet
    for i := FPlotActionList.ActionCount-3 downto 0 do
    begin
      if (FPlotActionList.Actions[i].Tag >= 0) then
      begin
        TempToolButton := TToolButton.Create(Self);
        TempToolButton.Name := FPlotActionList.Actions[i].Name + 'Btn';
        //TempToolButton.Action := FPlotActionList.Actions[i];
        //TempToolButton.Style := tbsButton;
        TempToolButton.Tag := FPlotActionList.Actions[i].Tag;
        TempToolButton.Parent := Self;
      end
      else if ((i > 0) and (FPlotActionList.Actions[i].Tag = MENU_START)) then
      begin // and end of submenu divider
        TempToolButton := TToolButton.Create(Self);
        TempToolButton.Name := FPlotActionList.Actions[i].Name + 'Btn';
        //TempToolButton.Action := FPlotActionList.Actions[i];
        //TempToolButton.Style := tbsDivider;
        TempToolButton.Tag := MENU_START;
        //TempToolButton.Width := 8;
        TempToolButton.Parent := Self;
      end
    end; {for i}
  end;
{$ENDIF}
end;

{ this fixes the "class not found" stuff:}
initialization
  //Classes.RegisterClass(TPlotToolBar);
  Classes.RegisterClass(TToolButton);


end.
