unit Plot_Reg;

{$I Version.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Plot_reg.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/15/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
Registration unit for the TPlot component.


Known Issues:
        - Property editors were stuffed under Kylix 1.
        - Property editors are stuffed under BC++ Builder.
-----------------------------------------------------------------------------}

{$I Plot.inc}

interface

uses
  Classes,
{Borland removed the source to property editors and other IDE goodies in Kylix and D6 up:}  
{$IFDEF COMPILER6_UP}
  DesignEditors, DesignIntf,
{PLEASE NOTE: the property editors need DesignEditors and DesignIntf,
 and to avoid rude messages about "DesignConst" (which does not exist),
 you have to add "designide.dcp" to the requires section of this package.
                  ^^^^^^^^^^^^^
 Solution courtesy of Amy Khai Luong <akluong@sandia.gov>
 }
{$ELSE}
  {$IFNDEF BCB5}
  DsgnIntf,
  {$ENDIF}
{$ENDIF}

{$IFDEF COMPILER4_UP}
  Plotactionlist,
  Plotimagelist,
  Plottoolbar,
  Plotmenu,
  Plotpopupmenu,
{$ENDIF}
  Plot;

{$IFNDEF BCB5}
type
  TPlotComponentEditor = class(TComponentEditor)
  public
    function GetVerb(Index: Integer): String; override;
    function GetVerbCount: Integer; override;
    procedure ExecuteVerb(Index: Integer); override;
    procedure Edit; override;
  end;
{$ENDIF}

procedure Register;

implementation

{$IFDEF WINDOWS}
{$R Plot16.dcr}
{$ENDIF}
{$IFDEF WIN32}
{$R Plot32.dcr}
{$ENDIF}
{$IFDEF LINUX}
{$R Plot32.dcr}
{$ENDIF}

{$IFNDEF BCB5}
type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TAxesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TDataProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TProperties = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TSeriesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Chemware', [TPlot]);
{$IFDEF GUI}
  {$IFDEF COMPILER4_UP}
  RegisterComponents('Chemware', [TPlotActionList]);
  RegisterComponents('Chemware', [TPlotImageList]);
  RegisterComponents('Chemware', [TPlotMenu]);
  RegisterComponents('Chemware', [TPlotPopupMenu]);
  RegisterComponents('Chemware', [TPlotToolBar]);
  {$ENDIF}
{$ENDIF}


{$IFNDEF BCB5}
{register the "About" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'About', TAboutProperty);
{register the "Data" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'DataProperties', TDataProperty);
{register the "Properties" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'Properties', TProperties);
{register the "Series" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'SeriesProperties', TSeriesProperty);
{register the "Axes" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'AxesProperties', TAxesProperty);
{register the component editor for menus:}
  RegisterComponentEditor(TPlot, TPlotComponentEditor);
{$ENDIF}
end;


{$IFNDEF BCB5}
{TPlotComponentEditor methods:-------------------------------------------------}
function TPlotComponentEditor.GetVerb(Index: Integer): String;
begin
  case Index of
{$IFDEF GUI}
    0: Result := '&About TPlot...';
{$ELSE}
    0: Result := '&About TConsolePlot...';
{$ENDIF}
    1: Result := 'A&xes...';
    2: Result := '&Copy';
    3: Result := '&Data...';
    4: Result := '&Properties...';
    5: Result := '&Series...';
  end;
end;

function TPlotComponentEditor.GetVerbCount: Integer;
begin
  Result := 6;
end;

procedure TPlotComponentEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: (Component as TCustomPlot).ShowAbout(nil);
    1: (Component as TCustomPlot).ShowAxes;
    2: (Component as TCustomPlot).CopyClick(nil);
    3: (Component as TCustomPlot).ShowData;
    4: (Component as TCustomPlot).ShowProperties;
    5: (Component as TCustomPlot).ShowSeries;
  end;
end;

procedure TPlotComponentEditor.Edit;
begin
  (Component as TCustomPlot).ShowProperties;
end;
{end TPlotComponentEditor methods:---------------------------------------------}

{About bits and pieces:------------------------------------------------------}
procedure TAboutProperty.Edit;
{call the "About" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowAbout(nil);
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About...)';
end;

{End About bits and pieces:--------------------------------------------------}

{Data bits and pieces:------------------------------------------------------}
procedure TDataProperty.Edit;
{call the "Data" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowData;
end;

function TDataProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TDataProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Data...)';
end;

{End Data bits and pieces:--------------------------------------------------}

{Properties bits and pieces:------------------------------------------------------}
procedure TProperties.Edit;
{call the "Properties" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowProperties;
end;

function TProperties.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TProperties.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Properties...)';
end;

{End Properties bits and pieces:--------------------------------------------------}

{Series bits and pieces:------------------------------------------------------}
procedure TSeriesProperty.Edit;
{call the "Series" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowSeries;
end;

function TSeriesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TSeriesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Series...)';
end;

{End Series bits and pieces:--------------------------------------------------}

{$IFDEF COMPILER35_UP}
{Toolbar bits and pieces:------------------------------------------------------}
{procedure TToolbarProperty.Edit;
begin
  TPlotToolBar(GetComponent(0)).ShowArrangement;
end;

function TToolbarProperty.GetAttributes: TPropertyAttributes;
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TToolbarProperty.GetValue: String;
begin
  GetValue := '(Arrangement...)';
end;}
{End Toolbar bits and pieces:--------------------------------------------------}
{$ENDIF}

{Axes bits and pieces:------------------------------------------------------}
procedure TAxesProperty.Edit;
{call the "Axes" dialog window when clicking on ... in the Object Inspector}
begin
  TCustomPlot(GetComponent(0)).ShowAxes;
end;

function TAxesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAxesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Axes...)';
end;
{End Axes bits and pieces:--------------------------------------------------}

{$ENDIF}
end.
