unit Plotpopupmenu;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Axis.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 02/25/2000
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
The purpose of this module is to provide the developer using TPlot a quick
method of rapidly implementing menu access to the TPlot functions.

It will be augmented by a TPlotAction module at a later stage.

Known Issues:
    - Since TPlotPopupMenu is useless without TPlot, there is only the one
      registration unit: TPlot_Reg.pas.
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils, ActnList, Typinfo,
{$IFDEF WINDOWS}
  Menus,
{$ENDIF}
{$IFDEF WIN32}
  Menus,
{$ENDIF}
{$IFDEF LINUX}
  QMenus,
{$ENDIF}

  Misc, Plot, Plotdefs;

const
  TPlotPopupMenu_VERSION = 300;

  FILE_TAG = 1000;
  HELP_TAG = 1095;
  ABOUT_TAG = 1096;
  REOPEN_TAG = 1097;
  EXIT_DIV_TAG = 1098;
  EXIT_TAG = 1099;

  mnuReopen = 2;

type
  TPlotPopupMenu = class(TPopupMenu)
  private
{The PlotActionList to which this menu is linked:}
    FPlotActionList: TActionList;
  protected
    procedure DetermineMenuVisibility;
    procedure SetSeriesVisibility(Value: Boolean);
{$IFDEF COMPILER5_UP}
    procedure DoPopup(Sender: TObject); override;
{We use this to set the popup menu items visibility. Delphi 4 users have to set the PopupMenu property manually.}
{$ENDIF}
    //procedure Loaded; override;
{Override the Loaded procedure to prevent duplication of menu item creation.}
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
{Implementation of the standard Notification method for linked components.}
    procedure SetPlotActionList(Value: TActionList);
{Sets the pointer to the associated TPlotActionList, creates the menus and their OnClicks}
  public
    constructor Create(AOwner: TComponent); override;
{The standard constructor.}
    destructor Destroy; override;
{The standard destructor.}

    procedure Clear;

    procedure CreateMenus;
{Creates the menus from the Actions after the Plot property is set.}
    procedure SetActions;
{Points each popup menu item at FPlotActionsList's Actions}
    function MenuExists(ATag: Integer; AName: String): Boolean;
{Does AMenu already exist in Self ?}
{}
{The basis for comparison is both the Tag and Caption}
  published
    property PlotActionList: TActionList read FPlotActionList write SetPlotActionList;
{The PlotActionList to which this TPlotPopupMenu is linked.}
  end;


implementation

uses
  PlotActionList;

{Constructor and Destructor ---------------------------------------------------}
{------------------------------------------------------------------------------
  Constructor: TPlotPopupMenu.Create
  Description: standard Constructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: initialization
 Known Issues:
 ------------------------------------------------------------------------------}
constructor TPlotPopupMenu.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FPlotActionList := nil;
end;

{------------------------------------------------------------------------------
   Destructor: TPlotPopupMenu.Destroy
  Description: standard Destructor
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: frees the Plot Property
 Known Issues:
 ------------------------------------------------------------------------------}
destructor TPlotPopupMenu.Destroy;
begin
  if FPlotActionList <> nil then
    FPlotActionList.FreeNotification(Self);
  FPlotActionList := nil;
  inherited Destroy;
end;

(*{------------------------------------------------------------------------------
    Procedure: TPlotMenu.Loaded
  Description: standard Loaded override
       Author: Mat Ballard
 Date created: 04/25/2003
Date modified: 04/25/2003 by Mat Ballard
      Purpose: prevent duplication of menu items
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.Loaded;
begin
  inherited Loaded;
  if (Self.Items.Count < 4) then
    CreateMenus;
  SetActions;
end;*)

{Get functions and Set procedures ---------------------------------------------}
{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.SetPlotActionList
  Description: standard property Set procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the PlotActionList Property
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.SetPlotActionList(Value: TActionList);
begin
  if Value <> FPlotActionList then
  begin
    if (Value = nil) then
    begin
      FPlotActionList := Value;
{$IFDEF GUI}
      TPlotActionList(FPlotActionList).SetPlotPopupMenu(TPlotPopupMenu(nil));
{$ENDIF}
    end
    else
    begin
      FPlotActionList := Value;
      Value.FreeNotification(Self);
      if Assigned(FPlotActionList.Images) then
        Self.Images := FPlotActionList.Images;
{$IFDEF GUI}
      if not (csLoading in ComponentState) then
      begin
        if (Self.Items.Count < 4) then
          CreateMenus;
        SetActions;
      end;
      TPlotActionList(FPlotActionList).SetPlotPopupMenu(TPlotPopupMenu(Self));
{$ENDIF}
    end;
  end;
end;

{General methods --------------------------------------------------------------}
{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.SetActions
  Description: sets the Actions for the menu items
       Author: Mat Ballard
 Date created: 04/25/2003
Date modified: 04/25/2003 by Mat Ballard
      Purpose: Action management
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.SetActions;
var
  i, j: Integer;
begin
  if (Assigned(FPlotActionList)) then
  begin
    for i := 0 to Self.Items.Count-1 do
    begin
      for j := 0 to Self.Items[i].Count-1 do
        if ((0 <= Self.Items[i].Items[j].Tag) and
            (Self.Items[i].Items[j].Tag < FPlotActionList.ActionCount)) then
        begin
          Self.Items[i].Items[j].Action := FPlotActionList.Actions[Self.Items[i].Items[j].Tag];
          Self.Items[i].Items[j].OnClick := FPlotActionList.Actions[Self.Items[i].Items[j].Tag].OnExecute;
        end;
    end;
  end;
end;

procedure TPlotPopupMenu.Clear;
var
  i, j: Integer;
  TempMenuItem: TMenuItem;
begin
  for i := 0 to Self.Items.Count-1 do
  begin
    for j := 0 to Self.Items[i].Count-1 do
    begin
      TempMenuItem := Self.Items[i].Items[j];
      Self.Items[i].Delete(j);
      TempMenuItem.Free;
    end;
    TempMenuItem := Self.Items[i];
    Self.Items.Delete(i);
    TempMenuItem.Free;
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.CreateMenus
  Description: creates popup menus that are accessible by right-click
       Author: Mat Ballard
 Date created: 12/1/1999
Date modified: 04/20/2000 by Mat Ballard
      Purpose: modularize user-interface code
 Known Issues: this was a bitch to get right !
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.CreateMenus;
{$IFDEF GUI}
var
  i: Word;
  MenuIndex: Integer;
{This following is just a dummy matrix of menu items used to create sub-menus,
 then removed and the menuitems freed.}
  TempMenu: array [0..31] of array [0..0] of TMenuItem;
  TempMenuItem: TMenuItem;
begin
  if ((Self.Items.Count < 4) and (Assigned(FPlotActionList))) then
  begin
    MenuIndex := -1;
    for i := 0 to FPlotActionList.ActionCount-1 do
    begin
      if (FPlotActionList.Actions[i].Tag = MENU_START) then
        Inc(MenuIndex);
{don't re-create a menu if it already exists:}
      if (not MenuExists(FPlotActionList.Actions[i].Tag,
        FPlotActionList.Actions[i].Name)) then
      begin
        if (FPlotActionList.Actions[i].Tag = MENU_START) then
        begin
{we create a temporary menu array to add the submenu, and then later remove it:}
          TempMenu[MenuIndex][0] := TMenuItem.Create(Self);
          TempMenu[MenuIndex][0].Name := Format('Menu%d', [i]);
          TempMenu[MenuIndex][0].Tag := -999;
          TempMenuItem := NewSubMenu(
            TAction(FPlotActionList.Actions[i]).Caption,
            0,
            'pmi' + FPlotActionList.Actions[i].Name,
            TempMenu[MenuIndex]);
          TempMenuItem.Tag := i;
{Developers can insert menus using TMainMenu.merge:}
          Self.Items.Add(TempMenuItem);
        end {Menu Start}
        else if ((FPlotActionList.Actions[i].Tag = MENUITEM_DIVIDER) or (FPlotActionList.Actions[i].Tag >= 0)) then
        begin {Menu item:}
          TempMenuItem := TMenuItem.Create(Self);
          TempMenuItem.Name := 'pmi' + FPlotActionList.Actions[i].Name;
          TempMenuItem.Tag := i;
{add the TempMenuItem to the popup:}
          Self.Items[MenuIndex].Add(TempMenuItem);
        end;
      end; {MenuExists}
    end; {i over Actions}

{remove the temporary menu array used to create the submenu:}
    for i := 0 to Ord(High(TMainMenus)) do
    begin
      if (Self.Items[i].Items[0].Tag = -999) then
      begin
        Self.Items[i].Remove(TempMenu[i][0]);
        TempMenu[i][0].Free;
      end;
    end; {i over submenus}
  end; {FPlotActionList <> nil}

{$ELSE}
begin  
{$ENDIF} {GUI}  
end;

{$IFDEF COMPILER5_UP}
{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.DoPopup
  Description: overridden pre-popup method
       Author: Mat Ballard
 Date created: 05/05/2003
Date modified: 05/05/2003 by Mat Ballard
      Purpose: set the visibility of popup menu items.
 Known Issues: Delphi 4 users have to set PopupMenu manually.
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.DoPopup(Sender: TObject);
begin
  if Assigned(FPlotActionList) then
  begin
    DetermineMenuVisibility;
    if Assigned(OnPopup) then OnPopup(Sender);
  end;
end;
{$ENDIF}

{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.CreateReopenSubMenu
  Description: creates popup menus that are accessible by right-click
       Author: Mat Ballard
 Date created: 12/1/1999
Date modified: 04/20/2000 by Mat Ballard
      Purpose: modularize user-interface code
 Known Issues: this was a bitch to get right !
 ------------------------------------------------------------------------------}
(*procedure TPlotPopupMenu.CreateReopenSubMenu;
var
{This following is just a dummy matrix of menu items used to create sub-menus,
 then removed and the menuitems freed.}
  TempMenu: array [0..0] of TMenuItem;
  TempMenuItem: TMenuItem;
begin
{don't create menus when the Plot property is streamed in:}
  if (csLoading in ComponentState) then exit;

{don't re-create a menu if it already exists:}
  if ((Self.Items[0].Items[mnuReopen].Tag = REOPEN_TAG) and
      (Self.Items[0].Items[mnuReopen].Caption = '&Reopen')) then
    exit;

{we create a temporary menu array to add the submenu, and then later remove it:}
  TempMenu[0] := TMenuItem.Create(Self);
  TempMenu[0].Visible := FALSE;
  TempMenuItem := NewSubMenu(
    '&Reopen',
    0,
    'ReopenSubMenu',
    TempMenu);

  TempMenuItem.Tag := REOPEN_TAG;
{disable the "Reopen" menu because it has no entries:}
{$IFNDEF SHOWALLMENUS}
  TempMenuItem.Enabled := FALSE;
{$ENDIF}

  Self.Items[0].Insert(mnuReopen, TempMenuItem);
{remove the temporary menu array used to create the submenu:}
  Self.Items[0].Items[mnuReopen].Remove(TempMenu[0]);
{then free it:}
  TempMenu[0].Free;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.HandleFileClick
  Description: Click Event handler for all Reopen file menus
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: responds to user clicks of the FilaName menus by firing the
               TPlot.Open method
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.HandleFileClick(Sender: TObject);
begin
  //if (FPlot = nil) then exit;

  //FPlot.OpenFile(TMenuItem(Sender).Hint);
end;
*)

{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.Notification
  Description: handles changes in Plot property
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Notifies TPlot that it is no longer loved
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = PlotActionList) then
  begin
    FPlotActionList := nil;
  end;
end;

{------------------------------------------------------------------------------
     Function: TPlotPopupMenu.MenuExists
  Description: Does this menu exist ? Based on Tag and Caption
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: do we need to add a menu item ?
 Return Value: Boolean;
 Known Issues:
 ------------------------------------------------------------------------------}
function TPlotPopupMenu.MenuExists(ATag: Integer; AName: String): Boolean;
var
  i,
  j: Integer;
begin
  Result := FALSE;
  for i := 0 to Self.Items.Count-1 do
  begin
{the menus:}
    if ((Self.Items[i].Tag = ATag) and
        (Pos(AName, Self.Items[i].Name) = 4)) then
    begin
      Result := TRUE;
      exit;
    end;
    for j := 0 to Self.Items[i].Count-1 do
    begin
{the submenus:}
      if ((Self.Items[i].Items[j].Tag = ATag) and
          (Pos(AName, Self.Items[i].Items[j].Name) = 4)) then
      begin
        Result := TRUE;
        exit;
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.DetermineMenuVisibility
  Description: Sets the visibility of Axis-related menus
       Author: Mat Ballard
 Date created: 04/17/2000
Date modified: 04/17/2003 by Mat Ballard
      Purpose: menu management
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.DetermineMenuVisibility;
var
  SeriesVisibility: Boolean;
  APlot: TPlot;
begin
{$IFNDEF SHOWALLMENUS}
  if ((Assigned(FPlotActionList)) and (Assigned(TPlotActionList(FPlotActionList).Plot))) then
  begin
    APlot := TPlotActionList(FPlotActionList).Plot;
    //Self.Items[Ord(mnuEdit)].Items[Ord(mnuPaste)].Enabled := APlot.CanPaste;

    Self.Items[Ord(mnuView)].Items[Ord(mnuHide)].Visible := TRUE;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditAxis)].Visible := FALSE;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditFont)].Visible := FALSE;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuDeleteNote)].Visible := FALSE;
    Self.Items[Ord(mnuView)].Items[Ord(mnuNoteBorders)].Visible :=
      (APlot.Notes.Count > 0);
    Self.Items[Ord(mnuView)].Items[Ord(mnuLegend)].Visible := FALSE;
    SeriesVisibility := FALSE;

    Self.Items[Ord(mnuFile)].Items[Ord(mnuClearOverlays)].Visible :=
      (APlot.FirstOverlay >= 0);

    case APlot.ClickedObjectType of
      soTitle,
      soXAxisTitle, soYAxisTitle,
      soXAxisLabel, soYAxisLabel,
      soText:
        begin
          Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditFont)].Visible := TRUE;
          Self.Items[Ord(mnuEdit)].Items[Ord(mnuDeleteNote)].Visible :=
            (APlot.Texts.Count > 0);
        end;
      soNote:
        begin
          Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditFont)].Visible := TRUE;
          Self.Items[Ord(mnuEdit)].Items[Ord(mnuDeleteNote)].Visible :=
            (APlot.Notes.Count > 0);
        end;
      soLegend:
        begin
          Self.Items[Ord(mnuView)].Items[Ord(mnuHide)].Visible := TRUE;
          Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditFont)].Visible := TRUE;
          if (APlot.Series.Count > 1) then
          begin
            Self.Items[Ord(mnuView)].Items[Ord(mnuLegend)].Visible := TRUE;
          end;
          if (Assigned(APlot.ClickedSeries)) then
          begin
            Self.Items[Ord(mnuView)].Items[Ord(mnuHide)].Visible := TRUE;
            SeriesVisibility := TRUE;
          end;
        end;
      soXAxis, soYAxis, soZAxis:
        begin
          Self.Items[Ord(mnuView)].Items[Ord(mnuHide)].Visible := TRUE;
          Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditAxis)].Visible := TRUE;
        end;
      soSeries:
        begin
          //APlot.ClickedSeries.OutlineSeries(FOutlineWidth, Canvas);
          Self.Items[Ord(mnuView)].Items[Ord(mnuHide)].Visible := TRUE;
          SeriesVisibility := TRUE;
        end;
    else
      {soLeftBorder, soTopBorder, soRightBorder, soBottomBorder:}
      begin
        Self.Items[Ord(mnuView)].Items[Ord(mnuHide)].Visible := FALSE;
      end;
    end;

    SetSeriesVisibility(SeriesVisibility);

    Self.Items[Ord(mnuEdit)].Items[Ord(mnuDisplaceDiv)].Visible :=
        Self.Items[Ord(mnuEdit)].Items[Ord(mnuDisplace)].Visible;
  {NewSeries means that this divider is now always visible:
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditSeriesDiv)].Visible :=
      Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditSeries)].Visible;}
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuCalcAverageDiv)].Visible :=
      Self.Items[Ord(mnuCalc)].Items[Ord(mnuCalcAverage)].Visible;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuLineOfBestFitDiv)].Visible :=
      Self.Items[Ord(mnuCalc)].Items[Ord(mnuLineOfBestFit)].Visible;
  end;
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPopupMenu.SetSeriesVisibility
  Description: Sets the visibility of Series-related menus
       Author: Mat Ballard
 Date created: 04/17/2000
Date modified: 04/17/2000 by Mat Ballard
      Purpose: menu management
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPopupMenu.SetSeriesVisibility(Value: Boolean);
var
  AnyPoints, EnoughPoints: Boolean;
  APlot: TPlot;
begin
{$IFNDEF SHOWALLMENUS}
  if ((Assigned(FPlotActionList)) and (Assigned(TPlotActionList(FPlotActionList).Plot))) then
  begin
    APlot := TPlotActionList(FPlotActionList).Plot;
    AnyPoints := (APlot.Series.TotalNoPts > 0);
    EnoughPoints := (APlot.Series.TotalNoPts >= 20);
{If there is only one series, then many things become enabled:}
    Value := Value or (APlot.Series.Count = 1);
{Can't do anything to a Series if there is no data:}
    Value := Value and AnyPoints;

{The following are independent of whether or not a Series has been selected:}
    Self.Items[Ord(mnuFile)].Items[Ord(mnuSave)].Visible :=
      EnoughPoints and APlot.Series.DataChanged;
    Self.Items[Ord(mnuFile)].Items[Ord(mnuSaveAs)].Visible :=
      EnoughPoints;

    Self.Items[Ord(mnuEdit)].Items[Ord(mnuCopyHTML)].Visible := (APlot.Series.Count > 0);
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuDeleteY2Axis)].Visible :=
      (APlot.Axes.Count > 2);

    Self.Items[Ord(mnuCalc)].Items[Ord(mnuNearestPoint)].Visible := AnyPoints;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuCompressAllSeries)].Visible := EnoughPoints;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuContractAllSeries)].Visible := EnoughPoints;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuFunctionDiv)].Visible := (APlot.Series.Count > 0);
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuFunction)].Visible := (APlot.Series.Count > 0);
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuFourier)].Visible := EnoughPoints;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuInverseFourier)].Visible := EnoughPoints;

  {The following DO DEPEND on whether or not a Series has been selected:}
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuCopySeries)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuDisplace)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuResetDisplacement)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuCloneSeries)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditPoint)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditData)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuEditSeries)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuDeleteSeries)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuLinearize)].Visible := Value;
    Self.Items[Ord(mnuEdit)].Items[Ord(mnuZero)].Visible := Value;

    Self.Items[Ord(mnuCalc)].Items[Ord(mnuCalcAverage)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuCompressSeries)].Visible :=
      Value and
      EnoughPoints and
      (Assigned(APlot.ClickedSeries)) and
      (not ((Assigned(APlot.ClickedSeries.XDataSeries)) or (APlot.ClickedSeries.XDataRefCount > 0)));
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuContractSeries)].Visible :=
      Self.Items[Ord(mnuCalc)].Items[Ord(mnuCompressSeries)].Visible;

    Self.Items[Ord(mnuCalc)].Items[Ord(mnuCubicSpline)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuHighs)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuMovingAverage)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuSmoothSeries)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuSortSeries)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuCalculusDiv)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuDifferentiate)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuIntegrate)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuIntegral)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuLineOfBestFit)].Visible := Value;
    Self.Items[Ord(mnuCalc)].Items[Ord(mnuTwoRegionLineOfBestFit)].Visible := Value;
  end;
{$ENDIF}
end;


{ this does NOT this fix the missing OnClick stuff:}
(*initialization
  Classes.RegisterClass(TMenuItem);*)

end.
