unit Plotzoom;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Zoom.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 06/25/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To facilitate user manipluation of the plot scale.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}
  Misc, Nedit, Plotdefs;

type
  TZoomForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    ApplyBitBtn: TBitBtn;
    XMinLabel: TLabel;
    XMaxLabel: TLabel;
    YMinLabel: TLabel;
    YMaxLabel: TLabel;
    XMinNEdit: TNEdit;
    XMaxNEdit: TNEdit;
    YMinNEdit: TNEdit;
    YMaxNEdit: TNEdit;
    OKBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ApplyBitBtnClick(Sender: TObject);
    procedure NEditEnter(Sender: TObject);
  private

  public
    ThePlot: TObject;
    procedure DoHintsFromResource;
  end;

var
  ZoomForm: TZoomForm;

implementation

{$R *.dfm}

uses
  Plot;
  
{------------------------------------------------------------------------------
    Procedure: TZoomForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TZoomForm.FormCreate(Sender: TObject);
begin
  DoHintsFromResource;
{set all widths:}
  SetDialogGeometry(Self, OKBitBtn, HelpBitBtn.Left);
  {for i := 0 to Self.ComponentCount - 1 do
    TControl(Self.Components[i]).Width := 97;}
end;

{------------------------------------------------------------------------------
    Procedure: TZoomForm.DoHintsFromResource
  Description: standard loading of Hints from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TZoomForm.DoHintsFromResource;
begin
  ApplyBitBtn.Hint := 'Apply these properties now !';
end;

{------------------------------------------------------------------------------
    Procedure: TZoomForm.FormClose
  Description: standard FormClose procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: checks for valid user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TZoomForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Test, TestMax: Single;
begin
{Check that floating point values are valid:}
  Action := caHide;
  try
    XMinNEdit.SetFocus;
    Test := StrToFloat(XMinNEdit.Text);
    XMaxNEdit.SetFocus;
    TestMax := StrToFloat(XMaxNEdit.Text);
    if (TestMax < Test) then
      ERangeError.CreateFmt('The Min (%g) MUST be less than the Max (%g)', [Test, TestMax]);
    YMinNEdit.SetFocus;
    Test := StrToFloat(YMinNEdit.Text);
    YMaxNEdit.SetFocus;
    TestMax := StrToFloat(YMaxNEdit.Text);
    if (TestMax < Test) then
      ERangeError.CreateFmt('The Min (%g) MUST be less than the Max (%g)',
        [Test, TestMax]);
{We do the above and below the squelch the warning messages.}
    Tag := Trunc(Test);
  except
{Prevent closure:}
    Action := caNone;
  end;
end;


procedure TZoomForm.ApplyBitBtnClick(Sender: TObject);
begin
{$IFDEF GUI}
  TPlot(ThePlot).ApplyZoom(Self);
{$ENDIF}
end;

procedure TZoomForm.NEditEnter(Sender: TObject);
begin
  TEdit(Sender).SelLength := 999;
end;

end.
