unit Propedit;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are used with permission, subject to the Mozilla
Public License Version 1.1 (the "License"); you may not use this file except
in compliance with the License. You may obtain a copy of the License at

    http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: PropEdit.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 10/10/2002
Current Version: 3.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To edit various TPlot properties not covered by other dialogs..

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils, TypInfo,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, ComCtrls, ExtCtrls, Forms, Graphics, Printers, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, ComCtrls, ExtCtrls, Forms, Graphics, Printers, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QExtCtrls, QForms, QGraphics, QPrinters, QStdCtrls,
{$ENDIF}

  Axis, Misc, Plotdefs, Nedit, Coloredt;

type
  TPlotPropertyEditorForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    PlotTypeComboBox: TComboBox;
    PlotTypeLabel: TLabel;
    ColorLabel: TLabel;
    CreatedByEdit: TEdit;
    DescriptionEdit: TEdit;
    CreatedByLabel: TLabel;
    DescriptionLabel: TLabel;
    PieRowCountComboBox: TComboBox;
    PieRowCountLabel: TLabel;
    ClickAndDragDelayNEdit: TNEdit;
    DragDelayLabel: TLabel;
    ColumnGapLabel: TLabel;
    ColumnGapNEdit: TNEdit;
    PrintOrientLabel: TLabel;
    PrintOrientationComboBox: TComboBox;
    Label7: TLabel;
    GridLabel: TLabel;
    GridComboBox: TComboBox;
    PolarRangeLabel: TLabel;
    PolarRangeNEdit: TNEdit;
    ApplyBitBtn: TBitBtn;
    XYFastAtLabel: TLabel;
    XYFastAtNEdit: TNEdit;
    BackColorEdit: TColorEdit;
    GridColorEdit: TColorEdit;
    ContourGroupBox: TGroupBox;
    ContourDetailLabel: TLabel;
    ContourDetailComboBox: TComboBox;
    ContourIntervalLabel: TLabel;
    ContourIntervalNEdit: TNEdit;
    ContourStartLabel: TLabel;
    ContourStartNEdit: TNEdit;
    ContourWireFrameCheckBox: TCheckBox;
    Label1: TLabel;
    ColorMinNEdit: TNEdit;
    Label3: TLabel;
    ColorMaxNEdit: TNEdit;
    Label2: TLabel;
    GammaNEdit: TNEdit;
    ThreeDGroupBox: TGroupBox;
    ZAxisAngleNEdit: TNEdit;
    ZAxisAngleLabel: TLabel;
    ZLengthLabel: TLabel;
    ZLengthNEdit: TNEdit;
    ZSeriesLinkCheckBox: TCheckBox;
    GridStyleComboBox: TComboBox;
    WallColor2Edit: TColorEdit;
    WallColorEdit: TColorEdit;
    Label4: TLabel;
    WallTypeComboBox: TComboBox;
    Label5: TLabel;
    PlotColorEdit: TColorEdit;
    BackColor2Edit: TColorEdit;
    BackColorComboBox: TComboBox;
    BordersGroupBox: TGroupBox;
    BordersCheckBox: TCheckBox;
    BorderGapNEdit: TNEdit;
    BorderGapMinNEdit: TNEdit;
    BorderGapMaxNEdit: TNEdit;
    Label6: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LegendRadioGroup: TRadioGroup;
    ZSeriesNamesCheckBox: TCheckBox;

    procedure FormCreate(Sender: TObject);
    procedure PlotTypeComboBoxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure HelpBitBtnClick(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
    procedure GridComboBoxChange(Sender: TObject);
    procedure WallTypeComboBoxChange(Sender: TObject);
    procedure BackColorComboBoxChange(Sender: TObject);

  private

  public
    ThePlot: TObject;

    procedure DoHintsFromResource;
  end;

var
  PlotPropertyEditorForm: TPlotPropertyEditorForm;

implementation

{$R *.dfm}

uses
  Data, Plot;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.FormCreate(Sender: TObject);
var
  i: TColor;
begin
  DoHintsFromResource;

  SetDialogGeometry(Self, ApplyBitBtn, PlotTypeLabel.Left);

{the exceptions:}
  PieRowCountComboBox.Width := 50;
  //ClickAndDragDelayNEdit.Width := 64;

  //BubbleSizeNEdit.Top := MultiplicityComboBox.Top;
  //BubbleSizeLabel.Top := MultiplicityLabel.Top;
  //ColumnGapLabel.Top := MultiplicityLabel.Top;
  //ColumnGapNEdit.Top := MultiplicityComboBox.Top;
  ContourGroupBox.Top := ColumnGapNEdit.Top;
  //ContourWireFrameCheckBox.Left := ContourStartNEdit.Left;
  PieRowCountLabel.Top := ColumnGapLabel.Top;
  PieRowCountComboBox.Top := ColumnGapNEdit.Top;
  PolarRangeLabel.Top := ColumnGapLabel.Top;
  PolarRangeNEdit.Top := ColumnGapNEdit.Top;
  XYFastAtNEdit.Top := ColumnGapNEdit.Top;
  XYFastAtLabel.Top := ColumnGapLabel.Top;
  //ZAxisAngleLabel.Top := MultiJoinLabel.Top;
  //ZAxisAngleNEdit.Top := MultiJoinEdit.Top;
  //ZLengthNEdit.Top := ZAxisAngleNEdit.Top;
  //ZLengthLabel.Top := ZAxisAngleLabel.Top;
  ContourGroupBox.Top := ColumnGapNEdit.Top;
  ThreeDGroupBox.Top := ContourGroupBox.Top + ContourGroupBox.Height;

{Populate the combo boxes:}
  for i := 0 to Ord(High(TGridType)) do
    BackColorComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TGridType), i), 3, 99));
  for i := 0 to Ord(High(TContourDetail)) do
    ContourDetailComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TContourDetail), i), 3, 99));
  for i := 0 to Ord(High(TGridType)) do
    GridComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TGridType), i), 3, 99));
  for i := 0 to Ord(High(TGridType)) do
    WallTypeComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TGridType), i), 3, 99));
  for i := 0 to Ord(High(TPenStyle)) do
    GridStyleComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPenStyle), i), 3, 99));
  for i := 0 to Ord(High(TPlotType)) do
    PlotTypeComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPlotType), i), 3, 99));
  for i := 0 to Ord(High(TPrinterOrientation)) do
    PrintOrientationComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPrinterOrientation), i), 3, 99));
  {for i := 0 to Ord(High(TPenStyle)) do
    PenStyleComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPenStyle), i), 3, 99));}
  {for i := 0 to 20 do
    PenWidthComboBox.Items.Add(IntToStr(i));}
  {for i := 0 to Ord(High(TBrushStyle)) do
    WallStyleComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TBrushStyle), i), 3, 99));}
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPropertyEditorForm.DoHintsFromResource
  Description: standard loading of Hints from resources
       Author: Mat Ballard
 Date created: 06/25/2001
Date modified: 06/25/2001 by Mat Ballard
      Purpose: display in different languages
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.DoHintsFromResource;
begin
  PlotTypeComboBox.Hint := 'What style of graph is this ?';
  PlotColorEdit.Hint := 'What is the color of the (interior of the) Plot ?';
  BackColorEdit.Hint := 'What is the primary background color ?';
  BackColor2Edit.Hint := 'What is the secondary background color ?' + #13#10 +
    'If this differs from the primary background color, you get a gradient fill';
  BackColorComboBox.Hint := 'What type of colored Background do you want, if any ?';
  GridComboBox.Hint := 'What type of Grid do you want, if any ?';
  GridStyleComboBox.Hint := 'Style of the Grid Lines';
  GridColorEdit.Hint := 'Color of the Grid Lines';
  WallTypeComboBox.Hint := 'What type of colored Wall do you want, if any ?';
  WallColorEdit.Hint := 'Color of the Walls';
  WallColor2Edit.Hint := 'Blend color for the Walls';
  ClickAndDragDelayNEdit.Hint := 'The delay between clicking on an object and it becoming dragable';
  CreatedByEdit.Hint := 'For metafiles';
  //MultiplicityComboBox.Hint := 'How many series are linked together ? (eg: 3 for Hi-Lo-Close)';
  //MultiJoinEdit.Hint := 'Which series are drawn as one large rectangle ? eg: "2,3"';
  ZSeriesLinkCheckBox.Hint := 'Draw lines in the Z directions between adjacent Z Series to make a surface';
  ZSeriesNamesCheckBox.Hint := 'Label the Z Axis with the Series Names';
  //MultiplicityPenGroupBox.Hint := 'The pen used to join points vertically in a ptMultiple type plot';
  ColumnGapNEdit.Hint := 'The percentage gap between adjacent columns';
  ContourGroupBox.Hint := 'Options for Contour Plots';
  ContourDetailComboBox.Hint := 'Use Low or Medium detail for speed, and High for quality - printing and metafiles.';
  ContourIntervalNEdit.Hint := 'Interval between Contour lines (real units)';
  ContourStartNEdit.Hint := 'Start (lowest value) for Contour lines (real units)';
  PolarRangeNEdit.Hint := 'What does 360 degrees correspond to ?';
  ZAxisAngleNEdit.Hint := 'The clockwise angle between the Z Axis and the vertical (Y) Axis';
  ZLengthNEdit.Hint := 'The length of the Z Axis in pixels';
  XYFastAtNEdit.Hint := 'When there are more data points than this, a fast drawing algorithm is used';
  PieRowCountComboBox.Hint := 'How many rows of Pie plots are there ?';
  ApplyBitBtn.Hint := 'Apply these properties now !';
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPropertyEditorForm.CancelBitBtnClick
  Description: Standard ComboBoxChange event handler
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: Disables and enables edit and combo boxes depending on the Plot Type
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.PlotTypeComboBoxClick(Sender: TObject);
begin
  //BubbleSizeNEdit.Visible := FALSE;
  ContourGroupBox.Visible := FALSE;
  ContourIntervalNEdit.Visible := FALSE;
  ContourStartNEdit.Visible := FALSE;
  ContourWireFrameCheckBox.Visible := FALSE;
  ColumnGapNEdit.Visible := FALSE;
  GridLabel.Enabled := FALSE;
  ZSeriesLinkCheckBox.Visible := FALSE;
  ZSeriesNamesCheckBox.Visible := FALSE;
  //MultiplicityComboBox.Visible := FALSE;
  //MultiJoinEdit.Visible := FALSE;
  PieRowCountComboBox.Visible := FALSE;
  PolarRangeNEdit.Visible := FALSE;
  XYFastAtNEdit.Visible := FALSE;
  //ZAxisAngleNEdit.Visible := FALSE;
  ThreeDGroupBox.Visible := FALSE;

  case TPlotType(PlotTypeComboBox.ItemIndex) of
    ptXY:
      begin
        GridLabel.Enabled := TRUE;
        XYFastAtNEdit.Visible := TRUE;
      end;
    ptColumn, ptStack, ptNormStack: ColumnGapNEdit.Visible := TRUE;
    ptPie: PieRowCountComboBox.Visible := TRUE;
    ptPolar: PolarRangeNEdit.Visible := TRUE;
    ptLineContour:
      begin
        ContourGroupBox.Visible := TRUE;
        ContourIntervalNEdit.Visible := TRUE;
        ContourStartNEdit.Visible := TRUE;
      end;
    ptContour:
      begin
        ContourGroupBox.Visible := TRUE;
      end;
    pt3DContour:
      begin
        GridLabel.Enabled := TRUE;
        ContourGroupBox.Visible := TRUE;
        ContourWireFrameCheckBox.Visible := TRUE;
        ThreeDGroupBox.Visible := TRUE;
        ZSeriesNamesCheckBox.Visible := TRUE;
        //ZAxisAngleNEdit.Visible := TRUE;
      end;
    pt3DWire:
      begin
        GridLabel.Enabled := TRUE;
        ThreeDGroupBox.Visible := TRUE;
        //ZAxisAngleNEdit.Visible := TRUE;
        ZSeriesLinkCheckBox.Visible := TRUE;
        ZSeriesNamesCheckBox.Visible := TRUE;
      end;
    pt3DColumn:
      begin
        GridLabel.Enabled := TRUE;
        ColumnGapNEdit.Visible := TRUE;
        ThreeDGroupBox.Visible := TRUE;
        ZSeriesNamesCheckBox.Visible := TRUE;
        //ZAxisAngleNEdit.Visible := TRUE;
      end;
  end;

  ZLengthNEdit.Visible := ZAxisAngleNEdit.Visible;

  //BubbleSizeLabel.Visible := BubbleSizeNEdit.Visible;
  ColumnGapLabel.Visible := ColumnGapNEdit.Visible;
  ContourDetailLabel.Visible := ContourDetailComboBox.Visible;
  ContourIntervalLabel.Visible := ContourIntervalNEdit.Visible;
  ContourStartLabel.Visible := ContourStartNEdit.Visible;
  GridComboBox.Visible := GridLabel.Enabled;
  GridStyleComboBox.Visible := GridLabel.Enabled and (GridComboBox.ItemIndex > 0);
  GridColorEdit.Visible := GridLabel.Enabled and (GridComboBox.ItemIndex > 0);
  WallColorEdit.Visible := (WallTypeComboBox.ItemIndex > 0);
  WallColor2Edit.Visible := (WallTypeComboBox.ItemIndex > 0);
  //WallStyleComboBox.Visible := WallsCheckBox.Checked;
  //MultiplicityLabel.Visible := MultiplicityComboBox.Visible;
  //MultiplicityPenGroupBox.Visible := MultiplicityComboBox.Visible;
  //MultiJoinLabel.Visible := MultiJoinEdit.Visible;
  PieRowCountLabel.Visible := PieRowCountComboBox.Visible;
  PolarRangeLabel.Visible := PolarRangeNEdit.Visible;
  XYFastAtLabel.Visible := XYFastAtNEdit.Visible;
  //ZAxisAngleLabel.Visible := ZAxisAngleNEdit.Visible;
  //ZLengthLabel.Visible := ZAxisAngleNEdit.Visible;
end;

procedure TPlotPropertyEditorForm.FormShow(Sender: TObject);
begin
  PlotTypeComboBoxClick(Self);
end;

procedure TPlotPropertyEditorForm.HelpBitBtnClick(Sender: TObject);
{$IFDEF LINUX}
var
  TheHelpFile: String;
{$ENDIF}
begin
{$IFDEF LINUX}
  TheHelpFile := 'hs' + IntToStr(HelpBitBtn.HelpContext) + '.htm';
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPropertyEditorForm.ApplyBitBtnClick
  Description: Standard ButtonClick event handler
       Author: Mat Ballard
 Date created: 03/28/2001
Date modified: 03/28/2001 by Mat Ballard
      Purpose: Applies the currently selected properties
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.ApplyBitBtnClick(Sender: TObject);
begin
{$IFDEF GUI}
  TPlot(ThePlot).ApplyPropertiesChange(Self);
{$ENDIF}  
end;


procedure TPlotPropertyEditorForm.GridComboBoxChange(Sender: TObject);
begin
  GridStyleComboBox.Visible := (GridComboBox.ItemIndex > 0);
  GridColorEdit.Visible := (GridComboBox.ItemIndex > 0);
end;

procedure TPlotPropertyEditorForm.WallTypeComboBoxChange(Sender: TObject);
begin
  WallColorEdit.Visible := (WallTypeComboBox.ItemIndex > 0);
  WallColor2Edit.Visible := (WallTypeComboBox.ItemIndex > 0);
end;

procedure TPlotPropertyEditorForm.BackColorComboBoxChange(
  Sender: TObject);
begin
  BackColor2Edit.Visible := (BackColorComboBox.ItemIndex > 0);
end;

end.
