unit gd;

{Translation of C:\Users\matb\Delphi\Apps\Trans\gd-2.0.2\gd.h}
{22/10/2002 12:59:48 PM}

interface

uses
  SysUtils, Classes,
  gdWindows,
  gd_io;

const
{$IFDEF WIN32}
  DEFAULT_FONTPATH = '%SystemRoot%\Fonts';
{$ENDIF}
{$IFDEF LINUX}
  DEFAULT_FONTPATH = '/usr/share/fonts/truetype';
{$ENDIF}
  PATHSEPARATOR = ':';
  gdMaxColors = 256;
  gdAlphaMax = 127;
  gdAlphaOpaque = 0;
  gdAlphaTransparent = 127;
  gdRedMax = 255;
  gdGreenMax = 255;
  gdBlueMax = 255;
  gdDashSize = 4;
  gdStyled = (-2);
  gdBrushed = (-3);
  gdStyledBrushed = (-4);
  gdTiled = (-5);
  gdTransparent = (-6);
  //gdImageCreatePalette = gdImageCreate;
  gdArc = 0;
  gdPie = gdArc;
  gdChord = 1;
  gdNoFill = 2;
  gdEdged = 4;
  GD2_CHUNKSIZE = 128;
  GD2_CHUNKSIZE_MIN = 64;
  GD2_CHUNKSIZE_MAX = 4096;
  GD2_VERS = 2;
  GD2_ID = 'gd2';
  GD2_FMT_RAW = 1;
  GD2_FMT_COMPRESSED = 2;
  GD_CMP_IMAGE = 1;    { Actual image IS different }
  GD_CMP_NUM_COLORS = 2;    { Number of Colours in pallette differ }
  GD_CMP_COLOR = 4;    { Image colours differ }
  GD_CMP_SIZE_X = 8;    { Image width differs }
  GD_CMP_SIZE_Y = 16;    { Image heights differ }
  GD_CMP_TRANSPARENT = 32;    { Transparent colour }
  GD_CMP_BACKGROUND = 64;    { Background colour }
  GD_CMP_INTERLACE = 128;    { Interlaced setting }
  GD_CMP_TRUECOLOR = 256;    { Truecolor vs palette differs }
  GD_RESOLUTION = 96;    { pixels per inch }

type
{Simple types:}
  PByte = ^Byte;
  PPByte = ^PByte;
  PInteger = ^Integer;
  PPInteger = ^PInteger;
  //PgdImage = gdImagePtr;
  //PgdFont = gdFontPtr;
  PFile = ^File;
  PWord = ^Word;
  TByteArray = array of Byte;
  PByteArray = ^TByteArray;
  TIntegerArray = array of Integer;
  PIntegerArray = ^TIntegerArray;

{Function Prototypes:}
  TOnsource = procedure(context: Pointer; buffer: PChar; len: Integer);
  TOnsink = procedure(context: Pointer; const buffer: PChar; len: Integer);

{Records:}
  PgdImageStruct = Pointer;
  gdImageStruct = record
    (* Palette-based image pixels *)
    //pixels: PPByte;
    pixels: array of PByteArray;
    sx: Integer;
    sy: Integer;
    (* These are valid in palette images only. See also
    'alpha', which appears later in the structure to
    preserve binary backwards compatibility *)
    colorsTotal: Integer;
    red: array[0..gdMaxColors-1] of Integer;
    green: array[0..gdMaxColors-1] of Integer;
    blue: array[0..gdMaxColors-1] of Integer;
    open: array[0..gdMaxColors-1] of Integer;
    (* For backwards compatibility, this is set to the
    first palette entry with 100% transparency,
    and is also set and reset by the
    gdImageColorTransparent function. Newer
    applications can allocate palette entries
    with any desired level of transparency; however,
    bear in mind that many viewers, notably
    many web browsers, fail to implement
    full alpha channel for PNG and provide
    support for full opacity or transparency only. *)
    transparent: Integer;
    polyInts: PInteger;
    polyAllocated: Integer;
    brush: PgdImageStruct;
    tile: PgdImageStruct;
    brushColorMap: array[0..gdMaxColors-1] of Integer;
    tileColorMap: array[0..gdMaxColors-1] of Integer;
    styleLength: Integer;
    stylePos: Integer;
    style: PInteger;
    interlace: Integer;
    (* New in 2.0: thickness of line. Initialized to 1. *)
    thick: Integer;
    (* New in 2.0: alpha channel for palettes. Note that only
    Macintosh Internet Explorer and (possibly) Netscape 6
    really support multiple levels of transparency in
    palettes, to my knowledge, as of 2/15/01. Most
    common browsers will display 100% opaque and
    100% transparent correctly, and do something
    unpredictable and/or undesirable for levels
    in between. TBB *)
    alpha: array[0..gdMaxColors-1] of Integer;
    (* Truecolor flag and pixels. New 2.0 fields appear here at the
    end to minimize breakage of existing object code. *)
    trueColor: Integer;
    //tpixels: PPInteger;
    tpixels: array of PIntegerArray;
    (* Should alpha channel be copied, or applied, each time a
    pixel is drawn? This applies to truecolor images only.
    No attempt is made to alpha-blend in palette images,
    even if semitransparent palette entries exist.
    To do that, build your image as a truecolor image,
    then quantize down to 8 bits. *)
    alphaBlendingFlag: Integer;
    (* Should the alpha channel of the image be saved? This affects
    PNG at the moment; other future formats may also
    have that capability. JPEG doesn't. *)
    saveAlphaFlag: Integer;
  end;
  {$EXTERNALSYM gdImage}
  gdImage = gdImageStruct;
  TgdImage = gdImage;
  PgdImage = ^gdImage;

  gdFont = record
    (* # of characters in font *)
    nchars: Integer;
    (* First character is numbered... (usually 32 = space) *)
    offset: Integer;
    (* Character width and height *)
    w: Integer;
    h: Integer;
    (* Font data; array of characters, one row after another.
    Easily included in code, also easily loaded from
    data files. *)
    data: PChar;
  end;
  {$EXTERNALSYM gdFont}
  TgdFont = gdFont;
  PgdFont = ^gdFont;

  gdSource = record
    source: TOnsource;
    context: Pointer;
  end;
  {$EXTERNALSYM gdSource}
  TgdSource = gdSource;
  gdSourcePtr = ^TgdSource;
  PgdSource = ^TgdSource;

  gdPoint = record
    x: Integer;
    y: Integer;
  end;
  {$EXTERNALSYM gdPoint}
  TgdPoint = gdPoint;
  gdPointPtr = ^TgdPoint;
  PgdPoint = ^TgdPoint;

    gdSink = record
    sink: TOnsink;
    context: Pointer;
    end;
    {$EXTERNALSYM gdSink}
    TgdSink = gdSink;
    gdSinkPtr = ^TgdSink;
    PgdSink = ^TgdSink;
    

{Macros requiring manual translation:}
  function gdTrueColorGetAlpha(c: Integer): Integer;
  function gdTrueColorGetRed(c: Integer): Integer;
  function gdTrueColorGetGreen(c: Integer): Integer;
  function gdTrueColorGetBlue(c: Integer): Integer;
  function gdTrueColor(r: Integer; g: Integer; b: Integer): Integer;
  function gdTrueColorAlpha(r: Integer; g: Integer; b: Integer; a: Integer): Integer;
  function gdImageTrueColor(im: PgdImage): Integer;
  function gdImageSX(im: PgdImage): Integer;
  function gdImageSY(im: PgdImage): Integer;
  function gdImageColorsTotal(im: PgdImage): Integer;
  function gdImageRed(im: PgdImage; c: Integer): Integer;
  function gdImageGreen(im: PgdImage; c: Integer): Integer;
  function gdImageBlue(im: PgdImage; c: Integer): Integer;
  function gdImageAlpha(im: PgdImage; c: Integer): Integer;
  function gdImageGetTransparent(im: PgdImage): Integer;
  function gdImageGetInterlaced(im: PgdImage): Integer;
  function gdImagePalettePixel(im: PgdImage; x: Integer; y: Integer): Integer;
  function gdImageTrueColorPixel(im: PgdImage; x: Integer; y: Integer): Integer;

{$IFNDEF GD_H}
{$DEFINE GD_H 1}
{$ENDIF}

(* default fontpath for unix systems *)

(* gd.h: declarations file for the graphic-draw module.
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that the above copyright notice appear in all copies and that both that
* copyright notice and this permission notice appear in supporting
* documentation.  This software is provided 'AS IS.' Thomas Boutell and
* Boutell.Com, Inc. disclaim all warranties, either express or implied,
* including but not limited to implied warranties of merchantability and
* fitness for a particular purpose, with respect to this code and accompanying
* documentation. *)
(* stdio is needed for file I/O. *)
(* The maximum number of palette entries in palette-based images.
In the wonderful new world of gd 2.0, you can of course have
many more colors when using truecolor mode. *)
(* Image type. See functions below; you will not need to change
the elements directly. Use the provided macros to
access sx, sy, the color table, and colorsTotal for
read-only purposes. *)
(* If 'truecolor' is set true, the image is truecolor;
pixels are represented by integers, which
must be 32 bits wide or more.
True colors are repsented as follows:
ARGB
Where 'A' (alpha channel) occupies only the
LOWER 7 BITS of the MSB. This very small
loss of alpha channel resolution allows gd 2.x
to keep backwards compatibility by allowing
signed integers to be used to represent colors,
and negative numbers to represent special cases,
just as in gd 1.x. *)
(* This function accepts truecolor pixel values only. The
source color is composited with the destination color
based on the alpha channel value of the source color.
The resulting color is opaque. *)
function gdAlphaBlend(dest: Integer; src: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Text functions take these. *)
(* For backwards compatibility only. Use gdImageSetStyle()
for MUCH more flexible line drawing. Also see
gdImageSetBrush(). *)
(* Special colors. *)
(* NOT the same as the transparent color index.
This is used in line styles only. *)
(* Functions to manipulate images. *)
(* Creates a palette-based image (up to 256 colors). *)
function gdImageCreate(sx: Integer; sy: Integer): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* An alternate name for the above (2.0). *)
(* Creates a truecolor image (millions of colors). *)
function gdImageCreateTrueColor(sx: Integer; sy: Integer): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Creates an image from various file types. These functions
return a palette or truecolor image based on the
nature of the file being loaded. Truecolor PNG
stays truecolor; palette PNG stays palette-based;
JPEG is always truecolor. *)
function gdImageCreateFromPng(fd: PFile): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromPngCtx(inPtr: gdIOCtxPtr): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromWBMP(inFile: PFile): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromWBMPCtx(infile: gdIOCtx): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromJpeg(infile: PFile): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromJpegCtx(infile: gdIOCtx): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* A custom data source. *)
(* The source function must return -1 on error, otherwise the number
of bytes fetched. 0 is EOF, not an error! *)
(* context will be passed to your source function. *)
function gdImageCreateFromPngSource(inPtr: PgdSource): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromGd(inPtr: PFile): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromGdCtx(inPtr: gdIOCtxPtr): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromGd2(inPtr: PFile): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromGd2Ctx(inPtr: gdIOCtxPtr): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromGd2Part(inPtr: PFile; srcx: Integer; srcy: Integer; w: Integer; h: Integer): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromGd2PartCtx(inPtr: gdIOCtxPtr; srcx: Integer; srcy: Integer; w: Integer; h: Integer): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageCreateFromXbm(fd: PFile): PgdImage; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageDestroy(im: PgdImage); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Replaces or blends with the background depending on the
most recent call to gdImageAlphaBlending and the
alpha channel value of 'color'; default is to overwrite.
Tiling and line styling are also implemented
here. All other gd drawing functions pass through this call,
allowing for many useful effects. *)
procedure gdImageSetPixel(im: PgdImage; x: Integer; y: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageGetPixel(im: PgdImage; x: Integer; y: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageLine(im: PgdImage; x1: Integer; y1: Integer; x2: Integer; y2: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* For backwards compatibility only. Use gdImageSetStyle()
for much more flexible line drawing. *)
procedure gdImageDashedLine(im: PgdImage; x1: Integer; y1: Integer; x2: Integer; y2: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Corners specified (not width and height). Upper left first, lower right
second. *)
procedure gdImageRectangle(im: PgdImage; x1: Integer; y1: Integer; x2: Integer; y2: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Solid bar. Upper left corner first, lower right corner second. *)
procedure gdImageFilledRectangle(im: PgdImage; x1: Integer; y1: Integer; x2: Integer; y2: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdImageBoundsSafe(im: PgdImage; x: Integer; y: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageChar(im: PgdImage; f: PgdFont; x: Integer; y: Integer; c: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageCharUp(im: PgdImage; f: PgdFont; x: Integer; y: Integer; c: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageString(im: PgdImage; f: PgdFont; x: Integer; y: Integer; s: PByte; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageStringUp(im: PgdImage; f: PgdFont; x: Integer; y: Integer; s: PByte; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageString16(im: PgdImage; f: PgdFont; x: Integer; y: Integer; s: PWord; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageStringUp16(im: PgdImage; f: PgdFont; x: Integer; y: Integer; s: PWord; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Calls gdImageStringFT. Provided for backwards compatibility only. *)
function gdImageStringTTF(im: PgdImage; brect: PInteger; fg: Integer; fontlist: PChar; ptsize: Double; angle: Double; x: Integer; y: Integer; AString: PChar): PChar; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* FreeType 2 text output *)
function gdImageStringFT(im: PgdImage; brect: PInteger; fg: Integer; fontlist: PChar; ptsize: Double; angle: Double; x: Integer; y: Integer; AString: PChar): PChar; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Point type for use in polygon drawing. *)
procedure gdImagePolygon(im: PgdImage; p: PgdPoint; n: Integer; c: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageFilledPolygon(im: PgdImage; p: PgdPoint; n: Integer; c: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* These functions still work with truecolor images,
for which they never return error. *)
function gdImageColorAllocate(im: PgdImage; r: Integer; g: Integer; b: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* gd 2.0: palette entries with non-opaque transparency are permitted. *)
function gdImageColorAllocateAlpha(im: PgdImage; r: Integer; g: Integer; b: Integer; a: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Assumes opaque is the preferred alpha channel value *)
function gdImageColorClosest(im: PgdImage; r: Integer; g: Integer; b: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Closest match taking all four parameters into account.
A slightly different color with the same transparency
beats the exact same color with radically different
transparency *)
function gdImageColorClosestAlpha(im: PgdImage; r: Integer; g: Integer; b: Integer; a: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Returns exact, 100% opaque matches only *)
function gdImageColorExact(im: PgdImage; r: Integer; g: Integer; b: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Returns an exact match only, including alpha *)
function gdImageColorExactAlpha(im: PgdImage; r: Integer; g: Integer; b: Integer; a: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Opaque only *)
function gdImageColorResolve(im: PgdImage; r: Integer; g: Integer; b: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Based on gdImageColorExactAlpha and gdImageColorClosestAlpha *)
function gdImageColorResolveAlpha(im: PgdImage; r: Integer; g: Integer; b: Integer; a: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* A simpler way to obtain an opaque truecolor value for drawing on a
truecolor image. Not for use with palette images! *)
(* Returns a truecolor value with an alpha channel component.
gdAlphaMax (127, **NOT 255** ) is transparent, 0 is completely
opaque. *)
procedure gdImageColorDeallocate(im: PgdImage; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Converts a truecolor image to a palette-based image,
using a high-quality two-pass quantization routine
which attempts to preserve alpha channel information
as well as R/G/B color information when creating
a palette. If ditherFlag is set, the image will be
dithered to approximate colors better, at the expense
of some obvious 'speckling.' colorsWanted can be
anything up to 256. If the original source image
includes photographic information or anything that
came out of a JPEG, 256 is strongly recommended.
Better yet, don't use this function -- write real
truecolor PNGs and JPEGs. The disk space gain of
conversion to palette is not great (for small images
it can be negative) and the quality loss is ugly. *)
procedure gdImageTrueColorToPalette(im: PgdImage; ditherFlag: Integer; colorsWanted: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Specifies a color index (if a palette image) or an
RGB color (if a truecolor image) which should be
considered 100% transparent. FOR TRUECOLOR IMAGES,
THIS IS IGNORED IF AN ALPHA CHANNEL IS BEING
SAVED. Use gdImageSaveAlpha(im, 0); to
turn off the saving of a full alpha channel in
a truecolor image. Note that gdImageColorTransparent
is usually compatible with older browsers that
do not understand full alpha channels well. TBB *)
procedure gdImageColorTransparent(im: PgdImage; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImagePaletteCopy(dst: PgdImage; src: PgdImage); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImagePng(im: PgdImage; out: PFile); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImagePngCtx(im: PgdImage; out: gdIOCtx); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageWBMP(image: PgdImage; fg: Integer; out: PFile); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageWBMPCtx(image: PgdImage; fg: Integer; out: gdIOCtx); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Guaranteed to correctly free memory returned
by the gdImage*Ptr functions *)
procedure gdFree(m: Pointer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Best to free this memory with gdFree(), not free() *)
function gdImageWBMPPtr(im: PgdImage; size: PInteger; fg: Integer): Pointer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* 100 is highest quality (there is always a little loss with JPEG).
0 is lowest. 10 is about the lowest useful setting. *)
procedure gdImageJpeg(im: PgdImage; out: PFile; quality: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageJpegCtx(im: PgdImage; out: gdIOCtx; quality: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Best to free this memory with gdFree(), not free() *)
function gdImageJpegPtr(im: PgdImage; size: PInteger; quality: Integer): Pointer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* A custom data sink. For backwards compatibility. Use
gdIOCtx instead. *)
(* The sink function must return -1 on error, otherwise the number
of bytes written, which must be equal to len. *)
(* context will be passed to your sink function. *)
procedure gdImagePngToSink(im: PgdImage; out: PgdSink); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageGd(im: PgdImage; out: PFile); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageGd2(im: PgdImage; out: PFile; cs: Integer; fmt: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Best to free this memory with gdFree(), not free() *)
function gdImagePngPtr(im: PgdImage; size: PInteger): Pointer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Best to free this memory with gdFree(), not free() *)
function gdImageGdPtr(im: PgdImage; size: PInteger): Pointer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Best to free this memory with gdFree(), not free() *)
function gdImageGd2Ptr(im: PgdImage; cs: Integer; fmt: Integer; size: PInteger): Pointer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageEllipse(im: PgdImage; cx: Integer; cy: Integer; w: Integer; h: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Style is a bitwise OR ( | operator ) of these.
gdArc and gdChord are mutually exclusive;
gdChord just connects the starting and ending
angles with a straight line, while gdArc produces
a rounded edge. gdPie is a synonym for gdArc.
gdNoFill indicates that the arc or chord should be
outlined, not filled. gdEdged, used together with
gdNoFill, indicates that the beginning and ending
angles should be connected to the center; this is
a good way to outline (rather than fill) a
'pie slice'. *)
procedure gdImageFilledArc(im: PgdImage; cx: Integer; cy: Integer; w: Integer; h: Integer; s: Integer; e: Integer; color: Integer; style: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageArc(im: PgdImage; cx: Integer; cy: Integer; w: Integer; h: Integer; s: Integer; e: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageFilledEllipse(im: PgdImage; cx: Integer; cy: Integer; w: Integer; h: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageFillToBorder(im: PgdImage; x: Integer; y: Integer; border: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageFill(im: PgdImage; x: Integer; y: Integer; color: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageCopy(dst: PgdImage; src: PgdImage; dstX: Integer; dstY: Integer; srcX: Integer; srcY: Integer; w: Integer; h: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageCopyMerge(dst: PgdImage; src: PgdImage; dstX: Integer; dstY: Integer; srcX: Integer; srcY: Integer; w: Integer; h: Integer; pct: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageCopyMergeGray(dst: PgdImage; src: PgdImage; dstX: Integer; dstY: Integer; srcX: Integer; srcY: Integer; w: Integer; h: Integer; pct: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Stretches or shrinks to fit, as needed. Does NOT attempt
to average the entire set of source pixels that scale down onto the
destination pixel. *)
procedure gdImageCopyResized(dst: PgdImage; src: PgdImage; dstX: Integer; dstY: Integer; srcX: Integer; srcY: Integer; dstW: Integer; dstH: Integer; srcW: Integer; srcH: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* gd 2.0: stretches or shrinks to fit, as needed. When called with a
truecolor destination image, this function averages the
entire set of source pixels that scale down onto the
destination pixel, taking into account what portion of the
destination pixel each source pixel represents. This is a
floating point operation, but this is not a performance issue
on modern hardware, except for some embedded devices. If the
destination is a palette image, gdImageCopyResized is
substituted automatically. *)
procedure gdImageCopyResampled(dst: PgdImage; src: PgdImage; dstX: Integer; dstY: Integer; srcX: Integer; srcY: Integer; dstW: Integer; dstH: Integer; srcW: Integer; srcH: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageSetBrush(im: PgdImage; brush: PgdImage); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageSetTile(im: PgdImage; tile: PgdImage); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageSetStyle(im: PgdImage; style: PInteger; noOfPixels: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Line thickness (defaults to 1). Affects lines, ellipses,
rectangles, polygons and so forth. *)
procedure gdImageSetThickness(im: PgdImage; thickness: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* On or off (1 or 0) for all three of these. *)
procedure gdImageInterlace(im: PgdImage; interlaceArg: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageAlphaBlending(im: PgdImage; alphaBlendingArg: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
procedure gdImageSaveAlpha(im: PgdImage; saveAlphaArg: Integer); cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Macros to access information about images. *)
(* Returns nonzero if the image is a truecolor image,
zero for a palette image. *)
(* These macros provide direct access to pixels in
palette-based and truecolor images, respectively.
If you use these macros, you must perform your own
bounds checking. Use of the macro for the correct type
of image is also your responsibility. *)
(* I/O Support routines. *)
function gdNewFileCtx(AFile: PFile): PgdIOCtx; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdNewDynamicCtx(Value: Integer; ptr: Pointer): PgdIOCtx; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdNewSSCtx(inPtr: gdSourcePtr; outPtr: gdSinkPtr): PgdIOCtx; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
function gdDPExtractData(ctx: PgdIOCtx; psize: PInteger): Pointer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* Image comparison definitions *)
function gdImageCompare(im1: PgdImage; im2: PgdImage): Integer; cdecl; external {$IFDEF WIN32}'gd.dll'{$ENDIF}{$IFDEF LINUX}'libgd.so'{$ENDIF};
(* resolution affects ttf font rendering, particularly hinting *)

{==============================================================================}
implementation
{First, the translated Macros:}

function gdTrueColorGetAlpha(c: Integer): Integer;
begin
  Result :=  (((c) and $7F000000) shr 24);
end;

function gdTrueColorGetRed(c: Integer): Integer;
begin
  Result :=  (((c) and $FF0000) shr 16);
end;

function gdTrueColorGetGreen(c: Integer): Integer;
begin
  Result :=  (((c) and $00FF00) shr 8);
end;

function gdTrueColorGetBlue(c: Integer): Integer;
begin
  Result :=  ((c) and $0000FF);
end;

function gdTrueColor(r: Integer; g: Integer; b: Integer): Integer;
begin
  Result :=  (((r) shl 16) +  ((g) shl 8) +  (b));
end;

function gdTrueColorAlpha(r: Integer; g: Integer; b: Integer; a: Integer): Integer;
begin
  Result :=  (((a) shl 24) +  ((r) shl 16) +  ((g) shl 8) +  (b));
end;

function gdImageTrueColor(im: PgdImage): Integer;
begin
  Result := im^.trueColor;
end;

function gdImageSX(im: PgdImage): Integer;
begin
  Result :=  im^.sx;
end;

function gdImageSY(im: PgdImage): Integer;
begin
  Result :=  im^.sy;
end;

function gdImageColorsTotal(im: PgdImage): Integer;
begin
  Result :=  im^.colorsTotal;
end;

function gdImageRed(im: PgdImage; c: Integer): Integer;
begin
  //Result :=  im^.trueColor ? gdTrueColorGetRed(c) :  (im)->red[(c)]);
  if (im^.trueColor = 0) then
    Result := im^.red[c]
   else
    Result := gdTrueColorGetRed(c);
end;

function gdImageGreen(im: PgdImage; c: Integer): Integer;
begin
  if (im^.trueColor = 0) then
    Result := im^.green[c]
   else
    Result := gdTrueColorGetGreen(c);
end;

function gdImageBlue(im: PgdImage; c: Integer): Integer;
begin
  if (im^.trueColor = 0) then
    Result := im^.blue[c]
   else
    Result := gdTrueColorGetBlue(c);
end;

function gdImageAlpha(im: PgdImage; c: Integer): Integer;
begin
  if (im^.trueColor = 0) then
    Result := im^.alpha[c]
   else
    Result := gdTrueColorGetAlpha(c);
end;

function gdImageGetTransparent(im: PgdImage): Integer;
begin
  Result :=  im^.transparent;
end;

function gdImageGetInterlaced(im: PgdImage): Integer;
begin
  Result :=  im^.interlace;
end;

function gdImagePalettePixel(im: PgdImage; x: Integer; y: Integer): Integer;
begin
  Result :=  im^.pixels[y]^[x];
end;

function gdImageTrueColorPixel(im: PgdImage; x: Integer; y: Integer): Integer;
begin
  Result :=  im^.tpixels[y]^[x];
end;

begin
end.

