unit gdWinapi;

{This file contains the Windows functions needed by gdGraphics, re-implemented
 to call the gd API instead of the Windows API.}

interface

uses
  SysUtils, Classes,
  gdWindows,
  gd;

  function GetLastError: DWORD;
  function FormatMessage(dwFlags: DWORD; lpSource: Pointer; dwMessageId: DWORD; dwLanguageId: DWORD;
    lpBuffer: PChar; nSize: DWORD; Arguments: Pointer): DWORD;
  function GetSystemMetrics(nIndex: Integer): Integer;
  procedure InitializeCriticalSection(var lpCriticalSection: TRTLCriticalSection);
  procedure DeleteCriticalSection(var lpCriticalSection: TRTLCriticalSection);
  procedure EnterCriticalSection(var lpCriticalSection: TRTLCriticalSection);
  procedure LeaveCriticalSection(var lpCriticalSection: TRTLCriticalSection);
  function GetSysColor(nIndex: Integer): DWORD;
  function DeleteObject(p1: HGDIOBJ): BOOL;
  function GetObject(p1: HGDIOBJ; p2: Integer; p3: Pointer): Integer;
  function GetStockObject(Index: Integer): HGDIOBJ;
  function CreateFontIndirect(const p1: TLogFont): HFONT;
  function MulDiv(nNumber, nNumerator, nDenominator: Integer): Integer;
  function CreatePenIndirect(const LogPen: TLogPen): HPEN;
  function CreateBrushIndirect(const p1: TLogBrush): HBRUSH;
  function CreateCompatibleDC(DC: HDC): HDC;
  function GetDC(hWnd: HWND): HDC;
  function ReleaseDC(hWnd: HWND; hDC: HDC): Integer;
  function DeleteDC(DC: HDC): BOOL;
  function GetDeviceCaps(DC: HDC; Index: Integer): Integer;
  function SelectObject(DC: HDC; p2: HGDIOBJ): HGDIOBJ;
  function StretchBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
    XSrc, YSrc, SrcWidth, SrcHeight: Integer; Rop: DWORD): BOOL;
  function SetTextColor(DC: HDC; Color: COLORREF): COLORREF;
  function SetBkColor(DC: HDC; Color: COLORREF): COLORREF;
  function SetBkMode(DC: HDC; BkMode: Integer): Integer;
  function SelectPalette(DC: HDC; Palette: HPALETTE;
    ForceBackground: Bool): HPALETTE;
  function RealizePalette(DC: HDC): UINT;
  function GetWindowOrgEx(DC: HDC; var Point: TPoint): BOOL;
  function GetClipBox(DC: HDC; var Rect: TRect): Integer;
  function SetROP2(DC: HDC; p2: Integer): Integer;
  function UnrealizeObject(hGDIObj: HGDIOBJ): BOOL;
  function CreateBitmap(Width, Height: Integer; Planes, BitCount: Longint;
    Bits: Pointer): HBITMAP;
  function CreateCompatibleBitmap(DC: HDC; Width, Height: Integer): HBITMAP;
  function CreateDIBitmap(DC: HDC; var InfoHeader: TBitmapInfoHeader;
    dwUsage: DWORD; InitBits: PChar; var InitInfo: TBitmapInfo;
    wUsage: UINT): HBITMAP;
  function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
    Bits: Pointer; var BitInfo: TBitmapInfo; Usage: UINT): Integer;
  function StretchDIBits(DC: HDC; DestX, DestY, DestWidth, DestHegiht, SrcX,
    SrcY, SrcWidth, SrcHeight: Integer; Bits: Pointer; var BitsInfo: TBitmapInfo;
    Usage: UINT; Rop: DWORD): Integer;
  function GetBitmapBits(Bitmap: HBITMAP; Count: Longint;
    Bits: Pointer): Longint;
  function CreateIcon(hInstance: HINST; nWidth, nHeight: Integer;
    cPlanes, cBitsPixel: Byte; lpbANDbits, lpbXORbits: Pointer): HICON;
  function LoadIcon(hInstance: HINST; lpIconName: PChar): HICON;
  function MaskBlt(DC: HDC; p2, p3, p4, p5: Integer; p6: HDC;
    p7, p8: Integer; p9: HBITMAP; p10, p11: Integer; p12: DWORD): BOOL; 
  function MakeROP4(fore,back: DWORD): DWORD;
  function CreatePalette(const LogPalette: TLogPalette): HPalette;
  function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
    var PaletteEntries): UINT;
  function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
    var PaletteEntries): UINT;
  function CreateDIBSection(DC: HDC; const p2: TBitmapInfo; p3: UINT;
    var p4: Pointer; p5: THandle; p6: DWORD): HBITMAP;
  function GetDIBColorTable(DC: HDC; p2, p3: UINT; var RGBQuadStructs): UINT;
  function SetDIBColorTable(DC: HDC; p2, p3: UINT; var RGBQuadSTructs): UINT;
  function GetIconInfo(hIcon: HICON; var piconinfo: TIconInfo): BOOL;
  function DeleteEnhMetaFile(p1: HENHMETAFILE): BOOL;
  function CopyEnhMetaFile(p1: HENHMETAFILE; p2: PChar): HENHMETAFILE;
  function CreateEnhMetaFile(DC: HDC; p2: PChar; p3: PRect; p4: PChar): HDC;
  function CloseEnhMetaFile(DC: HDC): HENHMETAFILE;
  function GetEnhMetaFileBits(p1: HENHMETAFILE; p2: UINT; p3: PByte): UINT;
  function GetEnhMetaFileDescription(p1: HENHMETAFILE; p2: UINT; p3: PChar): UINT;
  function GetEnhMetaFileHeader(p1: HENHMETAFILE; p2: UINT; p3: PEnhMetaHeader): UINT;
  function GetEnhMetaFilePaletteEntries(p1: HENHMETAFILE; p2: UINT; p3: Pointer): UINT;
  function GetWinMetaFileBits(p1: HENHMETAFILE; p2: UINT; p3: PByte;
    p4: Integer; p5: HDC): UINT;
  function PlayEnhMetaFile(DC: HDC; p2: HENHMETAFILE; const p3: TRect): BOOL;
  function SetEnhMetaFileBits(p1: UINT; p2: PChar): HENHMETAFILE;
  function SetWinMetaFileBits(p1: UINT; p2: PChar; p3: HDC;
    const p4: TMetaFilePict): HENHMETAFILE;
  function GetClipboardData(uFormat: UINT): THandle;
  function CloseHandle(hObject: THandle): BOOL;
  function FindResource(hModule: HMODULE; lpName, lpType: PChar): HRSRC;
  function LoadResource(hModule: HINST; hResInfo: HRSRC): HGLOBAL;
  function FreeResource(hResData: HGLOBAL): BOOL; stdcall;
  function LockResource(hResData: HGLOBAL): Pointer; stdcall;
  function UnlockResource(hResData: THandle): BOOL;
  function FillRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer;
  function PatBlt(DC: HDC; X, Y, Width, Height: Integer; Rop: DWORD): BOOL;
  function BitBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
    XSrc, YSrc: Integer; Rop: DWORD): BOOL;
  function GetBrushOrgEx(DC: HDC; var p2: TPoint): BOOL;
  function SetBrushOrgEx(DC: HDC; X, Y: Integer; PrevPt: PPoint): BOOL;
  function SetStretchBltMode(DC: HDC; p2: Integer): Integer;
  function GdiFlush: BOOL;
  function CreateHalftonePalette(DC: HDC): HPALETTE;
  function DestroyIcon(hIcon: HICON): BOOL;
  function DrawIconEx(hdc: HDC; xLeft, yTop: Integer; hIcon: HICON;
    cxWidth, cyWidth: Integer; istepIfAniCur: UINT;
    hbrFlickerFreeDraw: HBRUSH; diFlags: UINT): BOOL;
  function CopyIcon(hIcon: HICON): HICON;
  function GetTextMetrics(DC: HDC; var TM: TTextMetric): BOOL;

{==============================================================================}
implementation
{First, all the re-implemented Windows GDI functions:}
function GetLastError: DWORD;
begin
  Result := 0;
end;

function FormatMessage(dwFlags: DWORD; lpSource: Pointer; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: PChar; nSize: DWORD; Arguments: Pointer): DWORD; 
begin
  Result := 16;
  StrCopy(lpBuffer, 'Unknown gd error');
end;

function GetSystemMetrics(nIndex: Integer): Integer;
begin
  Result := 0;
end;

procedure InitializeCriticalSection(var lpCriticalSection: TRTLCriticalSection);
begin
end;

procedure DeleteCriticalSection(var lpCriticalSection: TRTLCriticalSection);
begin
end;

procedure EnterCriticalSection(var lpCriticalSection: TRTLCriticalSection);
begin
end;

procedure LeaveCriticalSection(var lpCriticalSection: TRTLCriticalSection);
begin
end;

function GetSysColor(nIndex: Integer): DWORD;
begin
  case nIndex of
    0: Result := 13160660;
    1: Result := 0;
    2: Result := 6956042;
    3: Result := 8421504;
    4: Result := 13160660;
    5: Result := 16777215;
    6: Result := 0;
    7: Result := 0;
    8: Result := 0;
    9: Result := 16777215;
    10: Result := 13160660;
    11: Result := 13160660;
    12: Result := 8421504;
    13: Result := 6956042;
    14: Result := 16777215;
    15: Result := 13160660;
    16: Result := 8421504;
    17: Result := 8421504;
    18: Result := 0;
    19: Result := 13160660;
    20: Result := 16777215;
    21: Result := 4210752;
    22: Result := 13160660;
    23: Result := 0;
    24: Result := 14811135;
    25: Result := 11908533;
    26: Result := 16711680;
    27: Result := 15780518;
    28: Result := 12632256;
  else
    Result := 0;  
  end;
end;

function DeleteObject(p1: HGDIOBJ): BOOL;
begin
  Result := TRUE;
end;

function GetObject(p1: HGDIOBJ; p2: Integer; p3: Pointer): Integer;
begin
  Result := 0;
end;

function GetStockObject(Index: Integer): HGDIOBJ;
begin
  Result := 0;
end;

function CreateFontIndirect(const p1: TLogFont): HFONT;
begin
  Result := 0;
end;

function MulDiv(nNumber, nNumerator, nDenominator: Integer): Integer;
var
  a, b, c: Int64;
begin
  a := nNumber;
  b := nNumerator;
  c := nDenominator;
  a := a * b div c;
  Result := Integer(a);
end;

function CreatePenIndirect(const LogPen: TLogPen): HPEN;
begin
  Result := 0;
end;

function CreateBrushIndirect(const p1: TLogBrush): HBRUSH;
begin
  Result := 0;
end;

function CreateCompatibleDC(DC: HDC): HDC;
begin
  Result := 0;
end;

function GetDC(hWnd: HWND): HDC;
begin
  Result := 0;
end;

function ReleaseDC(hWnd: HWND; hDC: HDC): Integer;
begin
  Result := 0;
end;

function DeleteDC(DC: HDC): BOOL;
begin
  Result := FALSE;
end;

function GetDeviceCaps(DC: HDC; Index: Integer): Integer;
begin
  Result := 0;
end;

function SelectObject(DC: HDC; p2: HGDIOBJ): HGDIOBJ;
begin
  Result := 0;
end;

function StretchBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
  XSrc, YSrc, SrcWidth, SrcHeight: Integer; Rop: DWORD): BOOL;
begin
  Result := FALSE;
end;

function SetTextColor(DC: HDC; Color: COLORREF): COLORREF;
begin
  Result := 0;
end;

function SetBkColor(DC: HDC; Color: COLORREF): COLORREF;
begin
  Result := 0;
end;

function SetBkMode(DC: HDC; BkMode: Integer): Integer;
begin
  Result := 0;
end;

function SelectPalette(DC: HDC; Palette: HPALETTE;
  ForceBackground: Bool): HPALETTE;
begin
  Result := 0;
end;

function RealizePalette(DC: HDC): UINT;
begin
  Result := 0;
end;

function GetWindowOrgEx(DC: HDC; var Point: TPoint): BOOL;
begin
  Result := FALSE;
end;

function GetClipBox(DC: HDC; var Rect: TRect): Integer;
begin
  Result := 0;
end;

function SetROP2(DC: HDC; p2: Integer): Integer;
begin
  Result := 0;
end;

function UnrealizeObject(hGDIObj: HGDIOBJ): BOOL;
begin
  Result := FALSE;
end;

function CreateBitmap(Width, Height: Integer; Planes, BitCount: Longint;
  Bits: Pointer): HBITMAP;
begin
  Result := 0;
end;

function CreateCompatibleBitmap(DC: HDC; Width, Height: Integer): HBITMAP;
begin
  Result := 0;
end;

function CreateDIBitmap(DC: HDC; var InfoHeader: TBitmapInfoHeader;
  dwUsage: DWORD; InitBits: PChar; var InitInfo: TBitmapInfo;
  wUsage: UINT): HBITMAP;
begin
  Result := 0;
end;

function GetDIBits(DC: HDC; Bitmap: HBitmap; StartScan, NumScans: UINT;
  Bits: Pointer; var BitInfo: TBitmapInfo; Usage: UINT): Integer;
begin
  Result := 0;
end;

function StretchDIBits(DC: HDC; DestX, DestY, DestWidth, DestHegiht, SrcX,
  SrcY, SrcWidth, SrcHeight: Integer; Bits: Pointer; var BitsInfo: TBitmapInfo;
  Usage: UINT; Rop: DWORD): Integer;
begin
  Result := 0;
end;

function GetBitmapBits(Bitmap: HBITMAP; Count: Longint;
  Bits: Pointer): Longint;
begin
  Result := 0;
end;

function CreateIcon(hInstance: HINST; nWidth, nHeight: Integer;
  cPlanes, cBitsPixel: Byte; lpbANDbits, lpbXORbits: Pointer): HICON;
begin
  Result := 0;
end;

function LoadIcon(hInstance: HINST; lpIconName: PChar): HICON;
begin
  Result := 0;
end;

function MaskBlt(DC: HDC; p2, p3, p4, p5: Integer; p6: HDC;
  p7, p8: Integer; p9: HBITMAP; p10, p11: Integer; p12: DWORD): BOOL;
begin
  Result := FALSE;
end;

function MakeROP4(fore,back: DWORD): DWORD;
begin
  Result := 0;
end;

function CreatePalette(const LogPalette: TLogPalette): HPalette;
begin
  Result := 0;
end;

function GetPaletteEntries(Palette: HPALETTE; StartIndex, NumEntries: UINT;
  var PaletteEntries): UINT;
begin
  Result := 0;
end;

function GetSystemPaletteEntries(DC: HDC; StartIndex, NumEntries: UINT;
  var PaletteEntries): UINT;
begin
  Result := 0;
end;

function CreateDIBSection(DC: HDC; const p2: TBitmapInfo; p3: UINT;
  var p4: Pointer; p5: THandle; p6: DWORD): HBITMAP; 
begin
  Result := 0;
end;

function GetDIBColorTable(DC: HDC; p2, p3: UINT; var RGBQuadStructs): UINT;
begin
  Result := 0;
end;

function SetDIBColorTable(DC: HDC; p2, p3: UINT; var RGBQuadSTructs): UINT;
begin
  Result := 0;
end;

function GetIconInfo(hIcon: HICON; var piconinfo: TIconInfo): BOOL;
begin
  Result := FALSE;
end;

function DeleteEnhMetaFile(p1: HENHMETAFILE): BOOL;
begin
  Result := FALSE;
end;

function CopyEnhMetaFile(p1: HENHMETAFILE; p2: PChar): HENHMETAFILE;
begin
  Result := 0;
end;

function CreateEnhMetaFile(DC: HDC; p2: PChar; p3: PRect; p4: PChar): HDC;
begin
  Result := 0;
end;

function CloseEnhMetaFile(DC: HDC): HENHMETAFILE;
begin
  Result := 0;
end;

function GetEnhMetaFileBits(p1: HENHMETAFILE; p2: UINT; p3: PByte): UINT;
begin
  Result := 0;
end;

function GetEnhMetaFileDescription(p1: HENHMETAFILE; p2: UINT; p3: PChar): UINT;
begin
  Result := 0;
end;

function GetEnhMetaFileHeader(p1: HENHMETAFILE; p2: UINT; p3: PEnhMetaHeader): UINT;
begin
  Result := 0;
end;

function GetEnhMetaFilePaletteEntries(p1: HENHMETAFILE; p2: UINT; p3: Pointer): UINT;
begin
  Result := 0;
end;

function GetWinMetaFileBits(p1: HENHMETAFILE; p2: UINT; p3: PByte;
  p4: Integer; p5: HDC): UINT;
begin
  Result := 0;
end;

function PlayEnhMetaFile(DC: HDC; p2: HENHMETAFILE; const p3: TRect): BOOL;
begin
  Result := FALSE;
end;

function SetEnhMetaFileBits(p1: UINT; p2: PChar): HENHMETAFILE;
begin
  Result := 0;
end;

function SetWinMetaFileBits(p1: UINT; p2: PChar; p3: HDC;
  const p4: TMetaFilePict): HENHMETAFILE;
begin
  Result := 0;
end;

function GetClipboardData(uFormat: UINT): THandle;
begin
  Result := 0;
end;

function CloseHandle(hObject: THandle): BOOL;
begin
  Result := FALSE;
end;

function FindResource(hModule: HMODULE; lpName, lpType: PChar): HRSRC;
begin // NB: lpType is from an MakeIntResource
  Result := 0;
end;

function LoadResource(hModule: HINST; hResInfo: HRSRC): HGLOBAL;
begin
  Result := 0;
end;

function FreeResource(hResData: HGLOBAL): BOOL;
begin
  Result := FALSE;
end;

function LockResource(hResData: HGLOBAL): Pointer;
begin
  Result := nil;
end;

function UnlockResource(hResData: THandle): BOOL;
begin
  Result := FALSE;
end;

function FillRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer;
begin
  Result := 0;
end;

function PatBlt(DC: HDC; X, Y, Width, Height: Integer; Rop: DWORD): BOOL;
begin
  Result := FALSE;
end;

function BitBlt(DestDC: HDC; X, Y, Width, Height: Integer; SrcDC: HDC;
  XSrc, YSrc: Integer; Rop: DWORD): BOOL;
begin
  Result := FALSE;
end;

function GetBrushOrgEx(DC: HDC; var p2: TPoint): BOOL;
begin
  Result := FALSE;
end;

function SetBrushOrgEx(DC: HDC; X, Y: Integer; PrevPt: PPoint): BOOL;
begin
  Result := FALSE;
end;

function SetStretchBltMode(DC: HDC; p2: Integer): Integer;
begin
  Result := 0;
end;

function GdiFlush: BOOL;
begin
  Result := FALSE;
end;

function CreateHalftonePalette(DC: HDC): HPALETTE;
begin
  Result := 0;
end;

function DestroyIcon(hIcon: HICON): BOOL;
begin
  Result := FALSE;
end;

function DrawIconEx(hdc: HDC; xLeft, yTop: Integer; hIcon: HICON;
  cxWidth, cyWidth: Integer; istepIfAniCur: UINT;
  hbrFlickerFreeDraw: HBRUSH; diFlags: UINT): BOOL;
begin
  Result := FALSE;
end;

function CopyIcon(hIcon: HICON): HICON;
begin
  Result := 0;
end;

function GetTextMetrics(DC: HDC; var TM: TTextMetric): BOOL;
begin
  Result := FALSE;
end;



end.

