unit gdWindows;

{This file contains the Windows constants and types needed by gdGraphics to
 to call the gd API instead of the Windows API.}

interface

type
  DWORD = LongWord;
  
const
  { Logical Font }
  LF_FACESIZE = 32;

  VER_PLATFORM_WIN32s = 0;
  VER_PLATFORM_WIN32_WINDOWS = 1;
  VER_PLATFORM_WIN32_NT = 2;

  LANG_NEUTRAL                         = $00;
  SUBLANG_NEUTRAL                      = $00;    { language neutral }
  SUBLANG_DEFAULT                      = $01;    { user default }
  SUBLANG_SYS_DEFAULT                  = $02;    { system default }
  SORT_DEFAULT                         = $0;     { sorting default }

  LANG_SYSTEM_DEFAULT   = (SUBLANG_SYS_DEFAULT shl 10) or LANG_NEUTRAL;
  LANG_USER_DEFAULT     = (SUBLANG_DEFAULT shl 10) or LANG_NEUTRAL;

  LOCALE_SYSTEM_DEFAULT = (SORT_DEFAULT shl 16) or LANG_SYSTEM_DEFAULT;
  LOCALE_USER_DEFAULT   = (SORT_DEFAULT shl 16) or LANG_USER_DEFAULT;

  FORMAT_MESSAGE_ALLOCATE_BUFFER = $100;
  FORMAT_MESSAGE_IGNORE_INSERTS = $200;
  FORMAT_MESSAGE_FROM_STRING = $400;
  FORMAT_MESSAGE_FROM_HMODULE = $800;
  FORMAT_MESSAGE_FROM_SYSTEM = $1000;
  FORMAT_MESSAGE_ARGUMENT_ARRAY = $2000;
  FORMAT_MESSAGE_MAX_WIDTH_MASK = 255;

  { Color Types }
  CTLCOLOR_MSGBOX = 0;
  CTLCOLOR_EDIT = 1;
  CTLCOLOR_LISTBOX = 2;
  CTLCOLOR_BTN = 3;
  CTLCOLOR_DLG = 4;
  CTLCOLOR_SCROLLBAR = 5;
  CTLCOLOR_STATIC = 6;
  CTLCOLOR_MAX = 7;

  COLOR_SCROLLBAR = 0;
  COLOR_BACKGROUND = 1;
  COLOR_ACTIVECAPTION = 2;
  COLOR_INACTIVECAPTION = 3;
  COLOR_MENU = 4;
  COLOR_WINDOW = 5;
  COLOR_WINDOWFRAME = 6;
  COLOR_MENUTEXT = 7;
  COLOR_WINDOWTEXT = 8;
  COLOR_CAPTIONTEXT = 9;
  COLOR_ACTIVEBORDER = 10;
  COLOR_INACTIVEBORDER = 11;
  COLOR_APPWORKSPACE = 12;
  COLOR_HIGHLIGHT = 13;
  COLOR_HIGHLIGHTTEXT = 14;
  COLOR_BTNFACE = 15;
  COLOR_BTNSHADOW = $10;
  COLOR_GRAYTEXT = 17;
  COLOR_BTNTEXT = 18;
  COLOR_INACTIVECAPTIONTEXT = 19;
  COLOR_BTNHIGHLIGHT = 20;

  COLOR_3DDKSHADOW = 21;
  COLOR_3DLIGHT = 22;
  COLOR_INFOTEXT = 23;
  COLOR_INFOBK = 24;
  COLOR_HOTLIGHT = 26;
  COLOR_GRADIENTACTIVECAPTION = 27;
  COLOR_GRADIENTINACTIVECAPTION = 28;
  COLOR_ENDCOLORS = COLOR_GRADIENTINACTIVECAPTION;
  COLOR_DESKTOP = COLOR_BACKGROUND;
  COLOR_3DFACE = COLOR_BTNFACE;
  COLOR_3DSHADOW = COLOR_BTNSHADOW;
  COLOR_3DHIGHLIGHT = COLOR_BTNHIGHLIGHT;
  COLOR_3DHILIGHT = COLOR_BTNHIGHLIGHT;
  COLOR_BTNHILIGHT = COLOR_BTNHIGHLIGHT;

  { Device Parameters for GetDeviceCaps() }
  DRIVERVERSION = 0;     { Device driver version                     }
  TECHNOLOGY    = 2;     { Device classification                     }
  HORZSIZE      = 4;     { Horizontal size in millimeters            }
  VERTSIZE      = 6;     { Vertical size in millimeters              }
  HORZRES       = 8;     { Horizontal width in pixels                }
  VERTRES       = 10;    { Vertical height in pixels                 }
  BITSPIXEL     = 12;    { Number of bits per pixel                  }
  PLANES        = 14;    { Number of planes                          }
  NUMBRUSHES    = $10;   { Number of brushes the device has          }
  NUMPENS       = 18;    { Number of pens the device has             }
  NUMMARKERS    = 20;    { Number of markers the device has          }
  NUMFONTS      = 22;    { Number of fonts the device has            }
  NUMCOLORS     = 24;    { Number of colors the device supports      }
  PDEVICESIZE   = 26;    { Size required for device descriptor       }
  CURVECAPS     = 28;    { Curve capabilities                        }
  LINECAPS      = 30;    { Line capabilities                         }
  POLYGONALCAPS = $20;   { Polygonal capabilities                    }
  TEXTCAPS      = 34;    { Text capabilities                         }
  CLIPCAPS      = 36;    { Clipping capabilities                     }
  RASTERCAPS    = 38;    { Bitblt capabilities                       }
  ASPECTX       = 40;    { Length of the X leg                       }
  ASPECTY       = 42;    { Length of the Y leg                       }
  ASPECTXY      = 44;    { Length of the hypotenuse                  }
  SHADEBLENDCAPS = 45;   { Shading and Blending caps                 }

  LOGPIXELSX    = 88;    { Logical pixelsinch in X                  }
  LOGPIXELSY    = 90;    { Logical pixelsinch in Y                  }

  SIZEPALETTE   = 104;   { Number of entries in physical palette     }
  NUMRESERVED   = 106;   { Number of reserved entries in palette     }
  COLORRES      = 108;   { Actual color resolution                   }

  { constants for the biCompression field }
  BI_RGB = 0;
  BI_RLE8 = 1;
  BI_RLE4 = 2;
  BI_BITFIELDS = 3;

{ DIB color table identifiers }
  DIB_RGB_COLORS = 0;     { color table in RGBs  }
  DIB_PAL_COLORS = 1;     { color table in palette indices  }

{ constants for CreateDIBitmap }
  CBM_INIT = 4;     { initialize bitmap  }

  { Background Modes }
  TRANSPARENT = 1;
  OPAQUE = 2;
  BKMODE_LAST = 2;

  { Binary raster ops }
  R2_BLACK       = 1;     {  0   }
  R2_NOTMERGEPEN = 2;     { DPon }
  R2_MASKNOTPEN  = 3;     { DPna }
  R2_NOTCOPYPEN  = 4;     { PN   }
  R2_MASKPENNOT  = 5;     { PDna }
  R2_NOT         = 6;     { Dn   }
  R2_XORPEN      = 7;     { DPx  }
  R2_NOTMASKPEN  = 8;     { DPan }
  R2_MASKPEN     = 9;     { DPa  }
  R2_NOTXORPEN   = 10;    { DPxn }
  R2_NOP         = 11;    { D    }
  R2_MERGENOTPEN = 12;    { DPno }
  R2_COPYPEN     = 13;    { P    }
  R2_MERGEPENNOT = 14;    { PDno }
  R2_MERGEPEN    = 15;    { DPo  }
  R2_WHITE       = $10;   {  1   }
  R2_LAST        = $10;

  { Ternary raster operations }
  SRCCOPY     = $00CC0020;     { dest = source                    }
  SRCPAINT    = $00EE0086;     { dest = source OR dest            }
  SRCAND      = $008800C6;     { dest = source AND dest           }
  SRCINVERT   = $00660046;     { dest = source XOR dest           }
  SRCERASE    = $00440328;     { dest = source AND (NOT dest )    }
  NOTSRCCOPY  = $00330008;     { dest = (NOT source)              }
  NOTSRCERASE = $001100A6;     { dest = (NOT src) AND (NOT dest)  }
  MERGECOPY   = $00C000CA;     { dest = (source AND pattern)      }
  MERGEPAINT  = $00BB0226;     { dest = (NOT source) OR dest      }
  PATCOPY     = $00F00021;     { dest = pattern                   }
  PATPAINT    = $00FB0A09;     { dest = DPSnoo                    }
  PATINVERT   = $005A0049;     { dest = pattern XOR dest          }
  DSTINVERT   = $00550009;     { dest = (NOT dest)                }
  BLACKNESS   = $00000042;     { dest = BLACK                     }
  WHITENESS   = $00FF0062;     { dest = WHITE                     }

  OUT_DEFAULT_PRECIS = 0;
  OUT_STRING_PRECIS = 1;
  OUT_CHARACTER_PRECIS = 2;
  OUT_STROKE_PRECIS = 3;
  OUT_TT_PRECIS = 4;
  OUT_DEVICE_PRECIS = 5;
  OUT_RASTER_PRECIS = 6;
  OUT_TT_ONLY_PRECIS = 7;
  OUT_OUTLINE_PRECIS = 8;
  OUT_SCREEN_OUTLINE_PRECIS = 9;

  CLIP_DEFAULT_PRECIS = 0;
  CLIP_CHARACTER_PRECIS = 1;
  CLIP_STROKE_PRECIS = 2;
  CLIP_MASK = 15;
  CLIP_LH_ANGLES = (1 shl 4);
  CLIP_TT_ALWAYS = (2 shl 4);
  CLIP_EMBEDDED  = (8 shl 4);

  DEFAULT_QUALITY = 0;
  DRAFT_QUALITY = 1;
  PROOF_QUALITY = 2;
  NONANTIALIASED_QUALITY = 3;
  ANTIALIASED_QUALITY = 4;

  DEFAULT_PITCH = 0;
  FIXED_PITCH = 1;
  VARIABLE_PITCH = 2;
  MONO_FONT = 8;

  ANSI_CHARSET = 0;
  DEFAULT_CHARSET = 1;
  SYMBOL_CHARSET = 2;
  SHIFTJIS_CHARSET = $80;
  HANGEUL_CHARSET = 129;
  GB2312_CHARSET = 134;
  CHINESEBIG5_CHARSET = 136;
  OEM_CHARSET = 255;
  JOHAB_CHARSET = 130;
  HEBREW_CHARSET = 177;
  ARABIC_CHARSET = 178;
  GREEK_CHARSET = 161;
  TURKISH_CHARSET = 162;
  VIETNAMESE_CHARSET = 163;
  THAI_CHARSET = 222;
  EASTEUROPE_CHARSET = 238;
  RUSSIAN_CHARSET = 204;

  MAC_CHARSET = 77;
  BALTIC_CHARSET = 186;

  FS_LATIN1 = 1;
  FS_LATIN2 = 2;
  FS_CYRILLIC = 4;
  FS_GREEK = 8;
  FS_TURKISH = $10;
  FS_HEBREW = $20;
  FS_ARABIC = $40;
  FS_BALTIC = $80;
  FS_VIETNAMESE = $00000100;
  FS_THAI = $10000;
  FS_JISJAPAN = $20000;
  FS_CHINESESIMP = $40000;
  FS_WANSUNG = $80000;
  FS_CHINESETRAD = $100000;
  FS_JOHAB = $200000;
  FS_SYMBOL = DWORD($80000000);

  { Font Families }
  FF_DONTCARE   = (0 shl 4);     { Don't care or don't know. }
  FF_ROMAN      = (1 shl 4);     { Variable stroke width, serifed. }
                                 { Times Roman, Century Schoolbook, etc. }
  FF_SWISS      = (2 shl 4);     { Variable stroke width, sans-serifed. }
                                 { Helvetica, Swiss, etc. }
  FF_MODERN     = (3 shl 4);     { Constant stroke width, serifed or sans-serifed. }
                                 { Pica, Elite, Courier, etc. }
  FF_SCRIPT     = (4 shl 4);     { Cursive, etc. }
  FF_DECORATIVE = (5 shl 4);     { Old English, etc. }

  { Font Weights }
  FW_DONTCARE = 0;
  FW_THIN = 100;
  FW_EXTRALIGHT = 200;
  FW_LIGHT = 300;
  FW_NORMAL = 400;
  FW_MEDIUM = 500;
  FW_SEMIBOLD = 600;
  FW_BOLD = 700;
  FW_EXTRABOLD = 800;
  FW_HEAVY = 900;
  FW_ULTRALIGHT = FW_EXTRALIGHT;
  FW_REGULAR = FW_NORMAL;
  FW_DEMIBOLD = FW_SEMIBOLD;
  FW_ULTRABOLD = FW_EXTRABOLD;
  FW_BLACK = FW_HEAVY;

  PANOSE_COUNT = 10;
  PAN_FAMILYTYPE_INDEX = 0;
  PAN_SERIFSTYLE_INDEX = 1;
  PAN_WEIGHT_INDEX = 2;
  PAN_PROPORTION_INDEX = 3;
  PAN_CONTRAST_INDEX = 4;
  PAN_STROKEVARIATION_INDEX = 5;
  PAN_ARMSTYLE_INDEX = 6;
  PAN_LETTERFORM_INDEX = 7;
  PAN_MIDLINE_INDEX = 8;
  PAN_XHEIGHT_INDEX = 9;

  PAN_CULTURE_LATIN = 0;

  { Brush Styles }
  BS_SOLID                = 0;
  BS_NULL                 = 1;
  BS_HOLLOW               = BS_NULL;
  BS_HATCHED              = 2;
  BS_PATTERN              = 3;
  BS_INDEXED              = 4;
  BS_DIBPATTERN           = 5;
  BS_DIBPATTERNPT         = 6;
  BS_PATTERN8X8           = 7;
  BS_DIBPATTERN8X8        = 8;
  BS_MONOPATTERN          = 9;

  { Hatch Styles }
  HS_HORIZONTAL = 0;       { ----- }
  HS_VERTICAL   = 1;       { ||||| }
  HS_FDIAGONAL  = 2;       { ///// }
  HS_BDIAGONAL  = 3;       { \\\\\ }
  HS_CROSS      = 4;       { +++++ }
  HS_DIAGCROSS  = 5;       { xxxxx }

  { Pen Styles }
  PS_SOLID       = 0;
  PS_DASH        = 1;      { ------- }
  PS_DOT         = 2;      { ....... }
  PS_DASHDOT     = 3;      { _._._._ }
  PS_DASHDOTDOT  = 4;      { _.._.._ }
  PS_NULL = 5;
  PS_INSIDEFRAME = 6;
  PS_USERSTYLE = 7;
  PS_ALTERNATE = 8;
  PS_STYLE_MASK = 15;

  PS_ENDCAP_ROUND = 0;
  PS_ENDCAP_SQUARE = $100;
  PS_ENDCAP_FLAT = $200;
  PS_ENDCAP_MASK = 3840;

  PS_JOIN_ROUND = 0;
  PS_JOIN_BEVEL = $1000;
  PS_JOIN_MITER = $2000;
  PS_JOIN_MASK = 61440;

  PS_COSMETIC = 0;
  PS_GEOMETRIC = $10000;
  PS_TYPE_MASK = $F0000;

{ ExtFloodFill style flags }
  FLOODFILLBORDER = 0;
  FLOODFILLSURFACE = 1;

  ETO_OPAQUE = 2;
  ETO_CLIPPED = 4;
  ETO_GLYPH_INDEX = $10;
  ETO_RTLREADING = $80;
  ETO_NUMERICSLOCAL = $400;
  ETO_NUMERICSLATIN = $800;
  ETO_IGNORELANGUAGE = $1000;
  ETO_PDY = $2000;

  { GetSystemMetrics() codes }
  SM_CXSCREEN = 0;
  SM_CYSCREEN = 1;
  SM_CXVSCROLL = 2;
  SM_CYHSCROLL = 3;
  SM_CYCAPTION = 4;
  SM_CXBORDER = 5;
  SM_CYBORDER = 6;
  SM_CXDLGFRAME = 7;
  SM_CYDLGFRAME = 8;
  SM_CYVTHUMB = 9;
  SM_CXHTHUMB = 10;
  SM_CXICON = 11;
  SM_CYICON = 12;
  SM_CXCURSOR = 13;
  SM_CYCURSOR = 14;
  SM_CYMENU = 15;
  SM_CXFULLSCREEN = $10;
  SM_CYFULLSCREEN = 17;
  SM_CYKANJIWINDOW = 18;
  SM_MOUSEPRESENT = 19;
  SM_CYVSCROLL = 20;
  SM_CXHSCROLL = 21;
  SM_DEBUG = 22;
  SM_SWAPBUTTON = 23;
  SM_RESERVED1 = 24;
  SM_RESERVED2 = 25;
  SM_RESERVED3 = 26;
  SM_RESERVED4 = 27;
  SM_CXMIN = 28;
  SM_CYMIN = 29;
  SM_CXSIZE = 30;
  SM_CYSIZE = 31;
  SM_CXFRAME = $20;
  SM_CYFRAME = 33;
  SM_CXMINTRACK = 34;
  SM_CYMINTRACK = 35;
  SM_CXDOUBLECLK = 36;
  SM_CYDOUBLECLK = 37;
  SM_CXICONSPACING = 38;
  SM_CYICONSPACING = 39;
  SM_MENUDROPALIGNMENT = 40;
  SM_PENWINDOWS = 41;
  SM_DBCSENABLED = 42;
  SM_CMOUSEBUTTONS = 43;

  SM_CXFIXEDFRAME = SM_CXDLGFRAME; { win40 name change }
  SM_CYFIXEDFRAME = SM_CYDLGFRAME; { win40 name change }
  SM_CXSIZEFRAME = SM_CXFRAME;     { win40 name change }
  SM_CYSIZEFRAME = SM_CYFRAME;     { win40 name change }

  SM_SECURE = 44;
  SM_CXEDGE = 45;
  SM_CYEDGE = 46;
  SM_CXMINSPACING = 47;
  SM_CYMINSPACING = 48;
  SM_CXSMICON = 49;
  SM_CYSMICON = 50;
  SM_CYSMCAPTION = 51;
  SM_CXSMSIZE = 52;
  SM_CYSMSIZE = 53;
  SM_CXMENUSIZE = 54;
  SM_CYMENUSIZE = 55;
  SM_ARRANGE = 56;
  SM_CXMINIMIZED = 57;
  SM_CYMINIMIZED = 58;
  SM_CXMAXTRACK = 59;
  SM_CYMAXTRACK = 60;
  SM_CXMAXIMIZED = 61;
  SM_CYMAXIMIZED = 62;
  SM_NETWORK = 63;
  SM_CLEANBOOT = 67;
  SM_CXDRAG = 68;
  SM_CYDRAG = 69;
  SM_SHOWSOUNDS = 70;
  SM_CXMENUCHECK = 71;     { Use instead of GetMenuCheckMarkDimensions()! }
  SM_CYMENUCHECK = 72;
  SM_SLOWMACHINE = 73;
  SM_MIDEASTENABLED = 74;
  SM_MOUSEWHEELPRESENT = 75;
  SM_CMETRICS = 76;

  { Predefined Clipboard Formats }
  CF_TEXT = 1;
  CF_BITMAP = 2;
  CF_METAFILEPICT = 3;
  CF_SYLK = 4;
  CF_DIF = 5;
  CF_TIFF = 6;
  CF_OEMTEXT = 7;
  CF_DIB = 8;
  CF_PALETTE = 9;
  CF_PENDATA = 10;
  CF_RIFF = 11;
  CF_WAVE = 12;
  CF_UNICODETEXT = 13;
  CF_ENHMETAFILE = 14;
  CF_HDROP = 15;
  CF_LOCALE = $10;
  CF_MAX = 17;

  CF_OWNERDISPLAY = 128;
  CF_DSPTEXT = 129;
  CF_DSPBITMAP = 130;
  CF_DSPMETAFILEPICT = 131;
  CF_DSPENHMETAFILE = 142;

  ENHMETA_SIGNATURE = $464D4520;  { Enhanced metafile constants. }

  { Mapping Modes }
  MM_TEXT = 1;
  MM_LOMETRIC = 2;
  MM_HIMETRIC = 3;
  MM_LOENGLISH = 4;
  MM_HIENGLISH = 5;
  MM_TWIPS = 6;
  MM_ISOTROPIC = 7;
  MM_ANISOTROPIC = 8;

{ Enhanced metafile record types.}

  EMR_HEADER = 1;
  EMR_POLYBEZIER = 2;
  EMR_POLYGON = 3;
  EMR_POLYLINE = 4;
  EMR_POLYBEZIERTO = 5;
  EMR_POLYLINETO = 6;
  EMR_POLYPOLYLINE = 7;
  EMR_POLYPOLYGON = 8;
  EMR_SETWINDOWEXTEX = 9;
  EMR_SETWINDOWORGEX = 10;
  EMR_SETVIEWPORTEXTEX = 11;
  EMR_SETVIEWPORTORGEX = 12;
  EMR_SETBRUSHORGEX = 13;
  EMR_EOF = 14;
  EMR_SETPIXELV = 15;
  EMR_SETMAPPERFLAGS = $10;
  EMR_SETMAPMODE = 17;
  EMR_SETBKMODE = 18;
  EMR_SETPOLYFILLMODE = 19;
  EMR_SETROP2 = 20;
  EMR_SETSTRETCHBLTMODE = 21;
  EMR_SETTEXTALIGN = 22;
  EMR_SETCOLORADJUSTMENT = 23;
  EMR_SETTEXTCOLOR = 24;
  EMR_SETBKCOLOR = 25;
  EMR_OFFSETCLIPRGN = 26;
  EMR_MOVETOEX = 27;
  EMR_SETMETARGN = 28;
  EMR_EXCLUDECLIPRECT = 29;
  EMR_INTERSECTCLIPRECT = 30;
  EMR_SCALEVIEWPORTEXTEX = 31;
  EMR_SCALEWINDOWEXTEX = 32;
  EMR_SAVEDC = 33;
  EMR_RESTOREDC = 34;
  EMR_SETWORLDTRANSFORM = 35;
  EMR_MODIFYWORLDTRANSFORM = 36;
  EMR_SELECTOBJECT = 37;
  EMR_CREATEPEN = 38;
  EMR_CREATEBRUSHINDIRECT = 39;
  EMR_DELETEOBJECT = 40;
  EMR_ANGLEARC = 41;
  EMR_ELLIPSE = 42;
  EMR_RECTANGLE = 43;
  EMR_ROUNDRECT = 44;
  EMR_ARC = 45;
  EMR_CHORD = 46;
  EMR_PIE = 47;
  EMR_SELECTPALETTE = 48;
  EMR_CREATEPALETTE = 49;
  EMR_SETPALETTEENTRIES = 50;
  EMR_RESIZEPALETTE = 51;
  EMR_REALIZEPALETTE = 52;
  EMR_EXTFLOODFILL = 53;
  EMR_LINETO = 54;
  EMR_ARCTO = 55;
  EMR_POLYDRAW = 56;
  EMR_SETARCDIRECTION = 57;
  EMR_SETMITERLIMIT = 58;
  EMR_BEGINPATH = 59;
  EMR_ENDPATH = 60;
  EMR_CLOSEFIGURE = 61;
  EMR_FILLPATH = 62;
  EMR_STROKEANDFILLPATH = 63;
  EMR_STROKEPATH = $40;
  EMR_FLATTENPATH = 65;
  EMR_WIDENPATH = 66;
  EMR_SELECTCLIPPATH = 67;
  EMR_ABORTPATH = 68;

  EMR_GDICOMMENT = 70;
  EMR_FILLRGN = 71;
  EMR_FRAMERGN = 72;
  EMR_INVERTRGN = 73;
  EMR_PAINTRGN = 74;
  EMR_EXTSELECTCLIPRGN = 75;
  EMR_BITBLT = 76;
  EMR_STRETCHBLT = 77;
  EMR_MASKBLT = 78;
  EMR_PLGBLT = 79;
  EMR_SETDIBITSTODEVICE = 80;
  EMR_STRETCHDIBITS = 81;
  EMR_EXTCREATEFONTINDIRECTW = 82;
  EMR_EXTTEXTOUTA = 83;
  EMR_EXTTEXTOUTW = 84;
  EMR_POLYBEZIER16 = 85;
  EMR_POLYGON16 = 86;
  EMR_POLYLINE16 = 87;
  EMR_POLYBEZIERTO16 = 88;
  EMR_POLYLINETO16 = 89;
  EMR_POLYPOLYLINE16 = 90;
  EMR_POLYPOLYGON16 = 91;
  EMR_POLYDRAW16 = 92;
  EMR_CREATEMONOBRUSH = 93;
  EMR_CREATEDIBPATTERNBRUSHPT = 94;
  EMR_EXTCREATEPEN = 95;
  EMR_POLYTEXTOUTA = 96;
  EMR_POLYTEXTOUTW = 97;
  EMR_SETICMMODE = 98;
  EMR_CREATECOLORSPACE = 99;
  EMR_SETCOLORSPACE = 100;
  EMR_DELETECOLORSPACE = 101;
  EMR_GLSRECORD = 102;
  EMR_GLSBOUNDEDRECORD = 103;
  EMR_PIXELFORMAT = 104;
  EMR_DRAWESCAPE = 105;
  EMR_EXTESCAPE = 106;
  EMR_STARTDOC = 107;
  EMR_SMALLTEXTOUT = 108;
  EMR_FORCEUFIMAPPING = 109;
  EMR_NAMEDESCAPE = 110;
  EMR_COLORCORRECTPALETTE = 111;
  EMR_SETICMPROFILEA = 112;
  EMR_SETICMPROFILEW = 113;
  EMR_ALPHABLEND = 114;
  EMR_ALPHADIBBLEND = 115;
  EMR_TRANSPARENTBLT = 116;
  EMR_TRANSPARENTDIB = 117;
  EMR_GRADIENTFILL = 118;
  EMR_SETLINKEDUFIS = 119;
  EMR_SETTEXTJUSTIFICATION = 120;
  EMR_MAX = 120;
  EMR_MIN = 1;

  { Predefined Resource Types }
  RT_CURSOR       = 1;  // MakeIntResource(1);
  RT_BITMAP       = 2;  // MakeIntResource(2);
  RT_ICON         = 3;  // MakeIntResource(3);
  RT_MENU         = 4;  // MakeIntResource(4);
  RT_DIALOG       = 5;  // MakeIntResource(5);
  RT_STRING       = 6;  // MakeIntResource(6);
  RT_FONTDIR      = 7;  // MakeIntResource(7);
  RT_FONT         = 8;  // MakeIntResource(8);
  RT_ACCELERATOR  = 9;  // MakeIntResource(9);
  RT_RCDATA       = 10;  // MakeIntResource(10);
  RT_MESSAGETABLE = 11;  // MakeIntResource(11);

  { StretchBlt() Modes }
  BLACKONWHITE = 1;
  WHITEONBLACK = 2;
  COLORONCOLOR = 3;
  HALFTONE = 4;
  MAXSTRETCHBLTMODE = 4;
  { New StretchBlt() Modes }
  STRETCH_ANDSCANS = BLACKONWHITE;
  STRETCH_ORSCANS = WHITEONBLACK;
  STRETCH_DELETESCANS = COLORONCOLOR;
  STRETCH_HALFTONE = HALFTONE;

  DI_MASK = 1;
  DI_IMAGE = 2;
  DI_NORMAL = 3;
  DI_COMPAT = 4;
  DI_DEFAULTSIZE = 8;

  { Stock Logical Objects }
  WHITE_BRUSH = 0;
  LTGRAY_BRUSH = 1;
  GRAY_BRUSH = 2;
  DKGRAY_BRUSH = 3;
  BLACK_BRUSH = 4;
  NULL_BRUSH = 5;
  HOLLOW_BRUSH = NULL_BRUSH;
  WHITE_PEN = 6;
  BLACK_PEN = 7;
  NULL_PEN = 8;
  OEM_FIXED_FONT = 10;
  ANSI_FIXED_FONT = 11;
  ANSI_VAR_FONT = 12;
  SYSTEM_FONT = 13;
  DEVICE_DEFAULT_FONT = 14;
  DEFAULT_PALETTE = 15;
  SYSTEM_FIXED_FONT = $10;
  DEFAULT_GUI_FONT = 17;
  DC_BRUSH = 18;
  DC_PEN = 19;
  STOCK_LAST = 19;

  { Standard Icon IDs }
  IDI_APPLICATION = 32512; // MakeIntResource(32512);
  IDI_HAND = 32513; // MakeIntResource(32513);
  IDI_QUESTION = 32514; // MakeIntResource(32514);
  IDI_EXCLAMATION = 32515; // MakeIntResource(32515);
  IDI_ASTERISK = 32516; // MakeIntResource(32516);
  IDI_WINLOGO = 32517; // MakeIntResource(32517);
  IDI_WARNING = IDI_EXCLAMATION;
  IDI_ERROR = IDI_HAND;
  IDI_INFORMATION = IDI_ASTERISK;

type
  //DWORD = LongWord;
  BOOL = LongBool;
  PBOOL = ^BOOL;
  PByte = ^Byte;
  PINT = ^Integer;
  PSingle = ^Single;
  PWORD = ^Word;
  PDWORD = ^DWORD;
  LPDWORD = PDWORD;

  UCHAR = Byte;
  PUCHAR = ^Byte;
  SHORT = Smallint;
  UINT = LongWord;
  PUINT = ^UINT;
  ULONG = Cardinal;
  PULONG = ^ULONG;
  PLongint = ^Longint;
  PInteger = ^Integer;
  PLongWord = ^LongWord;
  PSmallInt = ^Smallint;
  PDouble = ^Double;
  PShortInt = ^ShortInt;

  THandle = LongWord;
  PHandle = ^THandle;

  HWND = type LongWord;

  HGDIOBJ = type LongWord;
  HACCEL = type LongWord;
  HBITMAP = type LongWord;
  HBRUSH = type LongWord;
  HCOLORSPACE = type LongWord;
  HDC = type LongWord;
  HGLRC = type LongWord;
  HDESK = type LongWord;
  HENHMETAFILE = type LongWord;
  HFONT = type LongWord;
  HICON = type LongWord;
  HMENU = type LongWord;
  HMETAFILE = type LongWord;
  HINST = type LongWord;
  HMODULE = HINST;              { HMODULEs can be used in place of HINSTs }
  HPALETTE = type LongWord;
  HPEN = type LongWord;
  HRGN = type LongWord;
  HRSRC = type LongWord;
  HSTR = type LongWord;
  HTASK = type LongWord;
  HWINSTA = type LongWord;
  HKL = type LongWord;

  HGLOBAL = THandle;

  HFILE = LongWord;
  HCURSOR = HICON;              { HICONs & HCURSORs are polymorphic }

  COLORREF = DWORD;
  TColorRef = DWORD;

{From Forms.pas:}  
  TModalResult = Low(Integer)..High(Integer);

  PListEntry = ^TListEntry;
  _LIST_ENTRY = record
    Flink: PListEntry;
    Blink: PListEntry;
  end;
  TListEntry = _LIST_ENTRY;
  LIST_ENTRY = _LIST_ENTRY;

  PRTLCriticalSection = ^TRTLCriticalSection;
  PRTLCriticalSectionDebug = ^TRTLCriticalSectionDebug;
  _RTL_CRITICAL_SECTION_DEBUG = record
    Type_18: Word;
    CreatorBackTraceIndex: Word;
    CriticalSection: PRTLCriticalSection;
    ProcessLocksList: TListEntry;
    EntryCount: DWORD;
    ContentionCount: DWORD;
    Spare: array[0..1] of DWORD;
  end;
  TRTLCriticalSectionDebug = _RTL_CRITICAL_SECTION_DEBUG;
  RTL_CRITICAL_SECTION_DEBUG = _RTL_CRITICAL_SECTION_DEBUG;

  _RTL_CRITICAL_SECTION = record
    DebugInfo: PRTLCriticalSectionDebug;
    LockCount: Longint;
    RecursionCount: Longint;
    OwningThread: THandle;
    LockSemaphore: THandle;
    Reserved: DWORD;
  end;
  TRTLCriticalSection = _RTL_CRITICAL_SECTION;
  RTL_CRITICAL_SECTION = _RTL_CRITICAL_SECTION;

  PPoint = ^TPoint;
  TPoint = record
    x: Longint;
    y: Longint;
  end;
  {$NODEFINE TPoint}
  tagPOINT = TPoint;
  {$NODEFINE tagPOINT}

  PRect = ^TRect;

  TRect = record
    case Integer of
      0: (Left, Top, Right, Bottom: Integer);
      1: (TopLeft, BottomRight: TPoint);
  end;

  (*$HPPEMIT 'namespace gdWindows'*)
  (*$HPPEMIT '{'*)
  (*$HPPEMIT '  struct TPoint : public POINT'*)
  (*$HPPEMIT '  {'*)
  (*$HPPEMIT '    TPoint() {}'*)
  (*$HPPEMIT '    TPoint(int _x, int _y) { x=_x; y=_y; }'*)
  (*$HPPEMIT '    TPoint(POINT& pt)'*)
  (*$HPPEMIT '    {'*)
  (*$HPPEMIT '      x = pt.x;'*)
  (*$HPPEMIT '      y = pt.y;'*)
  (*$HPPEMIT '    }'*)
  (*$HPPEMIT '  };'*)
  (*$HPPEMIT ' '*)
  (*$HPPEMIT '  struct TRect : public RECT'*)
  (*$HPPEMIT '  {'*)
  (*$HPPEMIT '    TRect() {}'*)
  (*$HPPEMIT '    TRect(const TPoint& TL, const TPoint& BR) { left=TL.x; top=TL.y; right=BR.x; bottom=BR.y; }'*)
  (*$HPPEMIT '    TRect(int l, int t, int r, int b)         { left=l;    top=t;    right=r;    bottom=b;    }'*)
  (*$HPPEMIT '    TRect(RECT& r)'*)
  (*$HPPEMIT '    {'*)
  (*$HPPEMIT '      left    = r.left;'*)
  (*$HPPEMIT '      top     = r.top;'*)
  (*$HPPEMIT '      right   = r.right;'*)
  (*$HPPEMIT '      bottom  = r.bottom;'*)
  (*$HPPEMIT '    }'*)
  (*$HPPEMIT '    int Width () const { return right  - left; }'*)
  (*$HPPEMIT '    int Height() const { return bottom - top ; }'*)
  (*$HPPEMIT '    bool operator ==(const TRect& rc) const '*)
  (*$HPPEMIT '    {'*)
  (*$HPPEMIT '       return left ==  rc.left  && top==rc.top &&     '*)
  (*$HPPEMIT '              right == rc.right && bottom==rc.bottom; '*)
  (*$HPPEMIT '    }'*)
  (*$HPPEMIT '    bool operator !=(const TRect& rc) const '*)
  (*$HPPEMIT '    {  return !(rc==*this); }'*)
  (*$HPPEMIT ' '*)
  (*$HPPEMIT '       __property LONG Left    = { read=left,   write=left   }; '*)
  (*$HPPEMIT '       __property LONG Top     = { read=top,       write=top }; '*)
  (*$HPPEMIT '       __property LONG Right   = { read=right,  write=right  }; '*)
  (*$HPPEMIT '       __property LONG Bottom  = { read=bottom, write=bottom }; '*)
  (*$HPPEMIT '  };'*)
  (*$HPPEMIT '} /* namespace gdWindows */'*)

  PSmallRect = ^TSmallRect;
  _SMALL_RECT = packed record
    Left: SHORT;
    Top: SHORT;
    Right: SHORT;
    Bottom: SHORT;
  end;
  TSmallRect = _SMALL_RECT;
  SMALL_RECT = _SMALL_RECT;

  _POINTL = packed record      { ptl }
    x: Longint;
    y: Longint;
  end;
  PPointL = ^TPointL;
  TPointL = _POINTL;

  PSize = ^TSize;
  tagSIZE = record
    cx: Longint;
    cy: Longint;
  end;
  TSize = tagSIZE;
  SIZE = tagSIZE;

  PSmallPoint = ^TSmallPoint;
  TSmallPoint = packed record
    x: SHORT;
    y: SHORT;
  end;

  PPanose = ^TPanose;
  tagPANOSE = packed record
    bFamilyType: Byte;
    bSerifStyle: Byte;
    bWeight: Byte;
    bProportion: Byte;
    bContrast: Byte;
    bStrokeVariation: Byte;
    bArmStyle: Byte;
    bLetterform: Byte;
    bMidline: Byte;
    bXHeight: Byte;
  end;
  TPanose = tagPANOSE;
  PANOSE = tagPANOSE;

  PLogFont = ^tagLogFont;
  tagLOGFONT = packed record
    lfHeight: Longint;
    lfWidth: Longint;
    lfEscapement: Longint;
    lfOrientation: Longint;
    lfWeight: Longint;
    lfItalic: Byte;
    lfUnderline: Byte;
    lfStrikeOut: Byte;
    lfCharSet: Byte;
    lfOutPrecision: Byte;
    lfClipPrecision: Byte;
    lfQuality: Byte;
    lfPitchAndFamily: Byte;
    lfFaceName: array[0..LF_FACESIZE - 1] of AnsiChar;
  end;
  TLogFont = tagLogFont;
  LOGFONT = tagLogFont;

  PLogPen = ^TLogPen;
  tagLOGPEN = packed record
    lopnStyle: UINT;
    lopnWidth: TPoint;
    lopnColor: COLORREF;
  end;
  TLogPen = tagLOGPEN;
  LOGPEN = tagLOGPEN;

  PLogBrush = ^TLogBrush;
  tagLOGBRUSH = packed record
    lbStyle: UINT;
    lbColor: COLORREF;
    lbHatch: Longint;
  end;
  TLogBrush = tagLOGBRUSH;
  LOGBRUSH = tagLOGBRUSH;

  PRGBTriple = ^TRGBTriple;
  tagRGBTRIPLE = packed record
    rgbtBlue: Byte;
    rgbtGreen: Byte;
    rgbtRed: Byte;
  end;
  TRGBTriple = tagRGBTRIPLE;
  RGBTRIPLE = tagRGBTRIPLE;

  PRGBQuad = ^TRGBQuad;
  tagRGBQUAD = packed record
    rgbBlue: Byte;
    rgbGreen: Byte;
    rgbRed: Byte;
    rgbReserved: Byte;
  end;
  TRGBQuad = tagRGBQUAD;
  RGBQUAD = tagRGBQUAD;

  PBitmapFileHeader = ^TBitmapFileHeader;
  tagBITMAPFILEHEADER = packed record
    bfType: Word;
    bfSize: DWORD;
    bfReserved1: Word;
    bfReserved2: Word;
    bfOffBits: DWORD;
  end;
  TBitmapFileHeader = tagBITMAPFILEHEADER;
  BITMAPFILEHEADER = tagBITMAPFILEHEADER;

  PBitmapCoreHeader = ^TBitmapCoreHeader;
  tagBITMAPCOREHEADER = packed record
    bcSize: DWORD;
    bcWidth: Word;
    bcHeight: Word;
    bcPlanes: Word;
    bcBitCount: Word;
  end;
  TBitmapCoreHeader = tagBITMAPCOREHEADER;
  BITMAPCOREHEADER = tagBITMAPCOREHEADER;

  PBitmapInfoHeader = ^TBitmapInfoHeader;
  tagBITMAPINFOHEADER = packed record
    biSize: DWORD;
    biWidth: Longint;
    biHeight: Longint;
    biPlanes: Word;
    biBitCount: Word;
    biCompression: DWORD;
    biSizeImage: DWORD;
    biXPelsPerMeter: Longint;
    biYPelsPerMeter: Longint;
    biClrUsed: DWORD;
    biClrImportant: DWORD;
  end;
  TBitmapInfoHeader = tagBITMAPINFOHEADER;
  BITMAPINFOHEADER = tagBITMAPINFOHEADER;

{ Bitmap Header Definition }
  PWinBitmap = ^TWinBitmap;
  tagBITMAP = packed record
    bmType: Longint;
    bmWidth: Longint;
    bmHeight: Longint;
    bmWidthBytes: Longint;
    bmPlanes: Word;
    bmBitsPixel: Word;
    bmBits: Pointer;
  end;
  TWinBitmap = tagBITMAP;
  BITMAP = tagBITMAP;

  PBitmapInfo = ^TBitmapInfo;
  tagBITMAPINFO = packed record
    bmiHeader: TBitmapInfoHeader;
    bmiColors: array[0..0] of TRGBQuad;
  end;
  TBitmapInfo = tagBITMAPINFO;
  BITMAPINFO = tagBITMAPINFO;

  PDIBSection = ^TDIBSection;
  tagDIBSECTION = packed record
    dsBm: TWinBitmap;
    dsBmih: TBitmapInfoHeader;
    dsBitfields: array[0..2] of DWORD;
    dshSection: THandle;
    dsOffset: DWORD;
  end;
  TDIBSection = tagDIBSECTION;
  DIBSECTION = tagDIBSECTION;

  PPaletteEntry = ^TPaletteEntry;
  {$EXTERNALSYM tagPALETTEENTRY}
  tagPALETTEENTRY = packed record
    peRed: Byte;
    peGreen: Byte;
    peBlue: Byte;
    peFlags: Byte;
  end;
  TPaletteEntry = tagPALETTEENTRY;
  {$EXTERNALSYM PALETTEENTRY}
  PALETTEENTRY = tagPALETTEENTRY;


  { Logical Palette }
  PLogPalette = ^TLogPalette;
  tagLOGPALETTE = packed record
    palVersion: Word;
    palNumEntries: Word;
    palPalEntry: array[0..0] of TPaletteEntry;
  end;
  TLogPalette = tagLOGPALETTE;
  LOGPALETTE = tagLOGPALETTE;

  PMaxLogPalette = ^TMaxLogPalette; // not in Windows Headers
  TMaxLogPalette = packed record
    palVersion: Word;
    palNumEntries: Word;
    palPalEntry: array [Byte] of TPaletteEntry;
  end;

  PIconInfo = ^TIconInfo;
  _ICONINFO = packed record
    fIcon: BOOL;
    xHotspot: DWORD;
    yHotspot: DWORD;
    hbmMask: HBITMAP;
    hbmColor: HBITMAP;
  end;
  TIconInfo = _ICONINFO;
  ICONINFO = _ICONINFO;

  PMetaRecord = ^TMetaRecord;
  tagMETARECORD = packed record
    rdSize: DWORD;
    rdFunction: Word;
    rdParm: array[0..0] of Word;
  end;
  TMetaRecord = tagMETARECORD;
  METARECORD = tagMETARECORD;

  PMetafilePict = ^TMetafilePict;
  tagMETAFILEPICT = packed record
    mm: Longint;
    xExt: Longint;
    yExt: Longint;
    hMF: HMETAFILE;
  end;
  TMetafilePict = tagMETAFILEPICT;
  METAFILEPICT = tagMETAFILEPICT;

  PMetaHeader = ^TMetaHeader;
  tagMETAHEADER = packed record
    mtType: Word;
    mtHeaderSize: Word;
    mtVersion: Word;
    mtSize: DWORD;
    mtNoObjects: Word;
    mtMaxRecord: DWORD;
    mtNoParameters: Word;
  end;
  TMetaHeader = tagMETAHEADER;
  METAHEADER = tagMETAHEADER;

  { Enhanced Metafile structures }

  PEnhMetaRecord = ^TEnhMetaRecord;
  tagENHMETARECORD = packed record
    iType: DWORD; { Record type EMR_XXX}
    nSize: DWORD; { Record size in bytes}
    dParm: array[0..0] of DWORD; { Parameters}
  end;
  TEnhMetaRecord = tagENHMETARECORD;
  ENHMETARECORD = tagENHMETARECORD;

  PEnhMetaHeader = ^TEnhMetaHeader;
  tagENHMETAHEADER = packed record
    iType: DWORD;          { Record type EMR_HEADER}
    nSize: DWORD;          { Record size in bytes.  This may be greater
                             than the sizeof(TEnhMetaHeader). }
    rclBounds: TRect;     { Inclusive-inclusive bounds in device units}
    rclFrame: TRect;      { Inclusive-inclusive Picture Frame of metafile in .01 mm units}
    dSignature: DWORD;     { Signature.  Must be ENHMETA_SIGNATURE.}
    nVersion: DWORD;       { Version number}
    nBytes: DWORD;         { Size of the metafile in bytes}
    nRecords: DWORD;       { Number of records in the metafile}
    nHandles: Word;        { Number of handles in the handle table
                             Handle index zero is reserved. }
    sReserved: Word;       { Reserved.  Must be zero.}
    nDescription: DWORD;   { Number of chars in the unicode description string
                             This is 0 if there is no description string }
    offDescription: DWORD; { Offset to the metafile description record. }
                           { This is 0 if there is no description string }
    nPalEntries: DWORD;    { Number of entries in the metafile palette.}
    szlDevice: TSize;      { Size of the reference device in pels}
    szlMillimeters: TSize; { Size of the reference device in millimeters}
    cbPixelFormat: DWORD;  { Size of TPixelFormatDescriptor information }
                           { This is 0 if no pixel format is set }
    offPixelFormat: DWORD; { Offset to TPixelFormatDescriptor }
                           { This is 0 if no pixel format is set }
    bOpenGL: DWORD;        { True if OpenGL commands are present in }
                           { the metafile, otherwise FALSE }
  end;
  TEnhMetaHeader = tagENHMETAHEADER;
  ENHMETAHEADER = tagENHMETAHEADER;

  PTextMetric = ^TTextMetric;
  tagTEXTMETRIC = record
    tmHeight: Longint;
    tmAscent: Longint;
    tmDescent: Longint;
    tmInternalLeading: Longint;
    tmExternalLeading: Longint;
    tmAveCharWidth: Longint;
    tmMaxCharWidth: Longint;
    tmWeight: Longint;
    tmOverhang: Longint;
    tmDigitizedAspectX: Longint;
    tmDigitizedAspectY: Longint;
    tmFirstChar: AnsiChar;
    tmLastChar: AnsiChar;
    tmDefaultChar: AnsiChar;
    tmBreakChar: AnsiChar;
    tmItalic: Byte;
    tmUnderlined: Byte;
    tmStruckOut: Byte;
    tmPitchAndFamily: Byte;
    tmCharSet: Byte;
  end;
  TTextMetric = tagTEXTMETRIC;
  TEXTMETRIC = tagTEXTMETRIC;

{A horrible macro:}
function MakeIntResource(RT: Integer): PChar;
{Two Delphi functions from oddball units:}
function Rect(ALeft, ATop, ARight, ABottom: Integer): TRect;
function Point(AX, AY: Integer): TPoint;

implementation

{#define MAKEINTRESOURCE(i)  (LPTSTR) ((DWORD) ((WORD) (i)))}
function MakeIntResource(RT: Integer): PChar;
begin
  Result := nil;
end;

function Rect(ALeft, ATop, ARight, ABottom: Integer): TRect;
begin
  with Result do
  begin
    Left := ALeft;
    Top := ATop;
    Right := ARight;
    Bottom := ABottom;
  end;
end;

function Point(AX, AY: Integer): TPoint;
begin
  with Result do
  begin
    X := AX;
    Y := AY;
  end;
end;


end.
