unit gd_io;

{Translation of E:\DATA\delphi\Apps\Trans\gd.h}
{16/09/2002 2:55:33 PM}

interface

uses
  SysUtils, Classes;

type
{Simple types:}
  PInteger = ^Integer;

  PgdIOCtx = Pointer;

{Function Prototypes:}
  TOngetC = procedure(struct: PgdIOCtx );
  TOnputC = procedure(struct: PgdIOCtx; Value: Integer);
  TOngetBuf = procedure(struct: PgdIOCtx ; ptr: Pointer; Value: Integer);
  TOnputBuf = procedure(struct: PgdIOCtx ; const ptr: Pointer; Value: Integer);
  TOnseek = procedure(struct: PgdIOCtx ; const Value: Integer);
  TOntell = procedure(struct: PgdIOCtx );
  TOnfree = procedure(struct: PgdIOCtx );

{Records:}
  gdIOCtx = record
    getC: TOngetC;
    getBuf: TOngetBuf;
    putC: TOnputC;
    putBuf: TOnputBuf;
    seek: TOnseek;
    tell: TOnTell;
    free: TOnFree;
  end;
  {$EXTERNALSYM gdIOCtx}
  TgdIOCtx = gdIOCtx;
  gdIOCtxPtr = ^TgdIOCtx;
  //PgdIOCtx = ^TgdIOCtx;

  procedure Putword(w: Integer; ctx: PgdIOCtx); cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  procedure Putchar(c: Integer; ctx: PgdIOCtx); cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};

  procedure gdPutC(const c: Byte; ctx: PgdIOCtx); cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  function gdPutBuf(const Ptr: Pointer; AnInt: Integer; ctx: PgdIOCtx): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  procedure gdPutWord(w: Integer; ctx: PgdIOCtx); cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  procedure gdPutInt(w: Integer; ctx: PgdIOCtx); cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};

  function gdGetC(ctx: PgdIOCtx): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  function gdGetBuf(Ptr: Pointer; AnInt: Integer; ctx: PgdIOCtx): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  function gdGetByte(result: PInteger; ctx: PgdIOCtx): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  function gdGetWord(result: PInteger; ctx: PgdIOCtx): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  function gdGetInt(result: PInteger; ctx: PgdIOCtx): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};

  function gdSeek(ctx: PgdIOCtx; const Value: Integer): Integer; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};
  function gdTell(ctx: PgdIOCtx): LongInt; cdecl; external {$IFDEF WIN32}'gd_io.dll'{$ENDIF}{$IFDEF LINUX}'libgd_io.so'{$ENDIF};

implementation
begin
end.
