From - Fri Mar 30 14:19:56 2001
From: Stefan Hoffmeister <Borland.Newsgroups@econos.com>
Newsgroups: borland.public.kylix.graphics
Subject: Re: "invalid resource format" can't load bitmap resource
Date: Thu, 29 Mar 2001 13:27:57 +0200
Organization: .
Message-ID: <7a66ctc0n94kontjf4npp34h2um6kuelcv@4ax.com>
References: <3ABFE809.6D23B688@molsci.csiro.au>
X-Newsreader: Forte Agent 1.8/32.548
MIME-Version: 1.0
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 7bit
NNTP-Posting-Host: 62.226.148.65
X-Trace: 29 Mar 2001 03:25:47 -0800, 62.226.148.65
Lines: 86
Path: dnews!62.226.148.65
Xref: dnews borland.public.kylix.graphics:148

>    TheBitmap.LoadFromResourceID(HInstance, IMAGE_BASE + i);

>under Kylix, i get the error message:
>
>"EInvalidGraphicOperation: Image format not recognized. Process stopped
>..."

Yep.

Try replacing the code in QGraphics with the piece below; as Jon
indicates, some fixup is missing.

This at least no longer throws an exception, but I don't know what this
code is supposed to do.

*************

procedure LoadBitmapFromResourceStream(ABitmap: TBitmap; ResourceStream:
TCustomMemoryStream);
var
  TmpStream: TMemoryStream;
  Header: TBitmapFileHeader;
  BmpHeader: TBitMapInfoHeader;
begin
  TmpStream := TMemoryStream.Create;
  try
    // Reads bitmap header
    ResourceStream.ReadBuffer(BmpHeader, SizeOf(BmpHeader));
    ResourceStream.Seek(0, soBeginning);

    // Builds file header
    FillChar(Header, SizeOf(Header), 0);
    Header.bfType := $4D42;
    Header.bfSize := ResourceStream.Size;
    Header.bfReserved1 := 0;
    Header.bfReserved2 := 0;

    if BmpHeader.biBitCount > 8 then
      Header.bfOffBits := sizeof(Header) + sizeof(BmpHeader)
    else
      if BmpHeader.biClrUsed = 0 then
        Header.bfOffBits := sizeof(Header) + sizeof(BmpHeader) + (1 shl
BmpHeader.biBitCount) * 4
      else
        Header.bfOffBits := sizeof(Header) + sizeof(BmpHeader) +
BmpHeader.biClrUsed * 4;

    // Concatenates both in TmpStream
    TmpStream.WriteBuffer(Header, SizeOf(Header));
    TmpStream.CopyFrom(ResourceStream, ResourceStream.Size);
    TmpStream.Position := 0;
    ABitmap.LoadFromStream(TmpStream);
  finally
    TmpStream.Free;
  end;
end;

procedure TBitmap.LoadFromResourceName(Instance: Cardinal; const
ResName: string);
var
  Stream: TCustomMemoryStream;
begin
  Stream := TResourceStream.Create(Instance, ResName, RT_BITMAP);
  try
    LoadBitmapFromResourceStream(Self, Stream);
  finally
    Stream.Free;
  end;
end;

procedure TBitmap.LoadFromResourceID(Instance: Cardinal; ResID:
Integer);
var
  Stream: TCustomMemoryStream;
begin
  Stream := TResourceStream.CreateFromID(Instance, ResID, RT_BITMAP);
  try
    LoadBitmapFromResourceStream(Self, Stream);
  finally
    Stream.Free;
  end;
end;

-- 
NNQ - Quoting Style in Newsgroup Postings
  http://web.infoave.net/~dcalhoun/nnq/nquote.html
